/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.collections.immutable.implementations.immutableSet;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMutableIterator;
import kotlinx.collections.immutable.implementations.immutableSet.PersistentHashSetBuilder;
import kotlinx.collections.immutable.implementations.immutableSet.PersistentHashSetIterator;
import kotlinx.collections.immutable.implementations.immutableSet.TrieNode;
import kotlinx.collections.immutable.implementations.immutableSet.TrieNodeKt;
import kotlinx.collections.immutable.internal.CommonFunctionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010)\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000e\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J1\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\r2\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u0018J\u0014\u0010\u0019\u001a\u00020\u000b2\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0002J\b\u0010\u001a\u001a\u00020\u0011H\u0002J\b\u0010\u001b\u001a\u00020\u0011H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lkotlinx/collections/immutable/implementations/immutableSet/PersistentHashSetMutableIterator;", "E", "Lkotlinx/collections/immutable/implementations/immutableSet/PersistentHashSetIterator;", "", "builder", "Lkotlinx/collections/immutable/implementations/immutableSet/PersistentHashSetBuilder;", "<init>", "(Lkotlinx/collections/immutable/implementations/immutableSet/PersistentHashSetBuilder;)V", "lastIteratedElement", "Ljava/lang/Object;", "nextWasInvoked", "", "expectedModCount", "", "next", "()Ljava/lang/Object;", "remove", "", "resetPath", "hashCode", "node", "Lkotlinx/collections/immutable/implementations/immutableSet/TrieNode;", "element", "pathIndex", "(ILkotlinx/collections/immutable/implementations/immutableSet/TrieNode;Ljava/lang/Object;I)V", "isCollision", "checkNextWasInvoked", "checkForComodification", "kotlinx-collections-immutable"})
public final class PersistentHashSetMutableIterator<E>
extends PersistentHashSetIterator<E>
implements Iterator<E>,
KMutableIterator {
    @NotNull
    private final PersistentHashSetBuilder<E> builder;
    @Nullable
    private E lastIteratedElement;
    private boolean nextWasInvoked;
    private int expectedModCount;

    public PersistentHashSetMutableIterator(@NotNull PersistentHashSetBuilder<E> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        super(builder.getNode$kotlinx_collections_immutable());
        this.builder = builder;
        this.expectedModCount = this.builder.getModCount$kotlinx_collections_immutable();
    }

    @Override
    public E next() {
        this.checkForComodification();
        Object next2 = super.next();
        this.lastIteratedElement = next2;
        this.nextWasInvoked = true;
        return next2;
    }

    @Override
    public void remove() {
        this.checkNextWasInvoked();
        if (this.hasNext()) {
            Object currentElement = this.currentElement();
            Collection collection = this.builder;
            E e2 = this.lastIteratedElement;
            TypeIntrinsics.asMutableCollection((Object)collection).remove(e2);
            Object e3 = currentElement;
            this.resetPath(e3 != null ? e3.hashCode() : 0, this.builder.getNode$kotlinx_collections_immutable(), currentElement, 0);
        } else {
            Collection collection = this.builder;
            E e4 = this.lastIteratedElement;
            TypeIntrinsics.asMutableCollection((Object)collection).remove(e4);
        }
        this.lastIteratedElement = null;
        this.nextWasInvoked = false;
        this.expectedModCount = this.builder.getModCount$kotlinx_collections_immutable();
    }

    private final void resetPath(int hashCode, TrieNode<?> node, E element, int pathIndex) {
        if (this.isCollision(node)) {
            int index = ArraysKt.indexOf((Object[])node.getBuffer(), element);
            CommonFunctionsKt.assert(index != -1);
            this.getPath().get(pathIndex).reset(node.getBuffer(), index);
            this.setPathLastIndex(pathIndex);
            return;
        }
        int position = 1 << TrieNodeKt.indexSegment(hashCode, pathIndex * 5);
        int index = node.indexOfCellAt$kotlinx_collections_immutable(position);
        this.getPath().get(pathIndex).reset(node.getBuffer(), index);
        Object cell = node.getBuffer()[index];
        if (cell instanceof TrieNode) {
            this.resetPath(hashCode, (TrieNode)cell, element, pathIndex + 1);
        } else {
            this.setPathLastIndex(pathIndex);
        }
    }

    private final boolean isCollision(TrieNode<?> node) {
        return node.getBitmap() == 0;
    }

    private final void checkNextWasInvoked() {
        if (!this.nextWasInvoked) {
            throw new IllegalStateException();
        }
    }

    private final void checkForComodification() {
        if (this.builder.getModCount$kotlinx_collections_immutable() != this.expectedModCount) {
            throw new ConcurrentModificationException();
        }
    }
}

