/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj;

import com.hierynomus.sshj.key.KeyAlgorithms;
import com.hierynomus.sshj.transport.cipher.BlockCiphers;
import com.hierynomus.sshj.transport.cipher.ChachaPolyCiphers;
import com.hierynomus.sshj.transport.cipher.GcmCiphers;
import com.hierynomus.sshj.transport.cipher.StreamCiphers;
import com.hierynomus.sshj.transport.kex.DHGroups;
import com.hierynomus.sshj.transport.kex.ExtInfoClientFactory;
import com.hierynomus.sshj.transport.kex.ExtendedDHGroups;
import com.hierynomus.sshj.transport.mac.Macs;
import com.hierynomus.sshj.userauth.keyprovider.OpenSSHKeyV1KeyFile;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Properties;
import net.schmizz.keepalive.KeepAliveProvider;
import net.schmizz.sshj.ConfigImpl;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.LoggerFactory;
import net.schmizz.sshj.transport.cipher.Cipher;
import net.schmizz.sshj.transport.compression.NoneCompression;
import net.schmizz.sshj.transport.kex.Curve25519SHA256;
import net.schmizz.sshj.transport.kex.DHGexSHA1;
import net.schmizz.sshj.transport.kex.DHGexSHA256;
import net.schmizz.sshj.transport.kex.ECDHNistP;
import net.schmizz.sshj.transport.random.JCERandom;
import net.schmizz.sshj.transport.random.SingletonRandomFactory;
import net.schmizz.sshj.userauth.keyprovider.OpenSSHKeyFile;
import net.schmizz.sshj.userauth.keyprovider.PKCS8KeyFile;
import net.schmizz.sshj.userauth.keyprovider.PuTTYKeyFile;
import org.slf4j.Logger;

public class DefaultConfig
extends ConfigImpl {
    private Logger log;

    public DefaultConfig() {
        this.setLoggerFactory(LoggerFactory.DEFAULT);
        this.setVersion(this.readVersionFromProperties());
        this.initKeyExchangeFactories();
        this.initKeyAlgorithms();
        this.initRandomFactory();
        this.initFileKeyProviderFactories();
        this.initCipherFactories();
        this.initCompressionFactories();
        this.initMACFactories();
        this.setKeepAliveProvider(KeepAliveProvider.HEARTBEAT);
    }

    private String readVersionFromProperties() {
        try {
            Properties properties = new Properties();
            properties.load(DefaultConfig.class.getClassLoader().getResourceAsStream("sshj.properties"));
            String property = properties.getProperty("sshj.version");
            return "SSHJ_" + property.replace('-', '_');
        }
        catch (Exception e2) {
            this.log.error("Could not read the sshj.properties file, returning an 'unknown' version as fallback.");
            return "SSHJ_VERSION_UNKNOWN";
        }
    }

    @Override
    public void setLoggerFactory(LoggerFactory loggerFactory) {
        super.setLoggerFactory(loggerFactory);
        this.log = loggerFactory.getLogger(this.getClass());
    }

    protected void initKeyExchangeFactories() {
        this.setKeyExchangeFactories(new Curve25519SHA256.Factory(), new Curve25519SHA256.FactoryLibSsh(), new DHGexSHA256.Factory(), new ECDHNistP.Factory521(), new ECDHNistP.Factory384(), new ECDHNistP.Factory256(), new DHGexSHA1.Factory(), DHGroups.Group1SHA1(), DHGroups.Group14SHA1(), DHGroups.Group14SHA256(), DHGroups.Group15SHA512(), DHGroups.Group16SHA512(), DHGroups.Group17SHA512(), DHGroups.Group18SHA512(), ExtendedDHGroups.Group14SHA256AtSSH(), ExtendedDHGroups.Group15SHA256(), ExtendedDHGroups.Group15SHA256AtSSH(), ExtendedDHGroups.Group15SHA384AtSSH(), ExtendedDHGroups.Group16SHA256(), ExtendedDHGroups.Group16SHA384AtSSH(), ExtendedDHGroups.Group16SHA512AtSSH(), ExtendedDHGroups.Group18SHA512AtSSH(), new ExtInfoClientFactory());
    }

    protected void initKeyAlgorithms() {
        this.setKeyAlgorithms(Arrays.asList(KeyAlgorithms.EdDSA25519CertV01(), KeyAlgorithms.EdDSA25519(), KeyAlgorithms.ECDSASHANistp521CertV01(), KeyAlgorithms.ECDSASHANistp521(), KeyAlgorithms.ECDSASHANistp384CertV01(), KeyAlgorithms.ECDSASHANistp384(), KeyAlgorithms.ECDSASHANistp256CertV01(), KeyAlgorithms.ECDSASHANistp256(), KeyAlgorithms.RSASHA512(), KeyAlgorithms.RSASHA256(), KeyAlgorithms.SSHRSACertV01(), KeyAlgorithms.SSHDSSCertV01(), KeyAlgorithms.SSHRSA(), KeyAlgorithms.SSHDSA()));
    }

    protected void initRandomFactory() {
        this.setRandomFactory(new SingletonRandomFactory(new JCERandom.Factory()));
    }

    protected void initFileKeyProviderFactories() {
        this.setFileKeyProviderFactories(new OpenSSHKeyV1KeyFile.Factory(), new PKCS8KeyFile.Factory(), new OpenSSHKeyFile.Factory(), new PuTTYKeyFile.Factory());
    }

    protected void initCipherFactories() {
        LinkedList<Factory.Named<Cipher>> avail = new LinkedList<Factory.Named<Cipher>>(Arrays.asList(ChachaPolyCiphers.CHACHA_POLY_OPENSSH(), BlockCiphers.AES128CBC(), BlockCiphers.AES128CTR(), BlockCiphers.AES192CBC(), BlockCiphers.AES192CTR(), BlockCiphers.AES256CBC(), BlockCiphers.AES256CTR(), GcmCiphers.AES128GCM(), GcmCiphers.AES256GCM(), BlockCiphers.BlowfishCBC(), BlockCiphers.BlowfishCTR(), BlockCiphers.Cast128CBC(), BlockCiphers.Cast128CTR(), BlockCiphers.IDEACBC(), BlockCiphers.IDEACTR(), BlockCiphers.Serpent128CBC(), BlockCiphers.Serpent128CTR(), BlockCiphers.Serpent192CBC(), BlockCiphers.Serpent192CTR(), BlockCiphers.Serpent256CBC(), BlockCiphers.Serpent256CTR(), BlockCiphers.TripleDESCBC(), BlockCiphers.TripleDESCTR(), BlockCiphers.Twofish128CBC(), BlockCiphers.Twofish128CTR(), BlockCiphers.Twofish192CBC(), BlockCiphers.Twofish192CTR(), BlockCiphers.Twofish256CBC(), BlockCiphers.Twofish256CTR(), BlockCiphers.TwofishCBC(), StreamCiphers.Arcfour(), StreamCiphers.Arcfour128(), StreamCiphers.Arcfour256()));
        ListIterator factories = avail.listIterator();
        while (factories.hasNext()) {
            Factory.Named factory2 = (Factory.Named)factories.next();
            try {
                Cipher cipher = (Cipher)factory2.create();
                byte[] key = new byte[cipher.getBlockSize()];
                byte[] iv = new byte[cipher.getIVSize()];
                cipher.init(Cipher.Mode.Encrypt, key, iv);
            }
            catch (Exception e2) {
                this.log.info("Cipher [{}] disabled: {}", (Object)factory2.getName(), (Object)e2.getCause().getMessage());
                factories.remove();
            }
        }
        this.setCipherFactories(avail);
        this.log.debug("Available Ciphers {}", avail);
    }

    protected void initMACFactories() {
        this.setMACFactories(Macs.HMACSHA1(), Macs.HMACSHA1Etm(), Macs.HMACSHA196(), Macs.HMACSHA196Etm(), Macs.HMACMD5(), Macs.HMACMD5Etm(), Macs.HMACMD596(), Macs.HMACMD596Etm(), Macs.HMACSHA2256(), Macs.HMACSHA2256Etm(), Macs.HMACSHA2512(), Macs.HMACSHA2512Etm(), Macs.HMACRIPEMD160(), Macs.HMACRIPEMD160Etm(), Macs.HMACRIPEMD16096(), Macs.HMACRIPEMD160OpenSsh());
    }

    protected void initCompressionFactories() {
        this.setCompressionFactories(new NoneCompression.Factory());
    }
}

