/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.sftp;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.schmizz.sshj.sftp.FileAttributes;
import net.schmizz.sshj.sftp.PacketType;
import net.schmizz.sshj.sftp.PathComponents;
import net.schmizz.sshj.sftp.RemoteResource;
import net.schmizz.sshj.sftp.RemoteResourceFilter;
import net.schmizz.sshj.sftp.RemoteResourceInfo;
import net.schmizz.sshj.sftp.Response;
import net.schmizz.sshj.sftp.SFTPEngine;
import net.schmizz.sshj.sftp.SFTPException;

public class RemoteDirectory
extends RemoteResource {
    public RemoteDirectory(SFTPEngine requester, String path, byte[] handle2) {
        super(requester, path, handle2);
    }

    public List<RemoteResourceInfo> scan(RemoteResourceFilter filter2) throws IOException {
        LinkedList<RemoteResourceInfo> rri = new LinkedList<RemoteResourceInfo>();
        block4: while (true) {
            Response res2 = this.requester.request(this.newRequest(PacketType.READDIR)).retrieve(this.requester.getTimeoutMs(), TimeUnit.MILLISECONDS);
            switch (res2.getType()) {
                case NAME: {
                    int count = res2.readUInt32AsInt();
                    int i2 = 0;
                    while (true) {
                        if (i2 >= count) continue block4;
                        String name = res2.readString(this.requester.sub.getRemoteCharset());
                        res2.readString();
                        FileAttributes attrs = res2.readFileAttributes();
                        PathComponents comps = this.requester.getPathHelper().getComponents(this.path, name);
                        RemoteResourceInfo inf = new RemoteResourceInfo(comps, attrs);
                        if (!(".".equals(name) || "..".equals(name) || filter2 != null && !filter2.accept(inf))) {
                            rri.add(inf);
                        }
                        ++i2;
                    }
                }
                case STATUS: {
                    res2.ensureStatusIs(Response.StatusCode.EOF);
                    break block4;
                }
                default: {
                    throw new SFTPException("Unexpected packet: " + (Object)((Object)res2.getType()));
                }
            }
            break;
        }
        return rri;
    }
}

