/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.sftp;

import com.hierynomus.sshj.common.ThreadNameProvider;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.schmizz.concurrent.Promise;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.common.LoggerFactory;
import net.schmizz.sshj.common.SSHException;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.connection.channel.direct.SessionFactory;
import net.schmizz.sshj.sftp.FileAttributes;
import net.schmizz.sshj.sftp.OpenMode;
import net.schmizz.sshj.sftp.PacketReader;
import net.schmizz.sshj.sftp.PacketType;
import net.schmizz.sshj.sftp.PathHelper;
import net.schmizz.sshj.sftp.RemoteDirectory;
import net.schmizz.sshj.sftp.RemoteFile;
import net.schmizz.sshj.sftp.RenameFlags;
import net.schmizz.sshj.sftp.Request;
import net.schmizz.sshj.sftp.Requester;
import net.schmizz.sshj.sftp.Response;
import net.schmizz.sshj.sftp.SFTPException;
import net.schmizz.sshj.sftp.SFTPPacket;
import org.slf4j.Logger;

public class SFTPEngine
implements Requester,
Closeable {
    public static final int MAX_SUPPORTED_VERSION = 3;
    public static final int DEFAULT_TIMEOUT_MS = 30000;
    protected final LoggerFactory loggerFactory;
    protected final Logger log;
    protected volatile int timeoutMs = 30000;
    protected final PathHelper pathHelper;
    protected final Session.Subsystem sub;
    protected final PacketReader reader;
    protected final OutputStream out;
    protected long reqID;
    protected int operativeVersion;
    protected final Map<String, String> serverExtensions = new HashMap<String, String>();

    public SFTPEngine(SessionFactory ssh) throws SSHException {
        this(ssh, "/");
    }

    public SFTPEngine(SessionFactory ssh, String pathSep) throws SSHException {
        Session session = ssh.startSession();
        this.loggerFactory = session.getLoggerFactory();
        this.log = this.loggerFactory.getLogger(this.getClass());
        this.sub = session.startSubsystem("sftp");
        this.out = this.sub.getOutputStream();
        this.reader = new PacketReader(this);
        ThreadNameProvider.setThreadName(this.reader, ssh);
        this.pathHelper = new PathHelper(new PathHelper.Canonicalizer(){

            @Override
            public String canonicalize(String path) throws IOException {
                return SFTPEngine.this.canonicalize(path);
            }
        }, pathSep);
    }

    public SFTPEngine init() throws IOException {
        return this.init(3);
    }

    protected SFTPEngine init(int requestedVersion) throws IOException {
        if (requestedVersion > 3) {
            throw new SFTPException("You requested an unsupported protocol version: " + requestedVersion + " (requested) > " + 3 + " (supported)");
        }
        if (requestedVersion < 3) {
            this.log.debug("Client version {} is smaller than MAX_SUPPORTED_VERSION {}", (Object)requestedVersion, (Object)3);
        }
        this.transmit((SFTPPacket)new SFTPPacket(PacketType.INIT).putUInt32(requestedVersion));
        SFTPPacket<Response> response = this.reader.readPacket();
        PacketType type = response.readType();
        if (type != PacketType.VERSION) {
            throw new SFTPException("Expected INIT packet, received: " + (Object)((Object)type));
        }
        this.operativeVersion = response.readUInt32AsInt();
        this.log.debug("Server version {}", (Object)this.operativeVersion);
        if (requestedVersion < this.operativeVersion) {
            throw new SFTPException("Server reported incompatible protocol version: " + this.operativeVersion);
        }
        while (response.available() > 0) {
            this.serverExtensions.put(response.readString(), response.readString());
        }
        this.reader.start();
        return this;
    }

    public Session.Subsystem getSubsystem() {
        return this.sub;
    }

    public int getOperativeProtocolVersion() {
        return this.operativeVersion;
    }

    public boolean supportsServerExtension(String extension, String domain) {
        return this.serverExtensions.containsKey(extension + "@" + domain);
    }

    public String getServerExtensionData(String extension, String domain) {
        return this.serverExtensions.get(extension + "@" + domain);
    }

    public Request newExtendedRequest(String reqName) {
        return (Request)this.newRequest(PacketType.EXTENDED).putString(reqName);
    }

    @Override
    public PathHelper getPathHelper() {
        return this.pathHelper;
    }

    @Override
    public synchronized Request newRequest(PacketType type) {
        this.reqID = this.reqID + 1L & 0xFFFFFFFFL;
        return new Request(type, this.reqID);
    }

    @Override
    public Promise<Response, SFTPException> request(Request req) throws IOException {
        Promise<Response, SFTPException> promise = this.reader.expectResponseTo(req.getRequestID());
        this.log.debug("Sending {}", (Object)req);
        this.transmit(req);
        return promise;
    }

    private Response doRequest(Request req) throws IOException {
        return this.request(req).retrieve(this.getTimeoutMs(), TimeUnit.MILLISECONDS);
    }

    public RemoteFile open(String path, Set<OpenMode> modes, FileAttributes fa) throws IOException {
        byte[] handle2 = this.doRequest((Request)((Request)((Request)this.newRequest(PacketType.OPEN).putString(path, this.sub.getRemoteCharset())).putUInt32(OpenMode.toMask(modes))).putFileAttributes(fa)).ensurePacketTypeIs(PacketType.HANDLE).readBytes();
        return new RemoteFile(this, path, handle2);
    }

    public RemoteFile open(String filename, Set<OpenMode> modes) throws IOException {
        return this.open(filename, modes, FileAttributes.EMPTY);
    }

    public RemoteFile open(String filename) throws IOException {
        return this.open(filename, EnumSet.of(OpenMode.READ));
    }

    public RemoteDirectory openDir(String path) throws IOException {
        byte[] handle2 = this.doRequest((Request)this.newRequest(PacketType.OPENDIR).putString(path, this.sub.getRemoteCharset())).ensurePacketTypeIs(PacketType.HANDLE).readBytes();
        return new RemoteDirectory(this, path, handle2);
    }

    public void setAttributes(String path, FileAttributes attrs) throws IOException {
        this.doRequest((Request)((Request)this.newRequest(PacketType.SETSTAT).putString(path, this.sub.getRemoteCharset())).putFileAttributes(attrs)).ensureStatusPacketIsOK();
    }

    public String readLink(String path) throws IOException {
        if (this.operativeVersion < 3) {
            throw new SFTPException("READLINK is not supported in SFTPv" + this.operativeVersion);
        }
        return SFTPEngine.readSingleName(this.doRequest((Request)this.newRequest(PacketType.READLINK).putString(path, this.sub.getRemoteCharset())), this.sub.getRemoteCharset());
    }

    public void makeDir(String path, FileAttributes attrs) throws IOException {
        this.doRequest((Request)((Request)this.newRequest(PacketType.MKDIR).putString(path, this.sub.getRemoteCharset())).putFileAttributes(attrs)).ensureStatusPacketIsOK();
    }

    public void makeDir(String path) throws IOException {
        this.makeDir(path, FileAttributes.EMPTY);
    }

    public void symlink(String linkpath, String targetpath) throws IOException {
        if (this.operativeVersion < 3) {
            throw new SFTPException("SYMLINK is not supported in SFTPv" + this.operativeVersion);
        }
        this.doRequest((Request)((Request)this.newRequest(PacketType.SYMLINK).putString(linkpath, this.sub.getRemoteCharset())).putString(targetpath, this.sub.getRemoteCharset())).ensureStatusPacketIsOK();
    }

    public void remove(String filename) throws IOException {
        this.doRequest((Request)this.newRequest(PacketType.REMOVE).putString(filename, this.sub.getRemoteCharset())).ensureStatusPacketIsOK();
    }

    public void removeDir(String path) throws IOException {
        this.doRequest((Request)this.newRequest(PacketType.RMDIR).putString(path, this.sub.getRemoteCharset())).ensureStatusIs(Response.StatusCode.OK);
    }

    public FileAttributes stat(String path) throws IOException {
        return this.stat(PacketType.STAT, path);
    }

    public FileAttributes lstat(String path) throws IOException {
        return this.stat(PacketType.LSTAT, path);
    }

    public void rename(String oldPath, String newPath, Set<RenameFlags> flags) throws IOException {
        if (this.operativeVersion < 1) {
            throw new SFTPException("RENAME is not supported in SFTPv" + this.operativeVersion);
        }
        PacketType type = PacketType.RENAME;
        long renameFlagMask = 0L;
        String serverExtension = null;
        if (!flags.isEmpty()) {
            if (this.operativeVersion >= 5) {
                for (RenameFlags flag : flags) {
                    renameFlagMask |= flag.longValue();
                }
            } else if (flags.contains((Object)RenameFlags.OVERWRITE) && this.supportsServerExtension("posix-rename", "openssh.com")) {
                type = PacketType.EXTENDED;
                serverExtension = "posix-rename@openssh.com";
            } else {
                if (flags.contains((Object)RenameFlags.ATOMIC) && !flags.contains((Object)RenameFlags.OVERWRITE) && !flags.contains((Object)RenameFlags.NATIVE) && this.supportsServerExtension("posix-rename", "openssh.com")) {
                    throw new SFTPException("RENAME-FLAGS are not supported in SFTPv" + this.operativeVersion + " but the \"posix-rename@openssh.com\" extension could be used as fallback if OVERWRITE behaviour is acceptable (needs to be activated via RenameFlags.OVERWRITE).");
                }
                if (flags.contains((Object)RenameFlags.NATIVE)) {
                    this.log.debug("Flags are not supported but NATIVE-flag allows to ignore other requested flags: " + flags.toString());
                } else {
                    throw new SFTPException("RENAME-FLAGS are not supported in SFTPv" + this.operativeVersion + " and no supported server extension could be found to achieve a similar result.");
                }
            }
        }
        Request request = this.newRequest(type);
        if (serverExtension != null) {
            request.putString(serverExtension);
        }
        ((Request)request.putString(oldPath, this.sub.getRemoteCharset())).putString(newPath, this.sub.getRemoteCharset());
        if (renameFlagMask != 0L) {
            request.putUInt32(renameFlagMask);
        }
        this.doRequest(request).ensureStatusPacketIsOK();
    }

    public String canonicalize(String path) throws IOException {
        return SFTPEngine.readSingleName(this.doRequest((Request)this.newRequest(PacketType.REALPATH).putString(path, this.sub.getRemoteCharset())), this.sub.getRemoteCharset());
    }

    public void setTimeoutMs(int timeoutMs) {
        this.timeoutMs = timeoutMs;
    }

    @Override
    public int getTimeoutMs() {
        return this.timeoutMs;
    }

    @Override
    public void close() throws IOException {
        this.sub.close();
        this.reader.interrupt();
    }

    protected LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    protected FileAttributes stat(PacketType pt, String path) throws IOException {
        return this.doRequest((Request)this.newRequest(pt).putString(path, this.sub.getRemoteCharset())).ensurePacketTypeIs(PacketType.ATTRS).readFileAttributes();
    }

    private static byte[] readSingleNameAsBytes(Response res2) throws IOException {
        res2.ensurePacketTypeIs(PacketType.NAME);
        if (res2.readUInt32AsInt() == 1) {
            return res2.readStringAsBytes();
        }
        throw new SFTPException("Unexpected data in " + (Object)((Object)res2.getType()) + " packet");
    }

    protected static String readSingleName(Response res2) throws IOException {
        return SFTPEngine.readSingleName(res2, IOUtils.UTF8);
    }

    protected static String readSingleName(Response res2, Charset charset) throws IOException {
        return new String(SFTPEngine.readSingleNameAsBytes(res2), charset);
    }

    protected synchronized void transmit(SFTPPacket<Request> payload) throws IOException {
        int len = payload.available();
        this.out.write(len >>> 24 & 0xFF);
        this.out.write(len >>> 16 & 0xFF);
        this.out.write(len >>> 8 & 0xFF);
        this.out.write(len & 0xFF);
        this.out.write(payload.array(), payload.rpos(), len);
        this.out.flush();
    }
}

