/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.transport.kex;

import java.security.GeneralSecurityException;
import java.security.spec.ECGenParameterSpec;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.transport.digest.Digest;
import net.schmizz.sshj.transport.digest.SHA256;
import net.schmizz.sshj.transport.digest.SHA384;
import net.schmizz.sshj.transport.digest.SHA512;
import net.schmizz.sshj.transport.kex.AbstractDHG;
import net.schmizz.sshj.transport.kex.DHBase;
import net.schmizz.sshj.transport.kex.ECDH;
import net.schmizz.sshj.transport.kex.KeyExchange;

public class ECDHNistP
extends AbstractDHG {
    private String curve;

    public ECDHNistP(String curve, Digest digest) {
        super(new ECDH(), digest);
        this.curve = curve;
    }

    @Override
    protected void initDH(DHBase dh2) throws GeneralSecurityException {
        dh2.init(new ECGenParameterSpec(this.curve), this.trans.getConfig().getRandomFactory());
    }

    public static class Factory256
    implements Factory.Named<KeyExchange> {
        @Override
        public KeyExchange create() {
            return new ECDHNistP("secp256r1", (Digest)new SHA256());
        }

        @Override
        public String getName() {
            return "ecdh-sha2-nistp256";
        }
    }

    public static class Factory384
    implements Factory.Named<KeyExchange> {
        @Override
        public KeyExchange create() {
            return new ECDHNistP("secp384r1", (Digest)new SHA384());
        }

        @Override
        public String getName() {
            return "ecdh-sha2-nistp384";
        }
    }

    public static class Factory521
    implements Factory.Named<KeyExchange> {
        @Override
        public KeyExchange create() {
            return new ECDHNistP("secp521r1", (Digest)new SHA512());
        }

        @Override
        public String getName() {
            return "ecdh-sha2-nistp521";
        }
    }
}

