/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.transport.verification;

import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.SSHRuntimeException;
import net.schmizz.sshj.common.SecurityUtils;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;

public class FingerprintVerifier
implements HostKeyVerifier {
    private static final Pattern MD5_FINGERPRINT_PATTERN = Pattern.compile("[0-9a-f]{2}+(:[0-9a-f]{2}+){15}+");
    private final String digestAlgorithm;
    private final byte[] fingerprintData;

    public static HostKeyVerifier getInstance(String fingerprint) {
        if (fingerprint.startsWith("SHA1:")) {
            return new FingerprintVerifier("SHA-1", fingerprint.substring(5));
        }
        if (fingerprint.startsWith("SHA256:")) {
            return new FingerprintVerifier("SHA-256", fingerprint.substring(7));
        }
        final String md5 = fingerprint.startsWith("MD5:") ? fingerprint.substring(4) : fingerprint;
        if (!MD5_FINGERPRINT_PATTERN.matcher(md5).matches()) {
            throw new SSHRuntimeException("Invalid MD5 fingerprint: " + fingerprint);
        }
        return new HostKeyVerifier(){

            @Override
            public boolean verify(String h7, int p2, PublicKey k2) {
                return SecurityUtils.getFingerprint(k2).equals(md5);
            }

            @Override
            public List<String> findExistingAlgorithms(String hostname, int port) {
                return Collections.emptyList();
            }
        };
    }

    private FingerprintVerifier(String digestAlgorithm, String base64Fingerprint) {
        this.digestAlgorithm = digestAlgorithm;
        StringBuilder base64FingerprintBuilder = new StringBuilder(base64Fingerprint);
        while (base64FingerprintBuilder.length() % 4 != 0) {
            base64FingerprintBuilder.append("=");
        }
        this.fingerprintData = Base64.getDecoder().decode(base64FingerprintBuilder.toString());
    }

    @Override
    public boolean verify(String hostname, int port, PublicKey key) {
        MessageDigest digest;
        try {
            digest = SecurityUtils.getMessageDigest(this.digestAlgorithm);
        }
        catch (GeneralSecurityException e2) {
            throw new SSHRuntimeException(e2);
        }
        digest.update(((Buffer.PlainBuffer)new Buffer.PlainBuffer().putPublicKey(key)).getCompactData());
        byte[] digestData = digest.digest();
        return Arrays.equals(this.fingerprintData, digestData);
    }

    @Override
    public List<String> findExistingAlgorithms(String hostname, int port) {
        return Collections.emptyList();
    }

    public String toString() {
        return "FingerprintVerifier{digestAlgorithm='" + this.digestAlgorithm + "'}";
    }
}

