/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.userauth.keyprovider;

import com.hierynomus.sshj.userauth.keyprovider.OpenSSHKeyFileUtil;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.PublicKey;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.userauth.keyprovider.FileKeyProvider;
import net.schmizz.sshj.userauth.keyprovider.PKCS8KeyFile;

public class OpenSSHKeyFile
extends PKCS8KeyFile {
    private PublicKey pubKey;

    @Override
    public PublicKey getPublic() throws IOException {
        return this.pubKey != null ? this.pubKey : super.getPublic();
    }

    @Override
    public void init(File location) {
        File pubKey = OpenSSHKeyFileUtil.getPublicKeyFile(location);
        if (pubKey != null) {
            try {
                this.initPubKey(new FileReader(pubKey));
            }
            catch (IOException e2) {
                this.log.warn("Error reading public key file: {}", (Object)e2.toString());
            }
        }
        super.init(location);
    }

    @Override
    public void init(String privateKey, String publicKey) {
        if (publicKey != null) {
            try {
                this.initPubKey(new StringReader(publicKey));
            }
            catch (IOException e2) {
                this.log.warn("Error reading public key: {}", (Object)e2.toString());
            }
        }
        super.init(privateKey, null);
    }

    private void initPubKey(Reader publicKey) throws IOException {
        OpenSSHKeyFileUtil.ParsedPubKey parsed = OpenSSHKeyFileUtil.initPubKey(publicKey);
        this.type = parsed.getType();
        this.pubKey = parsed.getPubKey();
    }

    public static class Factory
    implements Factory.Named<FileKeyProvider> {
        @Override
        public FileKeyProvider create() {
            return new OpenSSHKeyFile();
        }

        @Override
        public String getName() {
            return "OpenSSH";
        }
    }
}

