/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.userauth.method;

import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import net.schmizz.sshj.common.LoggerFactory;
import net.schmizz.sshj.userauth.method.ChallengeResponseProvider;
import net.schmizz.sshj.userauth.password.PasswordFinder;
import net.schmizz.sshj.userauth.password.Resource;
import org.slf4j.Logger;

public class PasswordResponseProvider
implements ChallengeResponseProvider {
    public static final Pattern DEFAULT_PROMPT_PATTERN = Pattern.compile(".*[pP]assword(?: for .*)?:\\s?\\z", 32);
    private static final char[] EMPTY_RESPONSE = new char[0];
    private final Pattern promptPattern;
    private final PasswordFinder pwdf;
    private final Logger log;
    private Resource resource;

    public PasswordResponseProvider(PasswordFinder pwdf) {
        this(pwdf, DEFAULT_PROMPT_PATTERN);
    }

    public PasswordResponseProvider(PasswordFinder pwdf, Pattern promptPattern) {
        this(pwdf, promptPattern, LoggerFactory.DEFAULT);
    }

    public PasswordResponseProvider(PasswordFinder pwdf, Pattern promptPattern, LoggerFactory loggerFactory) {
        this.pwdf = pwdf;
        this.promptPattern = promptPattern;
        this.log = loggerFactory.getLogger(this.getClass());
    }

    @Override
    public List<String> getSubmethods() {
        return Collections.emptyList();
    }

    @Override
    public void init(Resource resource2, String name, String instruction) {
        this.resource = resource2;
        this.log.debug("Challenge - name=`{}`; instruction=`{}`", (Object)name, (Object)instruction);
    }

    @Override
    public char[] getResponse(String prompt, boolean echo2) {
        if (!echo2 && this.promptPattern.matcher(prompt).matches()) {
            return this.pwdf.reqPassword(this.resource);
        }
        return EMPTY_RESPONSE;
    }

    @Override
    public boolean shouldRetry() {
        return this.pwdf.shouldRetry(this.resource);
    }
}

