/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.xfer;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Stack;
import net.schmizz.sshj.xfer.FilePermission;
import net.schmizz.sshj.xfer.LocalDestFile;
import net.schmizz.sshj.xfer.LocalFileFilter;
import net.schmizz.sshj.xfer.LocalSourceFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemFile
implements LocalSourceFile,
LocalDestFile {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final File file;

    public FileSystemFile(String path) {
        this(new File(path));
    }

    public FileSystemFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public boolean isFile() {
        return this.file.isFile();
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public long getLength() {
        return this.file.length();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.getOutputStream(false);
    }

    @Override
    public OutputStream getOutputStream(boolean append) throws IOException {
        return new FileOutputStream(this.file, append);
    }

    public Iterable<FileSystemFile> getChildren(final LocalFileFilter filter2) throws IOException {
        File[] childFiles;
        File[] fileArray = childFiles = filter2 == null ? this.file.listFiles() : this.file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return filter2.accept(new FileSystemFile(file));
            }
        });
        if (childFiles == null) {
            throw new IOException("Error listing files in directory: " + this);
        }
        ArrayList<FileSystemFile> children = new ArrayList<FileSystemFile>();
        for (File f2 : childFiles) {
            children.add(new FileSystemFile(f2));
        }
        return children;
    }

    @Override
    public boolean providesAtimeMtime() {
        return true;
    }

    @Override
    public long getLastAccessTime() throws IOException {
        return System.currentTimeMillis() / 1000L;
    }

    @Override
    public long getLastModifiedTime() throws IOException {
        return this.file.lastModified() / 1000L;
    }

    @Override
    public int getPermissions() throws IOException {
        if (this.isDirectory()) {
            return 493;
        }
        if (this.isFile()) {
            return 420;
        }
        throw new IOException("Unsupported file type");
    }

    @Override
    public void setLastAccessedTime(long t2) throws IOException {
    }

    @Override
    public void setLastModifiedTime(long t2) throws IOException {
        if (!this.file.setLastModified(t2 * 1000L)) {
            this.log.warn("Could not set last modified time for {} to {}", (Object)this.file, (Object)t2);
        }
    }

    @Override
    public void setPermissions(int perms) throws IOException {
        boolean r2 = this.file.setReadable(FilePermission.USR_R.isIn(perms), !FilePermission.OTH_R.isIn(perms) && !FilePermission.GRP_R.isIn(perms));
        boolean w2 = this.file.setWritable(FilePermission.USR_W.isIn(perms), !FilePermission.OTH_W.isIn(perms) && !FilePermission.GRP_W.isIn(perms));
        boolean x2 = this.file.setExecutable(FilePermission.USR_X.isIn(perms), !FilePermission.OTH_X.isIn(perms) && !FilePermission.GRP_X.isIn(perms));
        if (!(r2 && w2 && x2)) {
            this.log.warn("Could not set permissions for {} to {}", (Object)this.file, (Object)Integer.toString(perms, 16));
        }
    }

    @Override
    public FileSystemFile getChild(String name) {
        this.validateIsChildPath(name);
        return new FileSystemFile(new File(this.file, name));
    }

    private void validateIsChildPath(String name) {
        String[] split = name.split("/");
        Stack<String> s2 = new Stack<String>();
        for (String component : split) {
            if (component == null || component.isEmpty() || ".".equals(component)) continue;
            if ("..".equals(component) && !s2.isEmpty()) {
                s2.pop();
                continue;
            }
            if ("..".equals(component)) {
                throw new IllegalArgumentException("Cannot traverse higher than " + this.file + " to get child " + name);
            }
            s2.push(component);
        }
    }

    @Override
    public FileSystemFile getTargetFile(String filename) throws IOException {
        FileSystemFile f2 = this;
        if (f2.isDirectory()) {
            f2 = f2.getChild(filename);
        }
        if (!f2.getFile().exists()) {
            if (!f2.getFile().createNewFile()) {
                throw new IOException("Could not create: " + this.file);
            }
        } else if (f2.isDirectory()) {
            throw new IOException("A directory by the same name already exists: " + f2);
        }
        return f2;
    }

    @Override
    public FileSystemFile getTargetDirectory(String dirname) throws IOException {
        FileSystemFile f2 = this;
        if (f2.getFile().exists()) {
            if (f2.isDirectory()) {
                if (!f2.getName().equals(dirname)) {
                    f2 = f2.getChild(dirname);
                }
            } else {
                throw new IOException(f2 + " - already exists as a file; directory required");
            }
        }
        if (!f2.getFile().exists() && !f2.getFile().mkdir()) {
            throw new IOException("Failed to create directory: " + f2);
        }
        return f2;
    }

    public boolean equals(Object other) {
        return other instanceof FileSystemFile && this.file.equals(((FileSystemFile)other).file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public String toString() {
        return this.file.toString();
    }
}

