/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.xfer.scp;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.xfer.LocalDestFile;
import net.schmizz.sshj.xfer.TransferListener;
import net.schmizz.sshj.xfer.scp.AbstractSCPClient;
import net.schmizz.sshj.xfer.scp.SCPEngine;
import net.schmizz.sshj.xfer.scp.SCPException;
import net.schmizz.sshj.xfer.scp.SCPRemoteException;
import net.schmizz.sshj.xfer.scp.ScpCommandLine;

public class SCPDownloadClient
extends AbstractSCPClient {
    private boolean recursiveMode = true;

    SCPDownloadClient(SCPEngine engine) {
        super(engine);
    }

    SCPDownloadClient(SCPEngine engine, int bandwidthLimit) {
        super(engine, bandwidthLimit);
    }

    public synchronized int copy(String sourcePath, LocalDestFile targetFile) throws IOException {
        return this.copy(sourcePath, targetFile, ScpCommandLine.EscapeMode.NoEscape);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int copy(String sourcePath, LocalDestFile targetFile, ScpCommandLine.EscapeMode escapeMode) throws IOException {
        this.engine.cleanSlate();
        try {
            this.startCopy(sourcePath, targetFile, escapeMode);
        }
        finally {
            this.engine.exit();
        }
        return this.engine.getExitStatus();
    }

    public boolean getRecursiveMode() {
        return this.recursiveMode;
    }

    public void setRecursiveMode(boolean recursive) {
        this.recursiveMode = recursive;
    }

    private void startCopy(String sourcePath, LocalDestFile targetFile, ScpCommandLine.EscapeMode escapeMode) throws IOException {
        ScpCommandLine commandLine = ScpCommandLine.with(ScpCommandLine.Arg.SOURCE).and(ScpCommandLine.Arg.QUIET).and(ScpCommandLine.Arg.PRESERVE_TIMES).and(ScpCommandLine.Arg.RECURSIVE, this.recursiveMode).and(ScpCommandLine.Arg.LIMIT, String.valueOf(this.bandwidthLimit), this.bandwidthLimit > 0);
        commandLine.withPath(sourcePath, escapeMode);
        this.engine.execSCPWith(commandLine);
        this.engine.signal("Start status OK");
        String msg = this.engine.readMessage();
        do {
            this.process(this.engine.getTransferListener(), null, msg, targetFile);
        } while (!(msg = this.engine.readMessage()).isEmpty());
    }

    private long parseLong(String longString, String valType) throws SCPException {
        try {
            return Long.parseLong(longString);
        }
        catch (NumberFormatException nfe) {
            throw new SCPException("Could not parse " + valType + " from `" + longString + "`", (Throwable)nfe);
        }
    }

    private int parsePermissions(String cmd) throws SCPException {
        if (cmd.length() != 5) {
            throw new SCPException("Could not parse permissions from `" + cmd + "`");
        }
        return Integer.parseInt(cmd.substring(1), 8);
    }

    private boolean process(TransferListener listener, String bufferedTMsg, String msg, LocalDestFile f2) throws IOException {
        if (msg.length() < 1) {
            throw new SCPException("Could not parse message `" + msg + "`");
        }
        switch (msg.charAt(0)) {
            case 'T': {
                this.engine.signal("ACK: T");
                this.process(listener, msg, this.engine.readMessage(), f2);
                break;
            }
            case 'C': {
                this.processFile(listener, msg, bufferedTMsg, f2);
                break;
            }
            case 'D': {
                this.processDirectory(listener, msg, bufferedTMsg, f2);
                break;
            }
            case 'E': {
                return true;
            }
            case '\u0001': 
            case '\u0002': {
                throw new SCPRemoteException("Remote SCP command returned error: " + msg.substring(1), msg.substring(1));
            }
            default: {
                String err = "Unrecognized message: `" + msg + "`";
                this.engine.sendMessage('\u0002' + err);
                throw new SCPException(err);
            }
        }
        return false;
    }

    private void processDirectory(TransferListener listener, String dMsg, String tMsg, LocalDestFile f2) throws IOException {
        List<String> dMsgParts = SCPDownloadClient.tokenize(dMsg, 3, true);
        long length = this.parseLong(dMsgParts.get(1), "dir length");
        String dirname = dMsgParts.get(2);
        if (length != 0L) {
            throw new IOException("Remote SCP command sent strange directory length: " + length);
        }
        TransferListener dirListener = listener.directory(dirname);
        f2 = f2.getTargetDirectory(dirname);
        this.engine.signal("ACK: D");
        while (!this.process(dirListener, null, this.engine.readMessage(), f2)) {
        }
        this.setAttributes(f2, this.parsePermissions(dMsgParts.get(0)), tMsg);
        this.engine.signal("ACK: E");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFile(TransferListener listener, String cMsg, String tMsg, LocalDestFile f2) throws IOException {
        List<String> cMsgParts = SCPDownloadClient.tokenize(cMsg, 3, true);
        long length = this.parseLong(cMsgParts.get(1), "length");
        String filename = cMsgParts.get(2);
        f2 = f2.getTargetFile(filename);
        this.engine.signal("Remote can start transfer");
        OutputStream dest = f2.getOutputStream();
        try {
            this.engine.transferFromRemote(listener.file(filename, length), dest, length);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(dest);
            throw throwable;
        }
        IOUtils.closeQuietly(dest);
        this.engine.check("Remote agrees transfer done");
        this.setAttributes(f2, this.parsePermissions(cMsgParts.get(0)), tMsg);
        this.engine.signal("Transfer done");
    }

    private void setAttributes(LocalDestFile f2, int perms, String tMsg) throws IOException {
        f2.setPermissions(perms);
        if (tMsg != null) {
            List<String> tMsgParts = SCPDownloadClient.tokenize(tMsg, 4, false);
            f2.setLastModifiedTime(this.parseLong(tMsgParts.get(0).substring(1), "last modified time"));
            f2.setLastAccessedTime(this.parseLong(tMsgParts.get(2), "last access time"));
        }
    }

    private static List<String> tokenize(String msg, int totalParts, boolean consolidateTail) throws IOException {
        List<String> parts = Arrays.asList(msg.split(" "));
        if (parts.size() < totalParts || !consolidateTail && parts.size() != totalParts) {
            throw new IOException("Could not parse message received from remote SCP: " + msg);
        }
        if (consolidateTail && totalParts < parts.size()) {
            StringBuilder sb = new StringBuilder(parts.get(totalParts - 1));
            for (int i2 = totalParts; i2 < parts.size(); ++i2) {
                sb.append(" ").append(parts.get(i2));
            }
            parts = new ArrayList<String>(parts.subList(0, totalParts - 1));
            parts.add(sb.toString());
        }
        return parts;
    }
}

