/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.xfer.scp;

import java.io.IOException;
import java.io.InputStream;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.common.StreamCopier;
import net.schmizz.sshj.xfer.LocalFileFilter;
import net.schmizz.sshj.xfer.LocalSourceFile;
import net.schmizz.sshj.xfer.TransferListener;
import net.schmizz.sshj.xfer.scp.AbstractSCPClient;
import net.schmizz.sshj.xfer.scp.SCPEngine;
import net.schmizz.sshj.xfer.scp.ScpCommandLine;

public class SCPUploadClient
extends AbstractSCPClient {
    private LocalFileFilter uploadFilter;

    SCPUploadClient(SCPEngine engine) {
        super(engine);
    }

    SCPUploadClient(SCPEngine engine, int bandwidthLimit) {
        super(engine, bandwidthLimit);
    }

    public synchronized int copy(LocalSourceFile sourceFile, String remotePath) throws IOException {
        return this.copy(sourceFile, remotePath, ScpCommandLine.EscapeMode.SingleQuote);
    }

    public synchronized int copy(LocalSourceFile sourceFile, String remotePath, ScpCommandLine.EscapeMode escapeMode) throws IOException {
        return this.copy(sourceFile, remotePath, escapeMode, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int copy(LocalSourceFile sourceFile, String remotePath, ScpCommandLine.EscapeMode escapeMode, boolean preserveTimes) throws IOException {
        this.engine.cleanSlate();
        try {
            this.startCopy(sourceFile, remotePath, escapeMode, preserveTimes);
        }
        finally {
            this.engine.exit();
        }
        return this.engine.getExitStatus();
    }

    public void setUploadFilter(LocalFileFilter uploadFilter) {
        this.uploadFilter = uploadFilter;
    }

    private void startCopy(LocalSourceFile sourceFile, String targetPath, ScpCommandLine.EscapeMode escapeMode, boolean preserveTimes) throws IOException {
        ScpCommandLine commandLine = ScpCommandLine.with(ScpCommandLine.Arg.SINK).and(ScpCommandLine.Arg.RECURSIVE).and(ScpCommandLine.Arg.LIMIT, String.valueOf(this.bandwidthLimit), this.bandwidthLimit > 0);
        if (preserveTimes) {
            commandLine.and(ScpCommandLine.Arg.PRESERVE_TIMES, sourceFile.providesAtimeMtime());
        }
        commandLine.withPath(targetPath, escapeMode);
        this.engine.execSCPWith(commandLine);
        this.engine.check("Start status OK");
        this.process(this.engine.getTransferListener(), sourceFile, preserveTimes);
    }

    private void process(TransferListener listener, LocalSourceFile f2, boolean preserveTimes) throws IOException {
        if (f2.isDirectory()) {
            this.sendDirectory(listener.directory(f2.getName()), f2, preserveTimes);
        } else if (f2.isFile()) {
            this.sendFile(listener.file(f2.getName(), f2.getLength()), f2, preserveTimes);
        } else {
            throw new IOException(f2 + " is not a regular file or directory");
        }
    }

    private void sendDirectory(TransferListener listener, LocalSourceFile f2, boolean preserveTimes) throws IOException {
        this.preserveTimeIfPossible(f2);
        this.engine.sendMessage("D0" + this.getPermString(f2) + " 0 " + f2.getName());
        for (LocalSourceFile localSourceFile : f2.getChildren(this.uploadFilter)) {
            this.process(listener, localSourceFile, preserveTimes);
        }
        this.engine.sendMessage("E");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendFile(StreamCopier.Listener listener, LocalSourceFile f2, boolean preserveTimes) throws IOException {
        if (preserveTimes) {
            this.preserveTimeIfPossible(f2);
        }
        InputStream src = f2.getInputStream();
        try {
            this.engine.sendMessage("C0" + this.getPermString(f2) + " " + f2.getLength() + " " + f2.getName());
            this.engine.transferToRemote(listener, src, f2.getLength());
            this.engine.signal("Transfer done");
            this.engine.check("Remote agrees transfer done");
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(src);
            throw throwable;
        }
        IOUtils.closeQuietly(src);
    }

    private void preserveTimeIfPossible(LocalSourceFile f2) throws IOException {
        if (f2.providesAtimeMtime()) {
            this.engine.sendMessage("T" + f2.getLastModifiedTime() + " 0 " + f2.getLastAccessTime() + " 0");
        }
    }

    private String getPermString(LocalSourceFile f2) throws IOException {
        return Integer.toOctalString(f2.getPermissions() & 0xFFF);
    }
}

