/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.classloaderhandler;

import java.io.File;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nonapi.io.github.classgraph.classloaderhandler.ClassLoaderHandler;
import nonapi.io.github.classgraph.classpath.ClassLoaderFinder;
import nonapi.io.github.classgraph.classpath.ClassLoaderOrder;
import nonapi.io.github.classgraph.classpath.ClasspathOrder;
import nonapi.io.github.classgraph.scanspec.ScanSpec;
import nonapi.io.github.classgraph.utils.FileUtils;
import nonapi.io.github.classgraph.utils.LogNode;

class JBossClassLoaderHandler
implements ClassLoaderHandler {
    private JBossClassLoaderHandler() {
    }

    public static boolean canHandle(Class<?> classLoaderClass, LogNode log2) {
        return ClassLoaderFinder.classIsOrExtendsOrImplements(classLoaderClass, "org.jboss.modules.ModuleClassLoader");
    }

    public static void findClassLoaderOrder(ClassLoader classLoader, ClassLoaderOrder classLoaderOrder, LogNode log2) {
        classLoaderOrder.delegateTo(classLoader.getParent(), true, log2);
        classLoaderOrder.add(classLoader, log2);
    }

    private static void handleResourceLoader(Object resourceLoader, ClassLoader classLoader, ClasspathOrder classpathOrderOut, ScanSpec scanSpec, LogNode log2) {
        if (resourceLoader == null) {
            return;
        }
        Object root = classpathOrderOut.reflectionUtils.getFieldVal(false, resourceLoader, "root");
        classpathOrderOut.addClasspathEntry(JBossClassLoaderHandler.loadJarPathFromClassicVFS(root, classpathOrderOut), classLoader, scanSpec, log2);
        classpathOrderOut.addClasspathEntry((Object)JBossClassLoaderHandler.loadJarPathFromNewVFS(root, classpathOrderOut), classLoader, scanSpec, log2);
        classpathOrderOut.addClasspathEntry(classpathOrderOut.reflectionUtils.getFieldVal(false, resourceLoader, "fileOfJar"), classLoader, scanSpec, log2);
    }

    private static File loadJarPathFromNewVFS(Object root, ClasspathOrder classpathOrderOut) {
        if (root == null) {
            return null;
        }
        Class<?> jbossVFS = JBossClassLoaderHandler.getJBossVFSAccess(root);
        if (jbossVFS == null) {
            return null;
        }
        Object mount = classpathOrderOut.reflectionUtils.invokeStaticMethod(false, jbossVFS, "getMount", root.getClass(), root);
        if (mount == null) {
            return null;
        }
        Object fileSystem2 = classpathOrderOut.reflectionUtils.invokeMethod(false, mount, "getFileSystem");
        if (fileSystem2 == null) {
            return null;
        }
        File mountSource = (File)classpathOrderOut.reflectionUtils.invokeMethod(false, fileSystem2, "getMountSource");
        if (mountSource == null) {
            return null;
        }
        return mountSource;
    }

    private static Class<?> getJBossVFSAccess(Object root) {
        Class<?> jbossVFS = null;
        try {
            if (root.getClass().getName().contains("org.jboss.vfs")) {
                ClassLoader vfsRootClassloader = root.getClass().getClassLoader();
                jbossVFS = JBossClassLoaderHandler.loadJBossVFS(vfsRootClassloader);
            } else {
                jbossVFS = JBossClassLoaderHandler.loadJBossVFS(Thread.currentThread().getContextClassLoader());
            }
        }
        catch (ClassNotFoundException e2) {
            try {
                jbossVFS = JBossClassLoaderHandler.loadJBossVFS(Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return jbossVFS;
    }

    private static Class<?> loadJBossVFS(ClassLoader classLoader) throws ClassNotFoundException {
        return Class.forName("org.jboss.vfs.VFS", true, classLoader);
    }

    private static Object loadJarPathFromClassicVFS(Object root, ClasspathOrder classpathOrderOut) {
        if (root == null) {
            return null;
        }
        File physicalFile = (File)classpathOrderOut.reflectionUtils.invokeMethod(false, root, "getPhysicalFile");
        if (physicalFile != null) {
            String name = (String)classpathOrderOut.reflectionUtils.invokeMethod(false, root, "getName");
            if (name != null) {
                File file = new File(physicalFile.getParentFile(), name);
                if (FileUtils.canRead(file)) {
                    return file;
                }
                return physicalFile;
            }
            return physicalFile;
        }
        String path = (String)classpathOrderOut.reflectionUtils.invokeMethod(false, root, "getPathName");
        if (path != null) {
            return path;
        }
        return root;
    }

    private static void handleRealModule(Object module, Set<Object> visitedModules, ClassLoader classLoader, ClasspathOrder classpathOrderOut, ScanSpec scanSpec, LogNode log2) {
        Object vfsResourceLoaders;
        if (!visitedModules.add(module)) {
            return;
        }
        ClassLoader moduleLoader = (ClassLoader)classpathOrderOut.reflectionUtils.invokeMethod(false, module, "getClassLoader");
        if (moduleLoader == null) {
            moduleLoader = classLoader;
        }
        if ((vfsResourceLoaders = classpathOrderOut.reflectionUtils.invokeMethod(false, moduleLoader, "getResourceLoaders")) != null) {
            int n2 = Array.getLength(vfsResourceLoaders);
            for (int i2 = 0; i2 < n2; ++i2) {
                Object resourceLoader = Array.get(vfsResourceLoaders, i2);
                JBossClassLoaderHandler.handleResourceLoader(resourceLoader, moduleLoader, classpathOrderOut, scanSpec, log2);
            }
        }
    }

    public static void findClasspathOrder(ClassLoader classLoader, ClasspathOrder classpathOrder, ScanSpec scanSpec, LogNode log2) {
        Object module = classpathOrder.reflectionUtils.invokeMethod(false, classLoader, "getModule");
        Object callerModuleLoader = classpathOrder.reflectionUtils.invokeMethod(false, module, "getCallerModuleLoader");
        HashSet<Object> visitedModules = new HashSet<Object>();
        Map moduleMap = (Map)classpathOrder.reflectionUtils.getFieldVal(false, callerModuleLoader, "moduleMap");
        Set<Object> moduleMapEntries = moduleMap != null ? moduleMap.entrySet() : Collections.emptySet();
        for (Map.Entry entry : moduleMapEntries) {
            Object val = entry.getValue();
            Object realModule = classpathOrder.reflectionUtils.invokeMethod(false, val, "getModule");
            JBossClassLoaderHandler.handleRealModule(realModule, visitedModules, classLoader, classpathOrder, scanSpec, log2);
        }
        Map pathsMap = (Map)classpathOrder.reflectionUtils.invokeMethod(false, module, "getPaths");
        for (Map.Entry ent : pathsMap.entrySet()) {
            for (Object localLoader : (List)ent.getValue()) {
                Object moduleClassLoader = classpathOrder.reflectionUtils.getFieldVal(false, localLoader, "this$0");
                Object realModule = classpathOrder.reflectionUtils.getFieldVal(false, moduleClassLoader, "module");
                JBossClassLoaderHandler.handleRealModule(realModule, visitedModules, classLoader, classpathOrder, scanSpec, log2);
            }
        }
    }
}

