/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.classloaderhandler;

import java.io.File;
import nonapi.io.github.classgraph.classloaderhandler.ClassLoaderHandler;
import nonapi.io.github.classgraph.classpath.ClassLoaderFinder;
import nonapi.io.github.classgraph.classpath.ClassLoaderOrder;
import nonapi.io.github.classgraph.classpath.ClasspathOrder;
import nonapi.io.github.classgraph.scanspec.ScanSpec;
import nonapi.io.github.classgraph.utils.LogNode;

class OSGiDefaultClassLoaderHandler
implements ClassLoaderHandler {
    private OSGiDefaultClassLoaderHandler() {
    }

    public static boolean canHandle(Class<?> classLoaderClass, LogNode log2) {
        return ClassLoaderFinder.classIsOrExtendsOrImplements(classLoaderClass, "org.eclipse.osgi.internal.baseadaptor.DefaultClassLoader");
    }

    public static void findClassLoaderOrder(ClassLoader classLoader, ClassLoaderOrder classLoaderOrder, LogNode log2) {
        classLoaderOrder.delegateTo(classLoader.getParent(), true, log2);
        classLoaderOrder.add(classLoader, log2);
    }

    public static void findClasspathOrder(ClassLoader classLoader, ClasspathOrder classpathOrder, ScanSpec scanSpec, LogNode log2) {
        Object classpathManager = classpathOrder.reflectionUtils.invokeMethod(false, classLoader, "getClasspathManager");
        Object[] entries2 = (Object[])classpathOrder.reflectionUtils.getFieldVal(false, classpathManager, "entries");
        if (entries2 != null) {
            for (Object entry : entries2) {
                Object bundleFile = classpathOrder.reflectionUtils.invokeMethod(false, entry, "getBundleFile");
                File baseFile = (File)classpathOrder.reflectionUtils.invokeMethod(false, bundleFile, "getBaseFile");
                if (baseFile == null) continue;
                classpathOrder.addClasspathEntry((Object)baseFile.getPath(), classLoader, scanSpec, log2);
            }
        }
    }
}

