/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okhttp3.internal._HostnamesCommonKt;
import okhttp3.internal._UtilCommonKt;
import okhttp3.internal.publicsuffix.PublicSuffixDatabase;
import okhttp3.internal.url._UrlKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 J2\u00020\u0001:\u0002IJBa\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n\u0012\u0010\u0010\u000b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010\n\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\r\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000eJ\u000f\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0007\u00a2\u0006\u0002\b!J\r\u0010\u0011\u001a\u00020\u0003H\u0007\u00a2\u0006\u0002\b\"J\r\u0010\u0012\u001a\u00020\u0003H\u0007\u00a2\u0006\u0002\b#J\u0013\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\nH\u0007\u00a2\u0006\u0002\b$J\u000f\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u0007\u00a2\u0006\u0002\b%J\r\u0010\u0016\u001a\u00020\u0003H\u0007\u00a2\u0006\u0002\b&J\u0013\u0010'\u001a\u00020\u00182\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u000f\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0007\u00a2\u0006\u0002\b)J\b\u0010*\u001a\u00020\bH\u0016J\r\u0010\u0006\u001a\u00020\u0003H\u0007\u00a2\u0006\u0002\b+J\u0006\u0010,\u001a\u00020-J\u0010\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020\u0003J\r\u0010\u0005\u001a\u00020\u0003H\u0007\u00a2\u0006\u0002\b/J\u0013\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\nH\u0007\u00a2\u0006\u0002\b0J\r\u0010\u001a\u001a\u00020\bH\u0007\u00a2\u0006\u0002\b1J\r\u0010\u0007\u001a\u00020\bH\u0007\u00a2\u0006\u0002\b2J\u000f\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0007\u00a2\u0006\u0002\b3J\u0010\u00104\u001a\u0004\u0018\u00010\u00032\u0006\u00105\u001a\u00020\u0003J\u000e\u00106\u001a\u00020\u00032\u0006\u00107\u001a\u00020\bJ\u0013\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\u001eH\u0007\u00a2\u0006\u0002\b8J\u0010\u00109\u001a\u0004\u0018\u00010\u00032\u0006\u00107\u001a\u00020\bJ\u0016\u0010:\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\n2\u0006\u00105\u001a\u00020\u0003J\r\u0010 \u001a\u00020\bH\u0007\u00a2\u0006\u0002\b;J\u0006\u0010<\u001a\u00020\u0003J\u0010\u0010=\u001a\u0004\u0018\u00010\u00002\u0006\u0010.\u001a\u00020\u0003J\r\u0010\u0002\u001a\u00020\u0003H\u0007\u00a2\u0006\u0002\b>J\b\u0010?\u001a\u00020\u0003H\u0016J\r\u0010@\u001a\u00020AH\u0007\u00a2\u0006\u0002\bBJ\r\u0010C\u001a\u00020DH\u0007\u00a2\u0006\u0002\b\rJ\b\u0010E\u001a\u0004\u0018\u00010\u0003J\r\u0010B\u001a\u00020AH\u0007\u00a2\u0006\u0002\bFJ\r\u0010\r\u001a\u00020DH\u0007\u00a2\u0006\u0002\bGJ\r\u0010\u0004\u001a\u00020\u0003H\u0007\u00a2\u0006\u0002\bHR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u00038G\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00038G\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0012\u001a\u00020\u00038G\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\n8G\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u00038G\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0010R\u0011\u0010\u0016\u001a\u00020\u00038G\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0010R\u0015\u0010\f\u001a\u0004\u0018\u00010\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0010R\u0013\u0010\u0006\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0010R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0019R\u0013\u0010\u0005\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0010R\u0019\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0014R\u0011\u0010\u001a\u001a\u00020\b8G\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\u0007\u001a\u00020\b8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u001bR\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u00038G\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0010R\u0018\u0010\u000b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\u001e8G\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001fR\u0011\u0010 \u001a\u00020\b8G\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001bR\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0010R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0010\u00a8\u0006K"}, d2={"Lokhttp3/HttpUrl;", "", "scheme", "", "username", "password", "host", "port", "", "pathSegments", "", "queryNamesAndValues", "fragment", "url", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/util/List;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;)V", "encodedFragment", "()Ljava/lang/String;", "encodedPassword", "encodedPath", "encodedPathSegments", "()Ljava/util/List;", "encodedQuery", "encodedUsername", "isHttps", "", "()Z", "pathSize", "()I", "query", "queryParameterNames", "", "()Ljava/util/Set;", "querySize", "-deprecated_encodedFragment", "-deprecated_encodedPassword", "-deprecated_encodedPath", "-deprecated_encodedPathSegments", "-deprecated_encodedQuery", "-deprecated_encodedUsername", "equals", "other", "-deprecated_fragment", "hashCode", "-deprecated_host", "newBuilder", "Lokhttp3/HttpUrl$Builder;", "link", "-deprecated_password", "-deprecated_pathSegments", "-deprecated_pathSize", "-deprecated_port", "-deprecated_query", "queryParameter", "name", "queryParameterName", "index", "-deprecated_queryParameterNames", "queryParameterValue", "queryParameterValues", "-deprecated_querySize", "redact", "resolve", "-deprecated_scheme", "toString", "toUri", "Ljava/net/URI;", "uri", "toUrl", "Ljava/net/URL;", "topPrivateDomain", "-deprecated_uri", "-deprecated_url", "-deprecated_username", "Builder", "Companion", "okhttp"})
public final class HttpUrl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String scheme;
    @NotNull
    private final String username;
    @NotNull
    private final String password;
    @NotNull
    private final String host;
    private final int port;
    @NotNull
    private final List<String> pathSegments;
    @Nullable
    private final List<String> queryNamesAndValues;
    @Nullable
    private final String fragment;
    @NotNull
    private final String url;

    private HttpUrl(String scheme, String username, String password, String host, int port, List<String> pathSegments, List<String> queryNamesAndValues, String fragment, String url) {
        this.scheme = scheme;
        this.username = username;
        this.password = password;
        this.host = host;
        this.port = port;
        this.pathSegments = pathSegments;
        this.queryNamesAndValues = queryNamesAndValues;
        this.fragment = fragment;
        this.url = url;
    }

    @JvmName(name="scheme")
    @NotNull
    public final String scheme() {
        return this.scheme;
    }

    @JvmName(name="username")
    @NotNull
    public final String username() {
        return this.username;
    }

    @JvmName(name="password")
    @NotNull
    public final String password() {
        return this.password;
    }

    @JvmName(name="host")
    @NotNull
    public final String host() {
        return this.host;
    }

    @JvmName(name="port")
    public final int port() {
        return this.port;
    }

    @JvmName(name="pathSegments")
    @NotNull
    public final List<String> pathSegments() {
        return this.pathSegments;
    }

    @JvmName(name="fragment")
    @Nullable
    public final String fragment() {
        return this.fragment;
    }

    public final boolean isHttps() {
        return Intrinsics.areEqual((Object)this.scheme, (Object)"https");
    }

    @JvmName(name="url")
    @NotNull
    public final URL url() {
        try {
            return new URL(this.url);
        }
        catch (MalformedURLException e2) {
            throw new RuntimeException(e2);
        }
    }

    @JvmName(name="uri")
    @NotNull
    public final URI uri() {
        URI uRI;
        String uri = this.newBuilder().reencodeForUri$okhttp().toString();
        try {
            uRI = new URI(uri);
        }
        catch (URISyntaxException e2) {
            URI uRI2;
            try {
                CharSequence charSequence = uri;
                Regex regex2 = new Regex("[\\u0000-\\u001F\\u007F-\\u009F\\p{javaWhitespace}]");
                String string2 = "";
                String stripped = regex2.replace(charSequence, string2);
                uRI2 = URI.create(stripped);
            }
            catch (Exception e1) {
                throw new RuntimeException(e2);
            }
            URI uRI3 = uRI2;
            Intrinsics.checkNotNull((Object)uRI3);
            uRI = uRI3;
        }
        return uRI;
    }

    @JvmName(name="encodedUsername")
    @NotNull
    public final String encodedUsername() {
        if (((CharSequence)this.username).length() == 0) {
            return "";
        }
        int usernameStart = this.scheme.length() + 3;
        int usernameEnd = _UtilCommonKt.delimiterOffset(this.url, ":@", usernameStart, this.url.length());
        String string2 = this.url.substring(usernameStart, usernameEnd);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        return string2;
    }

    @JvmName(name="encodedPassword")
    @NotNull
    public final String encodedPassword() {
        if (((CharSequence)this.password).length() == 0) {
            return "";
        }
        int passwordStart = StringsKt.indexOf$default((CharSequence)this.url, (char)':', (int)(this.scheme.length() + 3), (boolean)false, (int)4, null) + 1;
        int passwordEnd = StringsKt.indexOf$default((CharSequence)this.url, (char)'@', (int)0, (boolean)false, (int)6, null);
        String string2 = this.url.substring(passwordStart, passwordEnd);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        return string2;
    }

    @JvmName(name="pathSize")
    public final int pathSize() {
        return this.pathSegments.size();
    }

    @JvmName(name="encodedPath")
    @NotNull
    public final String encodedPath() {
        int pathStart = StringsKt.indexOf$default((CharSequence)this.url, (char)'/', (int)(this.scheme.length() + 3), (boolean)false, (int)4, null);
        int pathEnd = _UtilCommonKt.delimiterOffset(this.url, "?#", pathStart, this.url.length());
        String string2 = this.url.substring(pathStart, pathEnd);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        return string2;
    }

    @JvmName(name="encodedPathSegments")
    @NotNull
    public final List<String> encodedPathSegments() {
        int pathStart = StringsKt.indexOf$default((CharSequence)this.url, (char)'/', (int)(this.scheme.length() + 3), (boolean)false, (int)4, null);
        int pathEnd = _UtilCommonKt.delimiterOffset(this.url, "?#", pathStart, this.url.length());
        List result2 = new ArrayList();
        int i2 = pathStart;
        while (i2 < pathEnd) {
            int segmentEnd = _UtilCommonKt.delimiterOffset(this.url, '/', ++i2, pathEnd);
            String string2 = this.url.substring(i2, segmentEnd);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            result2.add(string2);
            i2 = segmentEnd;
        }
        return result2;
    }

    @JvmName(name="encodedQuery")
    @Nullable
    public final String encodedQuery() {
        if (this.queryNamesAndValues == null) {
            return null;
        }
        int queryStart = StringsKt.indexOf$default((CharSequence)this.url, (char)'?', (int)0, (boolean)false, (int)6, null) + 1;
        int queryEnd = _UtilCommonKt.delimiterOffset(this.url, '#', queryStart, this.url.length());
        String string2 = this.url.substring(queryStart, queryEnd);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        return string2;
    }

    @JvmName(name="query")
    @Nullable
    public final String query() {
        if (this.queryNamesAndValues == null) {
            return null;
        }
        StringBuilder result2 = new StringBuilder();
        HttpUrl.Companion.toQueryString(this.queryNamesAndValues, result2);
        return result2.toString();
    }

    @JvmName(name="querySize")
    public final int querySize() {
        return this.queryNamesAndValues != null ? this.queryNamesAndValues.size() / 2 : 0;
    }

    @Nullable
    public final String queryParameter(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (this.queryNamesAndValues == null) {
            return null;
        }
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)this.queryNamesAndValues.size())), (int)2);
        int i2 = intProgression.getFirst();
        int n2 = intProgression.getLast();
        int n3 = intProgression.getStep();
        if (n3 > 0 && i2 <= n2 || n3 < 0 && n2 <= i2) {
            while (true) {
                if (Intrinsics.areEqual((Object)name, (Object)this.queryNamesAndValues.get(i2))) {
                    return this.queryNamesAndValues.get(i2 + 1);
                }
                if (i2 == n2) break;
                i2 += n3;
            }
        }
        return null;
    }

    @JvmName(name="queryParameterNames")
    @NotNull
    public final Set<String> queryParameterNames() {
        if (this.queryNamesAndValues == null) {
            return SetsKt.emptySet();
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>();
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)this.queryNamesAndValues.size())), (int)2);
        int i2 = intProgression.getFirst();
        int n2 = intProgression.getLast();
        int n3 = intProgression.getStep();
        if (n3 > 0 && i2 <= n2 || n3 < 0 && n2 <= i2) {
            while (true) {
                String string2 = this.queryNamesAndValues.get(i2);
                Intrinsics.checkNotNull((Object)string2);
                result2.add(string2);
                if (i2 == n2) break;
                i2 += n3;
            }
        }
        return _UtilCommonKt.readOnly((Set)result2);
    }

    @NotNull
    public final List<String> queryParameterValues(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (this.queryNamesAndValues == null) {
            return CollectionsKt.emptyList();
        }
        List result2 = new ArrayList();
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)this.queryNamesAndValues.size())), (int)2);
        int i2 = intProgression.getFirst();
        int n2 = intProgression.getLast();
        int n3 = intProgression.getStep();
        if (n3 > 0 && i2 <= n2 || n3 < 0 && n2 <= i2) {
            while (true) {
                if (Intrinsics.areEqual((Object)name, (Object)this.queryNamesAndValues.get(i2))) {
                    result2.add(this.queryNamesAndValues.get(i2 + 1));
                }
                if (i2 == n2) break;
                i2 += n3;
            }
        }
        return _UtilCommonKt.readOnly(result2);
    }

    @NotNull
    public final String queryParameterName(int index) {
        if (this.queryNamesAndValues == null) {
            throw new IndexOutOfBoundsException();
        }
        String string2 = this.queryNamesAndValues.get(index * 2);
        Intrinsics.checkNotNull((Object)string2);
        return string2;
    }

    @Nullable
    public final String queryParameterValue(int index) {
        if (this.queryNamesAndValues == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.queryNamesAndValues.get(index * 2 + 1);
    }

    @JvmName(name="encodedFragment")
    @Nullable
    public final String encodedFragment() {
        if (this.fragment == null) {
            return null;
        }
        int fragmentStart = StringsKt.indexOf$default((CharSequence)this.url, (char)'#', (int)0, (boolean)false, (int)6, null) + 1;
        String string2 = this.url.substring(fragmentStart);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        return string2;
    }

    @NotNull
    public final String redact() {
        Builder builder = this.newBuilder("/...");
        Intrinsics.checkNotNull((Object)builder);
        return builder.username("").password("").build().toString();
    }

    @Nullable
    public final HttpUrl resolve(@NotNull String link2) {
        Intrinsics.checkNotNullParameter((Object)link2, (String)"link");
        Builder builder = this.newBuilder(link2);
        return builder != null ? builder.build() : null;
    }

    @NotNull
    public final Builder newBuilder() {
        Builder result2 = new Builder();
        result2.setScheme$okhttp(this.scheme);
        result2.setEncodedUsername$okhttp(this.encodedUsername());
        result2.setEncodedPassword$okhttp(this.encodedPassword());
        result2.setHost$okhttp(this.host);
        result2.setPort$okhttp(this.port != Companion.defaultPort(this.scheme) ? this.port : -1);
        result2.getEncodedPathSegments$okhttp().clear();
        result2.getEncodedPathSegments$okhttp().addAll((Collection<String>)this.encodedPathSegments());
        result2.encodedQuery(this.encodedQuery());
        result2.setEncodedFragment$okhttp(this.encodedFragment());
        return result2;
    }

    @Nullable
    public final Builder newBuilder(@NotNull String link2) {
        Builder builder;
        Intrinsics.checkNotNullParameter((Object)link2, (String)"link");
        try {
            builder = new Builder().parse$okhttp(this, link2);
        }
        catch (IllegalArgumentException _) {
            builder = null;
        }
        return builder;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof HttpUrl && Intrinsics.areEqual((Object)((HttpUrl)other).url, (Object)this.url);
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    @NotNull
    public String toString() {
        return this.url;
    }

    @Nullable
    public final String topPrivateDomain() {
        return _HostnamesCommonKt.canParseAsIpAddress(this.host) ? null : PublicSuffixDatabase.Companion.get().getEffectiveTldPlusOne(this.host);
    }

    @Deprecated(message="moved to toUrl()", replaceWith=@ReplaceWith(expression="toUrl()", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_url")
    @NotNull
    public final URL -deprecated_url() {
        return this.url();
    }

    @Deprecated(message="moved to toUri()", replaceWith=@ReplaceWith(expression="toUri()", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_uri")
    @NotNull
    public final URI -deprecated_uri() {
        return this.uri();
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="scheme", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_scheme")
    @NotNull
    public final String -deprecated_scheme() {
        return this.scheme;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="encodedUsername", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_encodedUsername")
    @NotNull
    public final String -deprecated_encodedUsername() {
        return this.encodedUsername();
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="username", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_username")
    @NotNull
    public final String -deprecated_username() {
        return this.username;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="encodedPassword", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_encodedPassword")
    @NotNull
    public final String -deprecated_encodedPassword() {
        return this.encodedPassword();
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="password", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_password")
    @NotNull
    public final String -deprecated_password() {
        return this.password;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="host", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_host")
    @NotNull
    public final String -deprecated_host() {
        return this.host;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="port", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_port")
    public final int -deprecated_port() {
        return this.port;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="pathSize", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_pathSize")
    public final int -deprecated_pathSize() {
        return this.pathSize();
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="encodedPath", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_encodedPath")
    @NotNull
    public final String -deprecated_encodedPath() {
        return this.encodedPath();
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="encodedPathSegments", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_encodedPathSegments")
    @NotNull
    public final List<String> -deprecated_encodedPathSegments() {
        return this.encodedPathSegments();
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="pathSegments", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_pathSegments")
    @NotNull
    public final List<String> -deprecated_pathSegments() {
        return this.pathSegments;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="encodedQuery", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_encodedQuery")
    @Nullable
    public final String -deprecated_encodedQuery() {
        return this.encodedQuery();
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="query", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_query")
    @Nullable
    public final String -deprecated_query() {
        return this.query();
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="querySize", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_querySize")
    public final int -deprecated_querySize() {
        return this.querySize();
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="queryParameterNames", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_queryParameterNames")
    @NotNull
    public final Set<String> -deprecated_queryParameterNames() {
        return this.queryParameterNames();
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="encodedFragment", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_encodedFragment")
    @Nullable
    public final String -deprecated_encodedFragment() {
        return this.encodedFragment();
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="fragment", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_fragment")
    @Nullable
    public final String -deprecated_fragment() {
        return this.fragment;
    }

    @JvmStatic
    public static final int defaultPort(@NotNull String scheme) {
        return Companion.defaultPort(scheme);
    }

    @JvmStatic
    @JvmName(name="get")
    @NotNull
    public static final HttpUrl get(@NotNull String $this$get) {
        return Companion.get($this$get);
    }

    @JvmStatic
    @JvmName(name="parse")
    @Nullable
    public static final HttpUrl parse(@NotNull String $this$parse) {
        return Companion.parse($this$parse);
    }

    @JvmStatic
    @JvmName(name="get")
    @Nullable
    public static final HttpUrl get(@NotNull URL $this$get) {
        return Companion.get($this$get);
    }

    @JvmStatic
    @JvmName(name="get")
    @Nullable
    public static final HttpUrl get(@NotNull URI $this$get) {
        return Companion.get($this$get);
    }

    public /* synthetic */ HttpUrl(String scheme, String username, String password, String host, int port, List pathSegments, List queryNamesAndValues, String fragment, String url, DefaultConstructorMarker $constructor_marker) {
        this(scheme, username, password, host, port, pathSegments, queryNamesAndValues, fragment, url);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010!\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0017\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u0004J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0004J\u0018\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u00042\b\u0010(\u001a\u0004\u0018\u00010\u0004J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u0004J\u000e\u0010+\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u0004J\u0018\u0010+\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u00042\u0006\u0010-\u001a\u00020.H\u0002J\u0018\u0010/\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u00042\b\u00101\u001a\u0004\u0018\u00010\u0004J\u0006\u00102\u001a\u000203J\b\u00104\u001a\u00020\u001bH\u0002J\u0010\u0010\u0003\u001a\u00020\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0004J\u000e\u00105\u001a\u00020\u00002\u0006\u00105\u001a\u00020\u0004J\u0010\u00106\u001a\u00020\u00002\b\u00106\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0004J\u0010\u00107\u001a\u00020\u00002\b\u00107\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0004J\u0010\u00108\u001a\u00020.2\u0006\u00109\u001a\u00020\u0004H\u0002J\u0010\u0010:\u001a\u00020.2\u0006\u00109\u001a\u00020\u0004H\u0002J\u001f\u0010;\u001a\u00020\u00002\b\u0010<\u001a\u0004\u0018\u0001032\u0006\u00109\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b=J \u0010>\u001a\u00020\u001b2\u0006\u00109\u001a\u00020\u00042\u0006\u0010?\u001a\u00020\u001b2\u0006\u0010@\u001a\u00020\u001bH\u0002J\u000e\u0010A\u001a\u00020\u00002\u0006\u0010A\u001a\u00020\u0004J\b\u0010B\u001a\u00020CH\u0002J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001bJ \u0010D\u001a\u00020\u001b2\u0006\u00109\u001a\u00020\u00042\u0006\u0010?\u001a\u00020\u001b2\u0006\u0010@\u001a\u00020\u001bH\u0002J0\u0010E\u001a\u00020C2\u0006\u00109\u001a\u00020\u00042\u0006\u0010?\u001a\u00020\u001b2\u0006\u0010@\u001a\u00020\u001b2\u0006\u0010F\u001a\u00020.2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u0010G\u001a\u00020\u00002\b\u0010G\u001a\u0004\u0018\u00010\u0004J\r\u0010H\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\bIJ\u0010\u0010J\u001a\u00020C2\u0006\u0010K\u001a\u00020\u0004H\u0002J\u000e\u0010L\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u0004J\u000e\u0010M\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u0004J\u000e\u0010N\u001a\u00020\u00002\u0006\u0010O\u001a\u00020\u001bJ \u0010P\u001a\u00020C2\u0006\u00109\u001a\u00020\u00042\u0006\u0010Q\u001a\u00020\u001b2\u0006\u0010@\u001a\u00020\u001bH\u0002J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0004J \u0010R\u001a\u00020\u001b2\u0006\u00109\u001a\u00020\u00042\u0006\u0010?\u001a\u00020\u001b2\u0006\u0010@\u001a\u00020\u001bH\u0002J\u0016\u0010S\u001a\u00020\u00002\u0006\u0010O\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u0004J\u0018\u0010T\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u00042\b\u0010(\u001a\u0004\u0018\u00010\u0004J\u0016\u0010U\u001a\u00020\u00002\u0006\u0010O\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020\u0004J\u0018\u0010V\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u00042\b\u00101\u001a\u0004\u0018\u00010\u0004J\b\u0010W\u001a\u00020\u0004H\u0016J\u000e\u0010X\u001a\u00020\u00002\u0006\u0010X\u001a\u00020\u0004J\u001c\u0010Y\u001a\u00020\u001b*\u00020\u00042\u0006\u0010?\u001a\u00020\u001b2\u0006\u0010@\u001a\u00020\u001bH\u0002J\u001e\u0010Z\u001a\u00020C*\b\u0012\u0004\u0012\u00020\u00040[2\n\u0010\\\u001a\u00060]j\u0002`^H\u0002J\u0014\u0010_\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\r*\u00020\u0004H\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR$\u0010\u0010\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000f\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0006\"\u0004\b\u0016\u0010\bR\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0006\"\u0004\b\u0019\u0010\bR\u001a\u0010\u001a\u001a\u00020\u001bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001c\u0010 \u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0006\"\u0004\b\"\u0010\b\u00a8\u0006`"}, d2={"Lokhttp3/HttpUrl$Builder;", "", "()V", "encodedFragment", "", "getEncodedFragment$okhttp", "()Ljava/lang/String;", "setEncodedFragment$okhttp", "(Ljava/lang/String;)V", "encodedPassword", "getEncodedPassword$okhttp", "setEncodedPassword$okhttp", "encodedPathSegments", "", "getEncodedPathSegments$okhttp", "()Ljava/util/List;", "encodedQueryNamesAndValues", "getEncodedQueryNamesAndValues$okhttp", "setEncodedQueryNamesAndValues$okhttp", "(Ljava/util/List;)V", "encodedUsername", "getEncodedUsername$okhttp", "setEncodedUsername$okhttp", "host", "getHost$okhttp", "setHost$okhttp", "port", "", "getPort$okhttp", "()I", "setPort$okhttp", "(I)V", "scheme", "getScheme$okhttp", "setScheme$okhttp", "addEncodedPathSegment", "encodedPathSegment", "addEncodedPathSegments", "addEncodedQueryParameter", "encodedName", "encodedValue", "addPathSegment", "pathSegment", "addPathSegments", "pathSegments", "alreadyEncoded", "", "addQueryParameter", "name", "value", "build", "Lokhttp3/HttpUrl;", "effectivePort", "encodedPath", "encodedQuery", "fragment", "isDot", "input", "isDotDot", "parse", "base", "parse$okhttp", "parsePort", "pos", "limit", "password", "pop", "", "portColonOffset", "push", "addTrailingSlash", "query", "reencodeForUri", "reencodeForUri$okhttp", "removeAllCanonicalQueryParameters", "canonicalName", "removeAllEncodedQueryParameters", "removeAllQueryParameters", "removePathSegment", "index", "resolvePath", "startPos", "schemeDelimiterOffset", "setEncodedPathSegment", "setEncodedQueryParameter", "setPathSegment", "setQueryParameter", "toString", "username", "slashCount", "toPathString", "", "out", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "toQueryNamesAndValues", "okhttp"})
    @SourceDebugExtension(value={"SMAP\nHttpUrl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpUrl.kt\nokhttp3/HttpUrl$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1821:1\n1#2:1822\n1549#3:1823\n1620#3,3:1824\n1549#3:1827\n1620#3,3:1828\n*S KotlinDebug\n*F\n+ 1 HttpUrl.kt\nokhttp3/HttpUrl$Builder\n*L\n1268#1:1823\n1268#1:1824,3\n1269#1:1827\n1269#1:1828,3\n*E\n"})
    public static final class Builder {
        @Nullable
        private String scheme;
        @NotNull
        private String encodedUsername = "";
        @NotNull
        private String encodedPassword = "";
        @Nullable
        private String host;
        private int port = -1;
        @NotNull
        private final List<String> encodedPathSegments;
        @Nullable
        private List<String> encodedQueryNamesAndValues;
        @Nullable
        private String encodedFragment;

        public Builder() {
            Object[] objectArray = new String[]{""};
            this.encodedPathSegments = CollectionsKt.mutableListOf((Object[])objectArray);
        }

        @Nullable
        public final String getScheme$okhttp() {
            return this.scheme;
        }

        public final void setScheme$okhttp(@Nullable String string2) {
            this.scheme = string2;
        }

        @NotNull
        public final String getEncodedUsername$okhttp() {
            return this.encodedUsername;
        }

        public final void setEncodedUsername$okhttp(@NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
            this.encodedUsername = string2;
        }

        @NotNull
        public final String getEncodedPassword$okhttp() {
            return this.encodedPassword;
        }

        public final void setEncodedPassword$okhttp(@NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
            this.encodedPassword = string2;
        }

        @Nullable
        public final String getHost$okhttp() {
            return this.host;
        }

        public final void setHost$okhttp(@Nullable String string2) {
            this.host = string2;
        }

        public final int getPort$okhttp() {
            return this.port;
        }

        public final void setPort$okhttp(int n2) {
            this.port = n2;
        }

        @NotNull
        public final List<String> getEncodedPathSegments$okhttp() {
            return this.encodedPathSegments;
        }

        @Nullable
        public final List<String> getEncodedQueryNamesAndValues$okhttp() {
            return this.encodedQueryNamesAndValues;
        }

        public final void setEncodedQueryNamesAndValues$okhttp(@Nullable List<String> list) {
            this.encodedQueryNamesAndValues = list;
        }

        @Nullable
        public final String getEncodedFragment$okhttp() {
            return this.encodedFragment;
        }

        public final void setEncodedFragment$okhttp(@Nullable String string2) {
            this.encodedFragment = string2;
        }

        @NotNull
        public final Builder scheme(@NotNull String scheme) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
            Builder $this$scheme_u24lambda_u240 = builder = this;
            boolean bl2 = false;
            if (StringsKt.equals((String)scheme, (String)"http", (boolean)true)) {
                $this$scheme_u24lambda_u240.scheme = "http";
            } else if (StringsKt.equals((String)scheme, (String)"https", (boolean)true)) {
                $this$scheme_u24lambda_u240.scheme = "https";
            } else {
                throw new IllegalArgumentException("unexpected scheme: " + scheme);
            }
            return builder;
        }

        @NotNull
        public final Builder username(@NotNull String username) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)username, (String)"username");
            Builder $this$username_u24lambda_u241 = builder = this;
            boolean bl2 = false;
            $this$username_u24lambda_u241.encodedUsername = _UrlKt.canonicalize$default(username, 0, 0, " \"':;<=>@[]^`{}|/\\?#", false, false, false, false, 123, null);
            return builder;
        }

        @NotNull
        public final Builder encodedUsername(@NotNull String encodedUsername) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)encodedUsername, (String)"encodedUsername");
            Builder $this$encodedUsername_u24lambda_u242 = builder = this;
            boolean bl2 = false;
            $this$encodedUsername_u24lambda_u242.encodedUsername = _UrlKt.canonicalize$default(encodedUsername, 0, 0, " \"':;<=>@[]^`{}|/\\?#", true, false, false, false, 115, null);
            return builder;
        }

        @NotNull
        public final Builder password(@NotNull String password) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)password, (String)"password");
            Builder $this$password_u24lambda_u243 = builder = this;
            boolean bl2 = false;
            $this$password_u24lambda_u243.encodedPassword = _UrlKt.canonicalize$default(password, 0, 0, " \"':;<=>@[]^`{}|/\\?#", false, false, false, false, 123, null);
            return builder;
        }

        @NotNull
        public final Builder encodedPassword(@NotNull String encodedPassword) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)encodedPassword, (String)"encodedPassword");
            Builder $this$encodedPassword_u24lambda_u244 = builder = this;
            boolean bl2 = false;
            $this$encodedPassword_u24lambda_u244.encodedPassword = _UrlKt.canonicalize$default(encodedPassword, 0, 0, " \"':;<=>@[]^`{}|/\\?#", true, false, false, false, 115, null);
            return builder;
        }

        @NotNull
        public final Builder host(@NotNull String host) {
            String encoded;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Builder $this$host_u24lambda_u245 = builder = this;
            boolean bl2 = false;
            String string2 = _HostnamesCommonKt.toCanonicalHost(_UrlKt.percentDecode$default(host, 0, 0, false, 7, null));
            if (string2 == null) {
                throw new IllegalArgumentException("unexpected host: " + host);
            }
            $this$host_u24lambda_u245.host = encoded = string2;
            return builder;
        }

        @NotNull
        public final Builder port(int port) {
            Builder builder;
            Builder $this$port_u24lambda_u247 = builder = this;
            boolean bl2 = false;
            if (!(1 <= port ? port < 65536 : false)) {
                boolean bl3 = false;
                String string2 = "unexpected port: " + port;
                throw new IllegalArgumentException(string2.toString());
            }
            $this$port_u24lambda_u247.port = port;
            return builder;
        }

        @NotNull
        public final Builder addPathSegment(@NotNull String pathSegment) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)pathSegment, (String)"pathSegment");
            Builder $this$addPathSegment_u24lambda_u248 = builder = this;
            boolean bl2 = false;
            $this$addPathSegment_u24lambda_u248.push(pathSegment, 0, pathSegment.length(), false, false);
            return builder;
        }

        @NotNull
        public final Builder addPathSegments(@NotNull String pathSegments) {
            Intrinsics.checkNotNullParameter((Object)pathSegments, (String)"pathSegments");
            return this.addPathSegments(pathSegments, false);
        }

        @NotNull
        public final Builder addEncodedPathSegment(@NotNull String encodedPathSegment) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)encodedPathSegment, (String)"encodedPathSegment");
            Builder $this$addEncodedPathSegment_u24lambda_u249 = builder = this;
            boolean bl2 = false;
            $this$addEncodedPathSegment_u24lambda_u249.push(encodedPathSegment, 0, encodedPathSegment.length(), false, true);
            return builder;
        }

        @NotNull
        public final Builder addEncodedPathSegments(@NotNull String encodedPathSegments) {
            Intrinsics.checkNotNullParameter((Object)encodedPathSegments, (String)"encodedPathSegments");
            return this.addPathSegments(encodedPathSegments, true);
        }

        private final Builder addPathSegments(String pathSegments, boolean alreadyEncoded) {
            int segmentEnd;
            Builder builder;
            Builder $this$addPathSegments_u24lambda_u2410 = builder = this;
            boolean bl2 = false;
            int offset = 0;
            do {
                boolean addTrailingSlash = (segmentEnd = _UtilCommonKt.delimiterOffset(pathSegments, "/\\", offset, pathSegments.length())) < pathSegments.length();
                $this$addPathSegments_u24lambda_u2410.push(pathSegments, offset, segmentEnd, addTrailingSlash, alreadyEncoded);
            } while ((offset = segmentEnd + 1) <= pathSegments.length());
            return builder;
        }

        @NotNull
        public final Builder setPathSegment(int index, @NotNull String pathSegment) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)pathSegment, (String)"pathSegment");
            Builder $this$setPathSegment_u24lambda_u2412 = builder = this;
            boolean bl2 = false;
            String canonicalPathSegment = _UrlKt.canonicalize$default(pathSegment, 0, 0, " \"<>^`{}|/\\?#", false, false, false, false, 123, null);
            if (!(!$this$setPathSegment_u24lambda_u2412.isDot(canonicalPathSegment) && !$this$setPathSegment_u24lambda_u2412.isDotDot(canonicalPathSegment))) {
                boolean bl3 = false;
                String string2 = "unexpected path segment: " + pathSegment;
                throw new IllegalArgumentException(string2.toString());
            }
            $this$setPathSegment_u24lambda_u2412.encodedPathSegments.set(index, canonicalPathSegment);
            return builder;
        }

        @NotNull
        public final Builder setEncodedPathSegment(int index, @NotNull String encodedPathSegment) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)encodedPathSegment, (String)"encodedPathSegment");
            Builder $this$setEncodedPathSegment_u24lambda_u2414 = builder = this;
            boolean bl2 = false;
            String canonicalPathSegment = _UrlKt.canonicalize$default(encodedPathSegment, 0, 0, " \"<>^`{}|/\\?#", true, false, false, false, 115, null);
            $this$setEncodedPathSegment_u24lambda_u2414.encodedPathSegments.set(index, canonicalPathSegment);
            if (!(!$this$setEncodedPathSegment_u24lambda_u2414.isDot(canonicalPathSegment) && !$this$setEncodedPathSegment_u24lambda_u2414.isDotDot(canonicalPathSegment))) {
                boolean bl3 = false;
                String string2 = "unexpected path segment: " + encodedPathSegment;
                throw new IllegalArgumentException(string2.toString());
            }
            return builder;
        }

        @NotNull
        public final Builder removePathSegment(int index) {
            Builder builder;
            Builder $this$removePathSegment_u24lambda_u2415 = builder = this;
            boolean bl2 = false;
            $this$removePathSegment_u24lambda_u2415.encodedPathSegments.remove(index);
            if ($this$removePathSegment_u24lambda_u2415.encodedPathSegments.isEmpty()) {
                $this$removePathSegment_u24lambda_u2415.encodedPathSegments.add("");
            }
            return builder;
        }

        @NotNull
        public final Builder encodedPath(@NotNull String encodedPath) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)encodedPath, (String)"encodedPath");
            Builder $this$encodedPath_u24lambda_u2417 = builder = this;
            boolean bl2 = false;
            if (!StringsKt.startsWith$default((String)encodedPath, (String)"/", (boolean)false, (int)2, null)) {
                boolean bl3 = false;
                String string2 = "unexpected encodedPath: " + encodedPath;
                throw new IllegalArgumentException(string2.toString());
            }
            $this$encodedPath_u24lambda_u2417.resolvePath(encodedPath, 0, encodedPath.length());
            return builder;
        }

        @NotNull
        public final Builder query(@Nullable String query2) {
            String string2;
            Builder builder;
            Builder $this$query_u24lambda_u2418 = builder = this;
            boolean bl2 = false;
            $this$query_u24lambda_u2418.encodedQueryNamesAndValues = query2 != null && (string2 = _UrlKt.canonicalize$default(query2, 0, 0, " \"'<>#", false, false, true, false, 91, null)) != null ? $this$query_u24lambda_u2418.toQueryNamesAndValues(string2) : null;
            return builder;
        }

        @NotNull
        public final Builder encodedQuery(@Nullable String encodedQuery) {
            String string2;
            Builder builder;
            Builder $this$encodedQuery_u24lambda_u2419 = builder = this;
            boolean bl2 = false;
            $this$encodedQuery_u24lambda_u2419.encodedQueryNamesAndValues = encodedQuery != null && (string2 = _UrlKt.canonicalize$default(encodedQuery, 0, 0, " \"'<>#", true, false, true, false, 83, null)) != null ? $this$encodedQuery_u24lambda_u2419.toQueryNamesAndValues(string2) : null;
            return builder;
        }

        @NotNull
        public final Builder addQueryParameter(@NotNull String name, @Nullable String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Builder $this$addQueryParameter_u24lambda_u2420 = builder = this;
            boolean bl2 = false;
            if ($this$addQueryParameter_u24lambda_u2420.encodedQueryNamesAndValues == null) {
                $this$addQueryParameter_u24lambda_u2420.encodedQueryNamesAndValues = new ArrayList();
            }
            List<String> list = $this$addQueryParameter_u24lambda_u2420.encodedQueryNamesAndValues;
            Intrinsics.checkNotNull(list);
            list.add(_UrlKt.canonicalize$default(name, 0, 0, " !\"#$&'(),/:;<=>?@[]\\^`{|}~", false, false, true, false, 91, null));
            List<String> list2 = $this$addQueryParameter_u24lambda_u2420.encodedQueryNamesAndValues;
            Intrinsics.checkNotNull(list2);
            String string2 = value;
            list2.add(string2 != null ? _UrlKt.canonicalize$default(string2, 0, 0, " !\"#$&'(),/:;<=>?@[]\\^`{|}~", false, false, true, false, 91, null) : null);
            return builder;
        }

        @NotNull
        public final Builder addEncodedQueryParameter(@NotNull String encodedName, @Nullable String encodedValue) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)encodedName, (String)"encodedName");
            Builder $this$addEncodedQueryParameter_u24lambda_u2421 = builder = this;
            boolean bl2 = false;
            if ($this$addEncodedQueryParameter_u24lambda_u2421.encodedQueryNamesAndValues == null) {
                $this$addEncodedQueryParameter_u24lambda_u2421.encodedQueryNamesAndValues = new ArrayList();
            }
            List<String> list = $this$addEncodedQueryParameter_u24lambda_u2421.encodedQueryNamesAndValues;
            Intrinsics.checkNotNull(list);
            list.add(_UrlKt.canonicalize$default(encodedName, 0, 0, " \"'<>#&=", true, false, true, false, 83, null));
            List<String> list2 = $this$addEncodedQueryParameter_u24lambda_u2421.encodedQueryNamesAndValues;
            Intrinsics.checkNotNull(list2);
            String string2 = encodedValue;
            list2.add(string2 != null ? _UrlKt.canonicalize$default(string2, 0, 0, " \"'<>#&=", true, false, true, false, 83, null) : null);
            return builder;
        }

        @NotNull
        public final Builder setQueryParameter(@NotNull String name, @Nullable String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Builder $this$setQueryParameter_u24lambda_u2422 = builder = this;
            boolean bl2 = false;
            $this$setQueryParameter_u24lambda_u2422.removeAllQueryParameters(name);
            $this$setQueryParameter_u24lambda_u2422.addQueryParameter(name, value);
            return builder;
        }

        @NotNull
        public final Builder setEncodedQueryParameter(@NotNull String encodedName, @Nullable String encodedValue) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)encodedName, (String)"encodedName");
            Builder $this$setEncodedQueryParameter_u24lambda_u2423 = builder = this;
            boolean bl2 = false;
            $this$setEncodedQueryParameter_u24lambda_u2423.removeAllEncodedQueryParameters(encodedName);
            $this$setEncodedQueryParameter_u24lambda_u2423.addEncodedQueryParameter(encodedName, encodedValue);
            return builder;
        }

        @NotNull
        public final Builder removeAllQueryParameters(@NotNull String name) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Builder $this$removeAllQueryParameters_u24lambda_u2424 = builder = this;
            boolean bl2 = false;
            if ($this$removeAllQueryParameters_u24lambda_u2424.encodedQueryNamesAndValues == null) {
                return $this$removeAllQueryParameters_u24lambda_u2424;
            }
            String nameToRemove = _UrlKt.canonicalize$default(name, 0, 0, " !\"#$&'(),/:;<=>?@[]\\^`{|}~", false, false, true, false, 91, null);
            $this$removeAllQueryParameters_u24lambda_u2424.removeAllCanonicalQueryParameters(nameToRemove);
            return builder;
        }

        @NotNull
        public final Builder removeAllEncodedQueryParameters(@NotNull String encodedName) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)encodedName, (String)"encodedName");
            Builder $this$removeAllEncodedQueryParameters_u24lambda_u2425 = builder = this;
            boolean bl2 = false;
            if ($this$removeAllEncodedQueryParameters_u24lambda_u2425.encodedQueryNamesAndValues == null) {
                return $this$removeAllEncodedQueryParameters_u24lambda_u2425;
            }
            $this$removeAllEncodedQueryParameters_u24lambda_u2425.removeAllCanonicalQueryParameters(_UrlKt.canonicalize$default(encodedName, 0, 0, " \"'<>#&=", true, false, true, false, 83, null));
            return builder;
        }

        private final void removeAllCanonicalQueryParameters(String canonicalName) {
            int n2;
            List<String> list = this.encodedQueryNamesAndValues;
            Intrinsics.checkNotNull(list);
            int i2 = n2 = list.size() - 2;
            int n3 = ProgressionUtilKt.getProgressionLastElement((int)n2, (int)0, (int)-2);
            if (n3 <= i2) {
                while (true) {
                    List<String> list2 = this.encodedQueryNamesAndValues;
                    Intrinsics.checkNotNull(list2);
                    if (Intrinsics.areEqual((Object)canonicalName, (Object)list2.get(i2))) {
                        List<String> list3 = this.encodedQueryNamesAndValues;
                        Intrinsics.checkNotNull(list3);
                        list3.remove(i2 + 1);
                        List<String> list4 = this.encodedQueryNamesAndValues;
                        Intrinsics.checkNotNull(list4);
                        list4.remove(i2);
                        List<String> list5 = this.encodedQueryNamesAndValues;
                        Intrinsics.checkNotNull(list5);
                        if (list5.isEmpty()) {
                            this.encodedQueryNamesAndValues = null;
                            return;
                        }
                    }
                    if (i2 == n3) break;
                    i2 -= 2;
                }
            }
        }

        @NotNull
        public final Builder fragment(@Nullable String fragment) {
            Builder builder;
            Builder $this$fragment_u24lambda_u2426 = builder = this;
            boolean bl2 = false;
            String string2 = fragment;
            $this$fragment_u24lambda_u2426.encodedFragment = string2 != null ? _UrlKt.canonicalize$default(string2, 0, 0, "", false, false, false, true, 59, null) : null;
            return builder;
        }

        @NotNull
        public final Builder encodedFragment(@Nullable String encodedFragment) {
            Builder builder;
            Builder $this$encodedFragment_u24lambda_u2427 = builder = this;
            boolean bl2 = false;
            String string2 = encodedFragment;
            $this$encodedFragment_u24lambda_u2427.encodedFragment = string2 != null ? _UrlKt.canonicalize$default(string2, 0, 0, "", true, false, false, true, 51, null) : null;
            return builder;
        }

        @NotNull
        public final Builder reencodeForUri$okhttp() {
            String string2;
            Builder builder;
            Builder $this$reencodeForUri_u24lambda_u2428 = builder = this;
            boolean bl2 = false;
            String string3 = $this$reencodeForUri_u24lambda_u2428.host;
            if (string3 != null) {
                CharSequence charSequence = string3;
                Regex regex2 = new Regex("[\"<>^`{|}]");
                String string4 = "";
                string2 = regex2.replace(charSequence, string4);
            } else {
                string2 = null;
            }
            $this$reencodeForUri_u24lambda_u2428.host = string2;
            int n2 = $this$reencodeForUri_u24lambda_u2428.encodedPathSegments.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                $this$reencodeForUri_u24lambda_u2428.encodedPathSegments.set(i2, _UrlKt.canonicalize$default($this$reencodeForUri_u24lambda_u2428.encodedPathSegments.get(i2), 0, 0, "[]", true, true, false, false, 99, null));
            }
            List<String> encodedQueryNamesAndValues = $this$reencodeForUri_u24lambda_u2428.encodedQueryNamesAndValues;
            if (encodedQueryNamesAndValues != null) {
                int n3 = encodedQueryNamesAndValues.size();
                for (int i3 = 0; i3 < n3; ++i3) {
                    String string5 = encodedQueryNamesAndValues.get(i3);
                    encodedQueryNamesAndValues.set(i3, string5 != null ? _UrlKt.canonicalize$default(string5, 0, 0, "\\^`{|}", true, true, true, false, 67, null) : null);
                }
            }
            String string6 = $this$reencodeForUri_u24lambda_u2428.encodedFragment;
            $this$reencodeForUri_u24lambda_u2428.encodedFragment = string6 != null ? _UrlKt.canonicalize$default(string6, 0, 0, " \"#<>\\^`{|}", true, true, false, true, 35, null) : null;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final HttpUrl build() {
            Collection<String> collection;
            Collection<String> collection2;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String string2 = this.scheme;
            if (string2 == null) {
                throw new IllegalStateException("scheme == null");
            }
            String string3 = this.host;
            if (string3 == null) {
                throw new IllegalStateException("host == null");
            }
            Iterable iterable = this.encodedPathSegments;
            int n2 = this.effectivePort();
            String string4 = string3;
            String string5 = _UrlKt.percentDecode$default(this.encodedPassword, 0, 0, false, 7, null);
            String string6 = _UrlKt.percentDecode$default(this.encodedUsername, 0, 0, false, 7, null);
            String string7 = string2;
            boolean $i$f$map2 = false;
            void var3_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string8 = (String)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl2 = false;
                collection2.add(_UrlKt.percentDecode$default((String)it, 0, 0, false, 7, null));
            }
            collection2 = (List)destination$iv$iv;
            String string9 = string7;
            String string10 = string6;
            String string11 = string5;
            String string12 = string4;
            int n3 = n2;
            Collection<String> collection3 = collection2;
            List<String> list = this.encodedQueryNamesAndValues;
            if (list != null) {
                Collection<String> collection4;
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                Iterable $i$f$map2 = list;
                collection2 = collection3;
                n2 = n3;
                string4 = string12;
                string5 = string11;
                string6 = string10;
                string7 = string9;
                boolean $i$f$map3 = false;
                destination$iv$iv = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    String bl2 = (String)item$iv$iv;
                    collection4 = destination$iv$iv2;
                    boolean bl3 = false;
                    void v9 = it;
                    collection4.add(v9 != null ? _UrlKt.percentDecode$default((String)v9, 0, 0, true, 3, null) : null);
                }
                collection4 = (List)destination$iv$iv2;
                string9 = string7;
                string10 = string6;
                string11 = string5;
                string12 = string4;
                n3 = n2;
                collection3 = collection2;
                collection = collection4;
            } else {
                collection = null;
            }
            String string13 = this.encodedFragment;
            DefaultConstructorMarker defaultConstructorMarker = null;
            String string14 = this.toString();
            String string15 = string13 != null ? _UrlKt.percentDecode$default(string13, 0, 0, false, 7, null) : null;
            Collection<String> collection5 = collection;
            Collection<String> collection6 = collection3;
            int n4 = n3;
            String string16 = string12;
            String string17 = string11;
            String string18 = string10;
            String string19 = string9;
            return new HttpUrl(string19, string18, string17, string16, n4, (List)collection6, (List)collection5, string15, string14, defaultConstructorMarker);
        }

        private final int effectivePort() {
            int n2;
            if (this.port != -1) {
                n2 = this.port;
            } else {
                String string2 = this.scheme;
                Intrinsics.checkNotNull((Object)string2);
                n2 = Companion.defaultPort(string2);
            }
            return n2;
        }

        @NotNull
        public String toString() {
            StringBuilder $this$toString_u24lambda_u2431;
            StringBuilder stringBuilder;
            block12: {
                int effectivePort;
                block13: {
                    $this$toString_u24lambda_u2431 = stringBuilder = new StringBuilder();
                    boolean bl2 = false;
                    if (this.scheme != null) {
                        $this$toString_u24lambda_u2431.append(this.scheme);
                        $this$toString_u24lambda_u2431.append("://");
                    } else {
                        $this$toString_u24lambda_u2431.append("//");
                    }
                    if (((CharSequence)this.encodedUsername).length() > 0 || ((CharSequence)this.encodedPassword).length() > 0) {
                        $this$toString_u24lambda_u2431.append(this.encodedUsername);
                        if (((CharSequence)this.encodedPassword).length() > 0) {
                            $this$toString_u24lambda_u2431.append(':');
                            $this$toString_u24lambda_u2431.append(this.encodedPassword);
                        }
                        $this$toString_u24lambda_u2431.append('@');
                    }
                    if (this.host != null) {
                        String string2 = this.host;
                        Intrinsics.checkNotNull((Object)string2);
                        if (StringsKt.contains$default((CharSequence)string2, (char)':', (boolean)false, (int)2, null)) {
                            $this$toString_u24lambda_u2431.append('[');
                            $this$toString_u24lambda_u2431.append(this.host);
                            $this$toString_u24lambda_u2431.append(']');
                        } else {
                            $this$toString_u24lambda_u2431.append(this.host);
                        }
                    }
                    if (this.port == -1 && this.scheme == null) break block12;
                    effectivePort = this.effectivePort();
                    if (this.scheme == null) break block13;
                    String string3 = this.scheme;
                    Intrinsics.checkNotNull((Object)string3);
                    if (effectivePort == Companion.defaultPort(string3)) break block12;
                }
                $this$toString_u24lambda_u2431.append(':');
                $this$toString_u24lambda_u2431.append(effectivePort);
            }
            this.toPathString(this.encodedPathSegments, $this$toString_u24lambda_u2431);
            if (this.encodedQueryNamesAndValues != null) {
                $this$toString_u24lambda_u2431.append('?');
                List<String> list = this.encodedQueryNamesAndValues;
                Intrinsics.checkNotNull(list);
                Companion.toQueryString(list, $this$toString_u24lambda_u2431);
            }
            if (this.encodedFragment != null) {
                $this$toString_u24lambda_u2431.append('#');
                $this$toString_u24lambda_u2431.append(this.encodedFragment);
            }
            String string4 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
            return string4;
        }

        private final void toPathString(List<String> $this$toPathString, StringBuilder out) {
            int n2 = $this$toPathString.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                out.append('/');
                out.append($this$toPathString.get(i2));
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public final Builder parse$okhttp(@Nullable HttpUrl base2, @NotNull String input2) {
            Intrinsics.checkNotNullParameter((Object)input2, (String)"input");
            int pos = 0;
            pos = _UtilCommonKt.indexOfFirstNonAsciiWhitespace$default(input2, 0, 0, 3, null);
            int limit = _UtilCommonKt.indexOfLastNonAsciiWhitespace$default(input2, pos, 0, 2, null);
            int schemeDelimiterOffset = this.schemeDelimiterOffset(input2, pos, limit);
            if (schemeDelimiterOffset != -1) {
                if (StringsKt.startsWith((String)input2, (String)"https:", (int)pos, (boolean)true)) {
                    this.scheme = "https";
                    pos += 6;
                } else {
                    if (!StringsKt.startsWith((String)input2, (String)"http:", (int)pos, (boolean)true)) {
                        StringBuilder stringBuilder = new StringBuilder().append("Expected URL scheme 'http' or 'https' but was '");
                        String string2 = input2.substring(0, schemeDelimiterOffset);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                        throw new IllegalArgumentException(stringBuilder.append(string2).append('\'').toString());
                    }
                    this.scheme = "http";
                    pos += 5;
                }
            } else if (base2 != null) {
                this.scheme = base2.scheme();
            } else {
                String truncated = input2.length() > 6 ? StringsKt.take((String)input2, (int)6) + "..." : input2;
                throw new IllegalArgumentException("Expected URL scheme 'http' or 'https' but no scheme was found for " + truncated);
            }
            boolean hasUsername = false;
            boolean hasPassword = false;
            int slashCount = this.slashCount(input2, pos, limit);
            if (slashCount < 2 && base2 != null && Intrinsics.areEqual((Object)base2.scheme(), (Object)this.scheme)) {
                this.encodedUsername = base2.encodedUsername();
                this.encodedPassword = base2.encodedPassword();
                this.host = base2.host();
                this.port = base2.port();
                this.encodedPathSegments.clear();
                this.encodedPathSegments.addAll((Collection<String>)base2.encodedPathSegments());
                if (pos == limit || input2.charAt(pos) == '#') {
                    this.encodedQuery(base2.encodedQuery());
                }
            } else {
                pos += slashCount;
                block4: while (true) {
                    int componentDelimiterOffset;
                    int c2 = (componentDelimiterOffset = _UtilCommonKt.delimiterOffset(input2, "@/\\?#", pos, limit)) != limit ? (int)input2.charAt(componentDelimiterOffset) : -1;
                    switch (c2) {
                        case 64: {
                            if (!hasPassword) {
                                int passwordColonOffset = _UtilCommonKt.delimiterOffset(input2, ':', pos, componentDelimiterOffset);
                                String canonicalUsername = _UrlKt.canonicalize$default(input2, pos, passwordColonOffset, " \"':;<=>@[]^`{}|/\\?#", true, false, false, false, 112, null);
                                String string3 = this.encodedUsername = hasUsername ? this.encodedUsername + "%40" + canonicalUsername : canonicalUsername;
                                if (passwordColonOffset != componentDelimiterOffset) {
                                    hasPassword = true;
                                    this.encodedPassword = _UrlKt.canonicalize$default(input2, passwordColonOffset + 1, componentDelimiterOffset, " \"':;<=>@[]^`{}|/\\?#", true, false, false, false, 112, null);
                                }
                                hasUsername = true;
                            } else {
                                this.encodedPassword = this.encodedPassword + "%40" + _UrlKt.canonicalize$default(input2, pos, componentDelimiterOffset, " \"':;<=>@[]^`{}|/\\?#", true, false, false, false, 112, null);
                            }
                            pos = componentDelimiterOffset + 1;
                            continue block4;
                        }
                        case -1: 
                        case 35: 
                        case 47: 
                        case 63: 
                        case 92: {
                            int portColonOffset = this.portColonOffset(input2, pos, componentDelimiterOffset);
                            if (portColonOffset + 1 < componentDelimiterOffset) {
                                this.host = _HostnamesCommonKt.toCanonicalHost(_UrlKt.percentDecode$default(input2, pos, portColonOffset, false, 4, null));
                                this.port = this.parsePort(input2, portColonOffset + 1, componentDelimiterOffset);
                                if (!(this.port != -1)) {
                                    boolean $i$a$-require-HttpUrl$Builder$parse$32 = false;
                                    StringBuilder stringBuilder = new StringBuilder().append("Invalid URL port: \"");
                                    String string4 = input2.substring(portColonOffset + 1, componentDelimiterOffset);
                                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                                    String $i$a$-require-HttpUrl$Builder$parse$32 = stringBuilder.append(string4).append('\"').toString();
                                    throw new IllegalArgumentException($i$a$-require-HttpUrl$Builder$parse$32.toString());
                                }
                            } else {
                                this.host = _HostnamesCommonKt.toCanonicalHost(_UrlKt.percentDecode$default(input2, pos, portColonOffset, false, 4, null));
                                String string5 = this.scheme;
                                Intrinsics.checkNotNull((Object)string5);
                                this.port = Companion.defaultPort(string5);
                            }
                            if (!(this.host != null)) {
                                boolean bl2 = false;
                                StringBuilder stringBuilder = new StringBuilder().append("Invalid URL host: \"");
                                String string6 = input2.substring(pos, portColonOffset);
                                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                                String string7 = stringBuilder.append(string6).append('\"').toString();
                                throw new IllegalArgumentException(string7.toString());
                            }
                            pos = componentDelimiterOffset;
                            break block4;
                        }
                        default: {
                            continue block4;
                        }
                    }
                    break;
                }
            }
            int pathDelimiterOffset = _UtilCommonKt.delimiterOffset(input2, "?#", pos, limit);
            this.resolvePath(input2, pos, pathDelimiterOffset);
            pos = pathDelimiterOffset;
            if (pos < limit && input2.charAt(pos) == '?') {
                int queryDelimiterOffset = _UtilCommonKt.delimiterOffset(input2, '#', pos, limit);
                this.encodedQueryNamesAndValues = this.toQueryNamesAndValues(_UrlKt.canonicalize$default(input2, pos + 1, queryDelimiterOffset, " \"'<>#", true, false, true, false, 80, null));
                pos = queryDelimiterOffset;
            }
            if (pos < limit && input2.charAt(pos) == '#') {
                this.encodedFragment = _UrlKt.canonicalize$default(input2, pos + 1, limit, "", true, false, false, true, 48, null);
            }
            return this;
        }

        private final void resolvePath(String input2, int startPos, int limit) {
            int pos = startPos;
            if (pos == limit) {
                return;
            }
            char c2 = input2.charAt(pos);
            if (c2 == '/' || c2 == '\\') {
                this.encodedPathSegments.clear();
                this.encodedPathSegments.add("");
                ++pos;
            } else {
                this.encodedPathSegments.set(this.encodedPathSegments.size() - 1, "");
            }
            int i2 = pos;
            while (i2 < limit) {
                int pathSegmentDelimiterOffset = _UtilCommonKt.delimiterOffset(input2, "/\\", i2, limit);
                boolean segmentHasTrailingSlash = pathSegmentDelimiterOffset < limit;
                this.push(input2, i2, pathSegmentDelimiterOffset, segmentHasTrailingSlash, true);
                i2 = pathSegmentDelimiterOffset;
                if (!segmentHasTrailingSlash) continue;
                ++i2;
            }
        }

        private final void push(String input2, int pos, int limit, boolean addTrailingSlash, boolean alreadyEncoded) {
            String segment = _UrlKt.canonicalize$default(input2, pos, limit, " \"<>^`{}|/\\?#", alreadyEncoded, false, false, false, 112, null);
            if (this.isDot(segment)) {
                return;
            }
            if (this.isDotDot(segment)) {
                this.pop();
                return;
            }
            if (((CharSequence)this.encodedPathSegments.get(this.encodedPathSegments.size() - 1)).length() == 0) {
                this.encodedPathSegments.set(this.encodedPathSegments.size() - 1, segment);
            } else {
                this.encodedPathSegments.add(segment);
            }
            if (addTrailingSlash) {
                this.encodedPathSegments.add("");
            }
        }

        private final void pop() {
            String removed = this.encodedPathSegments.remove(this.encodedPathSegments.size() - 1);
            if (((CharSequence)removed).length() == 0 && !((Collection)this.encodedPathSegments).isEmpty()) {
                this.encodedPathSegments.set(this.encodedPathSegments.size() - 1, "");
            } else {
                this.encodedPathSegments.add("");
            }
        }

        private final boolean isDot(String input2) {
            return Intrinsics.areEqual((Object)input2, (Object)".") || StringsKt.equals((String)input2, (String)"%2e", (boolean)true);
        }

        private final boolean isDotDot(String input2) {
            return Intrinsics.areEqual((Object)input2, (Object)"..") || StringsKt.equals((String)input2, (String)"%2e.", (boolean)true) || StringsKt.equals((String)input2, (String)".%2e", (boolean)true) || StringsKt.equals((String)input2, (String)"%2e%2e", (boolean)true);
        }

        private final List<String> toQueryNamesAndValues(String $this$toQueryNamesAndValues) {
            List result2 = new ArrayList();
            int pos = 0;
            while (pos <= $this$toQueryNamesAndValues.length()) {
                int equalsOffset;
                int ampersandOffset = StringsKt.indexOf$default((CharSequence)$this$toQueryNamesAndValues, (char)'&', (int)pos, (boolean)false, (int)4, null);
                if (ampersandOffset == -1) {
                    ampersandOffset = $this$toQueryNamesAndValues.length();
                }
                if ((equalsOffset = StringsKt.indexOf$default((CharSequence)$this$toQueryNamesAndValues, (char)'=', (int)pos, (boolean)false, (int)4, null)) == -1 || equalsOffset > ampersandOffset) {
                    String string2 = $this$toQueryNamesAndValues.substring(pos, ampersandOffset);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    result2.add(string2);
                    result2.add(null);
                } else {
                    String string3 = $this$toQueryNamesAndValues.substring(pos, equalsOffset);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    result2.add(string3);
                    String string4 = $this$toQueryNamesAndValues.substring(equalsOffset + 1, ampersandOffset);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                    result2.add(string4);
                }
                pos = ampersandOffset + 1;
            }
            return result2;
        }

        private final int schemeDelimiterOffset(String input2, int pos, int limit) {
            if (limit - pos < 2) {
                return -1;
            }
            char c0 = input2.charAt(pos);
            if (!(Intrinsics.compare((int)c0, (int)97) >= 0 && Intrinsics.compare((int)c0, (int)122) <= 0 || Intrinsics.compare((int)c0, (int)65) >= 0 && Intrinsics.compare((int)c0, (int)90) <= 0)) {
                return -1;
            }
            for (int i2 = pos + 1; i2 < limit; ++i2) {
                char c2 = input2.charAt(i2);
                if (((((('a' <= c2 ? c2 < '{' : false) ? true : ('A' <= c2 ? c2 < '[' : false)) ? true : ('0' <= c2 ? c2 < ':' : false)) ? true : c2 == '+') ? true : c2 == '-') ? true : c2 == '.') continue;
                return c2 == ':' ? i2 : -1;
            }
            return -1;
        }

        private final int slashCount(String $this$slashCount, int pos, int limit) {
            char c2;
            int slashCount = 0;
            for (int i2 = pos; i2 < limit && ((c2 = $this$slashCount.charAt(i2)) == '\\' || c2 == '/'); ++i2) {
                ++slashCount;
            }
            return slashCount;
        }

        private final int portColonOffset(String input2, int pos, int limit) {
            for (int i2 = pos; i2 < limit; ++i2) {
                char c2 = input2.charAt(i2);
                if (c2 == '[') {
                    while (++i2 < limit && input2.charAt(i2) != ']') {
                    }
                    continue;
                }
                if (c2 != ':') continue;
                return i2;
            }
            return limit;
        }

        private final int parsePort(String input2, int pos, int limit) {
            int n2;
            try {
                String portString = _UrlKt.canonicalize$default(input2, pos, limit, "", false, false, false, false, 120, null);
                int i2 = Integer.parseInt(portString);
                n2 = (1 <= i2 ? i2 < 65536 : false) ? i2 : -1;
            }
            catch (NumberFormatException _) {
                n2 = -1;
            }
            return n2;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0017\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0007\u00a2\u0006\u0002\b\u000bJ\u0017\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\rH\u0007\u00a2\u0006\u0002\b\u000bJ\u0015\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0006H\u0007\u00a2\u0006\u0002\b\u000bJ\u0017\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\u0006H\u0007\u00a2\u0006\u0002\b\u000fJ\u0011\u0010\u0010\u001a\u00020\b*\u00020\u0006H\u0007\u00a2\u0006\u0002\b\u0007J\u0013\u0010\u0011\u001a\u0004\u0018\u00010\b*\u00020\nH\u0007\u00a2\u0006\u0002\b\u0007J\u0013\u0010\u0011\u001a\u0004\u0018\u00010\b*\u00020\rH\u0007\u00a2\u0006\u0002\b\u0007J\u0013\u0010\u0011\u001a\u0004\u0018\u00010\b*\u00020\u0006H\u0007\u00a2\u0006\u0002\b\u000eJ \u0010\u0012\u001a\u00020\u0013*\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00142\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u0017H\u0002\u00a8\u0006\u0018"}, d2={"Lokhttp3/HttpUrl$Companion;", "", "()V", "defaultPort", "", "scheme", "", "get", "Lokhttp3/HttpUrl;", "uri", "Ljava/net/URI;", "-deprecated_get", "url", "Ljava/net/URL;", "parse", "-deprecated_parse", "toHttpUrl", "toHttpUrlOrNull", "toQueryString", "", "", "out", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final int defaultPort(@NotNull String scheme) {
            Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
            String string2 = scheme;
            return Intrinsics.areEqual((Object)string2, (Object)"http") ? 80 : (Intrinsics.areEqual((Object)string2, (Object)"https") ? 443 : -1);
        }

        private final void toQueryString(List<String> $this$toQueryString, StringBuilder out) {
            IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)$this$toQueryString.size())), (int)2);
            int i2 = intProgression.getFirst();
            int n2 = intProgression.getLast();
            int n3 = intProgression.getStep();
            if (n3 > 0 && i2 <= n2 || n3 < 0 && n2 <= i2) {
                while (true) {
                    String name = $this$toQueryString.get(i2);
                    String value = $this$toQueryString.get(i2 + 1);
                    if (i2 > 0) {
                        out.append('&');
                    }
                    out.append(name);
                    if (value != null) {
                        out.append('=');
                        out.append(value);
                    }
                    if (i2 == n2) break;
                    i2 += n3;
                }
            }
        }

        @JvmStatic
        @JvmName(name="get")
        @NotNull
        public final HttpUrl get(@NotNull String $this$toHttpUrl) {
            Intrinsics.checkNotNullParameter((Object)$this$toHttpUrl, (String)"<this>");
            return new Builder().parse$okhttp(null, $this$toHttpUrl).build();
        }

        @JvmStatic
        @JvmName(name="parse")
        @Nullable
        public final HttpUrl parse(@NotNull String $this$toHttpUrlOrNull) {
            HttpUrl httpUrl;
            Intrinsics.checkNotNullParameter((Object)$this$toHttpUrlOrNull, (String)"<this>");
            try {
                httpUrl = this.get($this$toHttpUrlOrNull);
            }
            catch (IllegalArgumentException _) {
                httpUrl = null;
            }
            return httpUrl;
        }

        @JvmStatic
        @JvmName(name="get")
        @Nullable
        public final HttpUrl get(@NotNull URL $this$toHttpUrlOrNull) {
            Intrinsics.checkNotNullParameter((Object)$this$toHttpUrlOrNull, (String)"<this>");
            String string2 = $this$toHttpUrlOrNull.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            return this.parse(string2);
        }

        @JvmStatic
        @JvmName(name="get")
        @Nullable
        public final HttpUrl get(@NotNull URI $this$toHttpUrlOrNull) {
            Intrinsics.checkNotNullParameter((Object)$this$toHttpUrlOrNull, (String)"<this>");
            String string2 = $this$toHttpUrlOrNull.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            return this.parse(string2);
        }

        @Deprecated(message="moved to extension function", replaceWith=@ReplaceWith(expression="url.toHttpUrl()", imports={"okhttp3.HttpUrl.Companion.toHttpUrl"}), level=DeprecationLevel.ERROR)
        @JvmName(name="-deprecated_get")
        @NotNull
        public final HttpUrl -deprecated_get(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return this.get(url);
        }

        @Deprecated(message="moved to extension function", replaceWith=@ReplaceWith(expression="url.toHttpUrlOrNull()", imports={"okhttp3.HttpUrl.Companion.toHttpUrlOrNull"}), level=DeprecationLevel.ERROR)
        @JvmName(name="-deprecated_parse")
        @Nullable
        public final HttpUrl -deprecated_parse(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return this.parse(url);
        }

        @Deprecated(message="moved to extension function", replaceWith=@ReplaceWith(expression="url.toHttpUrlOrNull()", imports={"okhttp3.HttpUrl.Companion.toHttpUrlOrNull"}), level=DeprecationLevel.ERROR)
        @JvmName(name="-deprecated_get")
        @Nullable
        public final HttpUrl -deprecated_get(@NotNull URL url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return this.get(url);
        }

        @Deprecated(message="moved to extension function", replaceWith=@ReplaceWith(expression="uri.toHttpUrlOrNull()", imports={"okhttp3.HttpUrl.Companion.toHttpUrlOrNull"}), level=DeprecationLevel.ERROR)
        @JvmName(name="-deprecated_get")
        @Nullable
        public final HttpUrl -deprecated_get(@NotNull URI uri) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            return this.get(uri);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

