/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.idn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import okio.Buffer;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001c\u001a\u00020\rJ(\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001c\u001a\u00020\rJ(\u0010#\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020!H\u0002J\"\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00040%*\u00020\r2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004H\u0002J\u001c\u0010&\u001a\u00020\u001a*\u00020\r2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0013\u001a\u00020\u0004*\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006'"}, d2={"Lokhttp3/internal/idn/Punycode;", "", "()V", "BASE", "", "DAMP", "INITIAL_BIAS", "INITIAL_N", "PREFIX", "Lokio/ByteString;", "getPREFIX", "()Lokio/ByteString;", "PREFIX_STRING", "", "getPREFIX_STRING", "()Ljava/lang/String;", "SKEW", "TMAX", "TMIN", "punycodeDigit", "getPunycodeDigit", "(I)I", "adapt", "delta", "numpoints", "first", "", "decode", "string", "decodeLabel", "pos", "limit", "result", "Lokio/Buffer;", "encode", "encodeLabel", "codePoints", "", "requiresEncode", "okhttp"})
@SourceDebugExtension(value={"SMAP\nPunycode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Punycode.kt\nokhttp3/internal/idn/Punycode\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,329:1\n2310#2,14:330\n*S KotlinDebug\n*F\n+ 1 Punycode.kt\nokhttp3/internal/idn/Punycode\n*L\n108#1:330,14\n*E\n"})
public final class Punycode {
    @NotNull
    public static final Punycode INSTANCE = new Punycode();
    @NotNull
    private static final String PREFIX_STRING = "xn--";
    @NotNull
    private static final ByteString PREFIX = ByteString.Companion.encodeUtf8(PREFIX_STRING);
    private static final int BASE = 36;
    private static final int TMIN = 1;
    private static final int TMAX = 26;
    private static final int SKEW = 38;
    private static final int DAMP = 700;
    private static final int INITIAL_BIAS = 72;
    private static final int INITIAL_N = 128;

    private Punycode() {
    }

    @NotNull
    public final String getPREFIX_STRING() {
        return PREFIX_STRING;
    }

    @NotNull
    public final ByteString getPREFIX() {
        return PREFIX;
    }

    @Nullable
    public final String encode(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"string");
        int pos = 0;
        int limit = string2.length();
        Buffer result2 = new Buffer();
        while (pos < limit) {
            int dot = StringsKt.indexOf$default((CharSequence)string2, (char)'.', (int)pos, (boolean)false, (int)4, null);
            if (dot == -1) {
                dot = limit;
            }
            if (!this.encodeLabel(string2, pos, dot, result2)) {
                return null;
            }
            if (dot >= limit) break;
            result2.writeByte(46);
            pos = dot + 1;
        }
        return result2.readUtf8();
    }

    private final boolean encodeLabel(String string2, int pos, int limit, Buffer result2) {
        if (!this.requiresEncode(string2, pos, limit)) {
            result2.writeUtf8(string2, pos, limit);
            return true;
        }
        result2.write(PREFIX);
        List<Integer> input2 = this.codePoints(string2, pos, limit);
        int b2 = 0;
        Iterator<Integer> iterator2 = input2.iterator();
        while (iterator2.hasNext()) {
            int codePoint = ((Number)iterator2.next()).intValue();
            if (codePoint >= 128) continue;
            result2.writeByte(codePoint);
            ++b2;
        }
        if (b2 > 0) {
            result2.writeByte(45);
        }
        int n2 = 0;
        n2 = 128;
        int delta = 0;
        int bias = 72;
        int h7 = b2;
        while (h7 < input2.size()) {
            Object t2;
            Iterable $this$minBy$iv = input2;
            boolean $i$f$minByOrThrow = false;
            Iterator iterator$iv = $this$minBy$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new NoSuchElementException();
            }
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                t2 = minElem$iv;
            } else {
                int it = ((Number)minElem$iv).intValue();
                boolean bl2 = false;
                int minValue$iv = it >= n2 ? it : Integer.MAX_VALUE;
                do {
                    int v$iv;
                    Object e$iv = iterator$iv.next();
                    int it2 = ((Number)e$iv).intValue();
                    $i$a$-minByOrThrow-Punycode$encodeLabel$m$1 = false;
                    int n3 = v$iv = it2 >= n2 ? it2 : Integer.MAX_VALUE;
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                t2 = minElem$iv;
            }
            int m2 = ((Number)t2).intValue();
            int increment = (m2 - n2) * (h7 + 1);
            if (delta > Integer.MAX_VALUE - increment) {
                return false;
            }
            delta += increment;
            n2 = m2;
            Iterator<Integer> iterator3 = input2.iterator();
            while (iterator3.hasNext()) {
                int q2;
                block17: {
                    int n4;
                    int n5;
                    int k2;
                    block16: {
                        int c2 = ((Number)iterator3.next()).intValue();
                        if (c2 < n2) {
                            if (delta == Integer.MAX_VALUE) {
                                return false;
                            }
                            ++delta;
                            continue;
                        }
                        if (c2 != n2) continue;
                        q2 = delta;
                        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)36, (int)Integer.MAX_VALUE)), (int)36);
                        k2 = intProgression.getFirst();
                        n5 = intProgression.getLast();
                        n4 = intProgression.getStep();
                        if (n4 > 0 && k2 <= n5) break block16;
                        if (n4 >= 0 || n5 > k2) break block17;
                    }
                    while (true) {
                        int t3;
                        int n6 = k2 <= bias ? 1 : (t3 = k2 >= bias + 26 ? 26 : k2 - bias);
                        if (q2 < t3) break;
                        result2.writeByte(this.getPunycodeDigit(t3 + (q2 - t3) % (36 - t3)));
                        q2 = (q2 - t3) / (36 - t3);
                        if (k2 == n5) break;
                        k2 += n4;
                    }
                }
                result2.writeByte(this.getPunycodeDigit(q2));
                bias = this.adapt(delta, h7 + 1, h7 == b2);
                delta = 0;
                ++h7;
            }
            ++delta;
            int n7 = n2;
            n2 = n7 + 1;
        }
        return true;
    }

    @Nullable
    public final String decode(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"string");
        int pos = 0;
        int limit = string2.length();
        Buffer result2 = new Buffer();
        while (pos < limit) {
            int dot = StringsKt.indexOf$default((CharSequence)string2, (char)'.', (int)pos, (boolean)false, (int)4, null);
            if (dot == -1) {
                dot = limit;
            }
            if (!this.decodeLabel(string2, pos, dot, result2)) {
                return null;
            }
            if (dot >= limit) break;
            result2.writeByte(46);
            pos = dot + 1;
        }
        return result2.readUtf8();
    }

    private final boolean decodeLabel(String string2, int pos, int limit, Buffer result2) {
        if (!StringsKt.regionMatches((String)string2, (int)pos, (String)PREFIX_STRING, (int)0, (int)4, (boolean)true)) {
            result2.writeUtf8(string2, pos, limit);
            return true;
        }
        int pos2 = pos + 4;
        List codePoints = new ArrayList();
        int lastDelimiter = StringsKt.lastIndexOf$default((CharSequence)string2, (char)'-', (int)limit, (boolean)false, (int)4, null);
        if (lastDelimiter >= pos2) {
            while (pos2 < lastDelimiter) {
                char codePoint;
                boolean bl2 = (('a' <= (codePoint = string2.charAt(pos2++)) ? codePoint < '{' : false) ? true : ('A' <= codePoint ? codePoint < '[' : false)) ? true : ('0' <= codePoint ? codePoint < ':' : false);
                if (bl2 ? true : codePoint == '-') {
                    ((Collection)codePoints).add(Integer.valueOf(codePoint));
                    continue;
                }
                return false;
            }
            ++pos2;
        }
        int n2 = 128;
        int i2 = 0;
        int bias = 72;
        while (pos2 < limit) {
            int oldi = i2;
            int w2 = 1;
            IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)36, (int)Integer.MAX_VALUE)), (int)36);
            int k2 = intProgression.getFirst();
            int n3 = intProgression.getLast();
            int n4 = intProgression.getStep();
            if (n4 > 0 && k2 <= n3 || n4 < 0 && n3 <= k2) {
                while (true) {
                    int t2;
                    int n5;
                    char c2;
                    char c3;
                    if (pos2 == limit) {
                        return false;
                    }
                    boolean bl3 = 'a' <= (c3 = (c2 = string2.charAt(pos2++))) ? c3 < '{' : false;
                    if (bl3) {
                        n5 = c2 - 97;
                    } else {
                        boolean bl4 = 'A' <= c3 ? c3 < '[' : false;
                        if (bl4) {
                            n5 = c2 - 65;
                        } else {
                            boolean bl5 = '0' <= c3 ? c3 < ':' : false;
                            if (bl5) {
                                n5 = c2 - 48 + 26;
                            } else {
                                return false;
                            }
                        }
                    }
                    int digit = n5;
                    int deltaI = digit * w2;
                    if (i2 > Integer.MAX_VALUE - deltaI) {
                        return false;
                    }
                    i2 += deltaI;
                    int n6 = k2 <= bias ? 1 : (t2 = k2 >= bias + 26 ? 26 : k2 - bias);
                    if (digit < t2) break;
                    int scaleW = 36 - t2;
                    if (w2 > Integer.MAX_VALUE / scaleW) {
                        return false;
                    }
                    w2 *= scaleW;
                    if (k2 == n3) break;
                    k2 += n4;
                }
            }
            bias = this.adapt(i2 - oldi, codePoints.size() + 1, oldi == 0);
            int deltaN = i2 / (codePoints.size() + 1);
            if (n2 > Integer.MAX_VALUE - deltaN) {
                return false;
            }
            i2 %= codePoints.size() + 1;
            if ((n2 += deltaN) > 0x10FFFF) {
                return false;
            }
            codePoints.add(i2, n2);
            ++i2;
        }
        Iterator iterator2 = codePoints.iterator();
        while (iterator2.hasNext()) {
            int codePoint = ((Number)iterator2.next()).intValue();
            result2.writeUtf8CodePoint(codePoint);
        }
        return true;
    }

    private final int adapt(int delta, int numpoints, boolean first2) {
        int delta2 = first2 ? delta / 700 : delta / 2;
        delta2 += delta2 / numpoints;
        int k2 = 0;
        while (delta2 > 455) {
            delta2 /= 35;
            k2 += 36;
        }
        return k2 + 36 * delta2 / (delta2 + 38);
    }

    private final boolean requiresEncode(String $this$requiresEncode, int pos, int limit) {
        for (int i2 = pos; i2 < limit; ++i2) {
            if ($this$requiresEncode.charAt(i2) < '\u0080') continue;
            return true;
        }
        return false;
    }

    private final List<Integer> codePoints(String $this$codePoints, int pos, int limit) {
        List result2 = new ArrayList();
        for (int i2 = pos; i2 < limit; ++i2) {
            int n2;
            int c2 = $this$codePoints.charAt(i2);
            Collection collection = result2;
            if (CharsKt.isSurrogate((char)c2)) {
                char low;
                char c3 = low = i2 + 1 < limit ? $this$codePoints.charAt(i2 + 1) : (char)'\u0000';
                if (Character.isLowSurrogate((char)c2) || !Character.isLowSurrogate(low)) {
                    n2 = 63;
                } else {
                    ++i2;
                    n2 = 65536 + ((c2 & 0x3FF) << 10 | low & 0x3FF);
                }
            } else {
                n2 = c2;
            }
            Integer n3 = n2;
            collection.add(n3);
        }
        return result2;
    }

    private final int getPunycodeDigit(int $this$punycodeDigit) {
        int n2;
        if ($this$punycodeDigit < 26) {
            n2 = $this$punycodeDigit + 97;
        } else if ($this$punycodeDigit < 36) {
            n2 = $this$punycodeDigit - 26 + 48;
        } else {
            throw new IllegalStateException(("unexpected digit: " + $this$punycodeDigit).toString());
        }
        return n2;
    }
}

