/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.util.List;
import java.util.Spliterator;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import one.util.streamex.Internals;

final class PairPermutationSpliterator<T, R>
extends Internals.CloneableSpliterator<R, PairPermutationSpliterator<T, R>> {
    private long cur;
    private long limit;
    private final int size;
    private int idx1;
    private int idx2;
    private final List<T> list;
    private final BiFunction<? super T, ? super T, ? extends R> mapper;

    public PairPermutationSpliterator(List<T> list, BiFunction<? super T, ? super T, ? extends R> mapper) {
        this.list = list;
        this.size = list.size();
        this.idx2 = 1;
        this.limit = (long)this.size * ((long)this.size - 1L) / 2L;
        this.mapper = mapper;
    }

    @Override
    public long estimateSize() {
        return this.limit - this.cur;
    }

    @Override
    public int characteristics() {
        return 16464;
    }

    static int isqrt(long n2) {
        int x2 = (int)((Math.sqrt(8.0 * (double)n2 + 1.0) - 1.0) / 2.0);
        if ((long)x2 * ((long)x2 + 1L) / 2L > n2) {
            --x2;
        }
        return x2;
    }

    @Override
    public Spliterator<R> trySplit() {
        long size = this.limit - this.cur;
        if (size >= 2L) {
            PairPermutationSpliterator clone = (PairPermutationSpliterator)this.doClone();
            clone.limit = this.cur += size / 2L;
            int s2 = this.size;
            long rev = (long)s2 * ((long)s2 - 1L) / 2L - this.cur - 1L;
            int row = PairPermutationSpliterator.isqrt(rev);
            int col2 = (int)(rev - (long)row * ((long)row + 1L) / 2L);
            this.idx1 = s2 - row - 2;
            this.idx2 = s2 - col2 - 1;
            return clone;
        }
        return null;
    }

    @Override
    public boolean tryAdvance(Consumer<? super R> action) {
        if (this.cur == this.limit) {
            return false;
        }
        action.accept(this.mapper.apply(this.list.get(this.idx1), this.list.get(this.idx2)));
        ++this.cur;
        if (++this.idx2 == this.size) {
            this.idx2 = ++this.idx1 + 1;
        }
        return true;
    }

    @Override
    public void forEachRemaining(Consumer<? super R> action) {
        int idx1 = this.idx1;
        int idx2 = this.idx2;
        int size = this.size;
        long cur = this.cur;
        long limit = this.limit;
        while (cur < limit) {
            T item1 = this.list.get(idx1++);
            while (cur < limit && idx2 < size) {
                T item2 = this.list.get(idx2++);
                action.accept(this.mapper.apply(item1, item2));
                ++cur;
            }
            idx2 = idx1 + 1;
        }
        this.cur = this.limit;
    }
}

