/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.File;
import java.io.FileInputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.file.Path;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.cli.Converter;
import org.apache.commons.cli.ParseException;

public class TypeHandler {
    private static final TypeHandler DEFAULT = new TypeHandler();
    private static final int HEX_RADIX = 16;
    private final Map<Class<?>, Converter<?, ? extends Throwable>> converterMap;

    public static Class<?> createClass(String className) throws ParseException {
        return TypeHandler.createValue(className, Class.class);
    }

    public static Date createDate(String string2) {
        return TypeHandler.createValueUnchecked(string2, Date.class);
    }

    public static Map<Class<?>, Converter<?, ? extends Throwable>> createDefaultMap() {
        return TypeHandler.putDefaultMap(new HashMap());
    }

    public static File createFile(String string2) {
        return TypeHandler.createValueUnchecked(string2, File.class);
    }

    @Deprecated
    public static File[] createFiles(String string2) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Deprecated
    public static Number createNumber(String string2) throws ParseException {
        return TypeHandler.createValue(string2, Number.class);
    }

    @Deprecated
    public static Object createObject(String className) throws ParseException {
        return TypeHandler.createValue(className, Object.class);
    }

    public static URL createURL(String string2) throws ParseException {
        return TypeHandler.createValue(string2, URL.class);
    }

    public static <T> T createValue(String string2, Class<T> clazz) throws ParseException {
        try {
            return TypeHandler.getDefault().getConverter(clazz).apply(string2);
        }
        catch (Exception e2) {
            throw ParseException.wrap(e2);
        }
    }

    @Deprecated
    public static Object createValue(String string2, Object obj) throws ParseException {
        return TypeHandler.createValue(string2, (Class)obj);
    }

    private static <T> T createValueUnchecked(String string2, Class<T> clazz) {
        try {
            return TypeHandler.createValue(string2, clazz);
        }
        catch (ParseException e2) {
            throw new IllegalArgumentException(e2);
        }
    }

    public static TypeHandler getDefault() {
        return DEFAULT;
    }

    @Deprecated
    public static FileInputStream openFile(String string2) throws ParseException {
        return TypeHandler.createValue(string2, FileInputStream.class);
    }

    private static Map<Class<?>, Converter<?, ? extends Throwable>> putDefaultMap(Map<Class<?>, Converter<?, ? extends Throwable>> map2) {
        map2.put(Object.class, Converter.OBJECT);
        map2.put(Class.class, Converter.CLASS);
        map2.put(Date.class, Converter.DATE);
        map2.put(File.class, Converter.FILE);
        map2.put(Path.class, Converter.PATH);
        map2.put(Number.class, Converter.NUMBER);
        map2.put(URL.class, Converter.URL);
        map2.put(FileInputStream.class, FileInputStream::new);
        map2.put(Long.class, Long::parseLong);
        map2.put(Integer.class, Integer::parseInt);
        map2.put(Short.class, Short::parseShort);
        map2.put(Byte.class, Byte::parseByte);
        map2.put(Character.class, s2 -> Character.valueOf(s2.startsWith("\\u") ? Character.toChars(Integer.parseInt(s2.substring(2), 16))[0] : s2.charAt(0)));
        map2.put(Double.class, Double::parseDouble);
        map2.put(Float.class, Float::parseFloat);
        map2.put(BigInteger.class, BigInteger::new);
        map2.put(BigDecimal.class, BigDecimal::new);
        return map2;
    }

    public TypeHandler() {
        this(TypeHandler.createDefaultMap());
    }

    public TypeHandler(Map<Class<?>, Converter<?, ? extends Throwable>> converterMap) {
        this.converterMap = Objects.requireNonNull(converterMap, "converterMap");
    }

    public <T> Converter<T, ?> getConverter(Class<T> clazz) {
        return this.converterMap.getOrDefault(clazz, Converter.DEFAULT);
    }
}

