/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli.help;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.help.AbstractHelpFormatter;
import org.apache.commons.cli.help.OptionFormatter;
import org.apache.commons.cli.help.TableDefinition;
import org.apache.commons.cli.help.TextStyle;

public class HelpFormatter
extends AbstractHelpFormatter {
    public static final int DEFAULT_WIDTH = 74;
    public static final int DEFAULT_LEFT_PAD = 1;
    public static final int DEFAULT_COLUMN_SPACING = 5;
    private final boolean showSince;

    public static Builder builder() {
        return new Builder();
    }

    protected HelpFormatter(Builder builder) {
        super(builder);
        this.showSince = builder.showSince;
    }

    @Override
    public TableDefinition getTableDefinition(Iterable<Option> options) {
        TextStyle.Builder builder = TextStyle.builder().setAlignment(TextStyle.Alignment.LEFT).setIndent(1).setScalable(false);
        ArrayList<TextStyle> styles = new ArrayList<TextStyle>();
        styles.add(builder.get());
        builder.setScalable(true).setLeftPad(5);
        if (this.showSince) {
            builder.setAlignment(TextStyle.Alignment.CENTER);
            styles.add(builder.get());
        }
        builder.setAlignment(TextStyle.Alignment.LEFT);
        styles.add(builder.get());
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        StringBuilder sb = new StringBuilder();
        for (Option option2 : options) {
            ArrayList<String> row = new ArrayList<String>();
            OptionFormatter formatter2 = this.getOptionFormatBuilder().build(option2);
            sb.setLength(0);
            sb.append(formatter2.getBothOpt());
            if (option2.hasArg()) {
                sb.append(" ").append(formatter2.getArgName());
            }
            row.add(sb.toString());
            if (this.showSince) {
                row.add(formatter2.getSince());
            }
            row.add(formatter2.getDescription());
            rows.add(row);
        }
        return TableDefinition.from("", styles, this.showSince ? Arrays.asList("Options", "Since", "Description") : Arrays.asList("Options", "Description"), rows);
    }

    public static class Builder
    extends AbstractHelpFormatter.Builder<Builder, HelpFormatter> {
        private boolean showSince = true;

        protected Builder() {
        }

        @Override
        public HelpFormatter get() {
            return new HelpFormatter(this);
        }

        public Builder setShowSince(boolean showSince) {
            this.showSince = showSince;
            return this;
        }
    }
}

