/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli.help;

import java.util.Arrays;

final class Util {
    private static final int NOT_FOUND = -1;

    static <T extends CharSequence> T defaultValue(T str, T defaultValue) {
        return Util.isEmpty(str) ? defaultValue : str;
    }

    static int indexOfNonWhitespace(CharSequence text, int startPos) {
        int idx;
        if (Util.isEmpty(text)) {
            return -1;
        }
        for (idx = startPos; idx < text.length() && Util.isWhitespace(text.charAt(idx)); ++idx) {
        }
        return idx < text.length() ? idx : -1;
    }

    static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    static boolean isWhitespace(char c2) {
        return Character.isWhitespace(c2) || '\u000e' == c2;
    }

    static String ltrim(String s2) {
        int pos = Util.indexOfNonWhitespace(s2, 0);
        return pos == -1 ? "" : s2.substring(pos);
    }

    static String repeat(int len, char fillChar) {
        char[] padding = new char[len];
        Arrays.fill(padding, fillChar);
        return new String(padding);
    }

    static String repeatSpace(int len) {
        return Util.repeat(len, ' ');
    }

    static String rtrim(String s2) {
        int pos;
        if (Util.isEmpty(s2)) {
            return s2;
        }
        for (pos = s2.length(); pos > 0 && Util.isWhitespace(s2.charAt(pos - 1)); --pos) {
        }
        return s2.substring(0, pos);
    }

    private Util() {
    }
}

