/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import org.apache.commons.io.FileUtils;

public final class IOUtils {
    public static final LinkOption[] EMPTY_LINK_OPTIONS = new LinkOption[0];

    @Deprecated
    public static void closeQuietly(Closeable c2) {
        org.apache.commons.io.IOUtils.closeQuietly(c2);
    }

    @Deprecated
    public static void copy(File sourceFile, OutputStream outputStream2) throws IOException {
        FileUtils.copyFile(sourceFile, outputStream2);
    }

    @Deprecated
    public static long copy(InputStream input2, OutputStream output2) throws IOException {
        return org.apache.commons.io.IOUtils.copy(input2, output2);
    }

    @Deprecated
    public static long copy(InputStream input2, OutputStream output2, int bufferSize) throws IOException {
        return org.apache.commons.io.IOUtils.copy(input2, output2, bufferSize);
    }

    @Deprecated
    public static long copyRange(InputStream input2, long len, OutputStream output2) throws IOException {
        return org.apache.commons.io.IOUtils.copyLarge(input2, output2, 0L, len);
    }

    @Deprecated
    public static long copyRange(InputStream input2, long length, OutputStream output2, int bufferSize) throws IOException {
        long count;
        if (bufferSize < 1) {
            throw new IllegalArgumentException("bufferSize must be bigger than 0");
        }
        byte[] buffer = new byte[(int)Math.min((long)bufferSize, Math.max(0L, length))];
        int n2 = 0;
        for (count = 0L; count < length && -1 != (n2 = input2.read(buffer, 0, (int)Math.min(length - count, (long)buffer.length))); count += (long)n2) {
            if (output2 == null) continue;
            output2.write(buffer, 0, n2);
        }
        return count;
    }

    @Deprecated
    public static int read(File file, byte[] array) throws IOException {
        try (InputStream inputStream2 = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            int n2 = IOUtils.readFully(inputStream2, array, 0, array.length);
            return n2;
        }
    }

    public static int readFully(InputStream input2, byte[] array) throws IOException {
        return IOUtils.readFully(input2, array, 0, array.length);
    }

    public static int readFully(InputStream input2, byte[] array, int offset, int length) throws IOException {
        if (length < 0 || offset < 0 || length + offset > array.length || length + offset < 0) {
            throw new IndexOutOfBoundsException();
        }
        return org.apache.commons.io.IOUtils.read(input2, array, offset, length);
    }

    public static void readFully(ReadableByteChannel channel, ByteBuffer byteBuffer) throws IOException {
        int expectedLength = byteBuffer.remaining();
        int read = org.apache.commons.io.IOUtils.read(channel, byteBuffer);
        if (read < expectedLength) {
            throw new EOFException();
        }
    }

    public static byte[] readRange(InputStream input2, int length) throws IOException {
        ByteArrayOutputStream output2 = new ByteArrayOutputStream();
        org.apache.commons.io.IOUtils.copyLarge(input2, output2, 0L, (long)length);
        return output2.toByteArray();
    }

    public static byte[] readRange(ReadableByteChannel input2, int length) throws IOException {
        int readCount;
        ByteArrayOutputStream output2 = new ByteArrayOutputStream();
        ByteBuffer b2 = ByteBuffer.allocate(Math.min(length, 8192));
        for (int read = 0; read < length; read += readCount) {
            b2.limit(Math.min(length - read, b2.capacity()));
            readCount = input2.read(b2);
            if (readCount <= 0) break;
            output2.write(b2.array(), 0, readCount);
            b2.rewind();
        }
        return output2.toByteArray();
    }

    public static long skip(InputStream input2, long toSkip) throws IOException {
        return org.apache.commons.io.IOUtils.skip(input2, toSkip, org.apache.commons.io.IOUtils::byteArray);
    }

    @Deprecated
    public static byte[] toByteArray(InputStream input2) throws IOException {
        return org.apache.commons.io.IOUtils.toByteArray(input2);
    }

    private IOUtils() {
    }
}

