/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging;

import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImagingOpException;
import java.io.File;
import java.io.IOException;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.Imaging;

public class ColorTools {
    public BufferedImage correctImage(BufferedImage src, File file) throws ImageReadException, IOException {
        ICC_Profile icc = Imaging.getICCProfile(file);
        if (icc == null) {
            return src;
        }
        ICC_ColorSpace cs2 = new ICC_ColorSpace(icc);
        return this.convertFromColorSpace(src, cs2);
    }

    public BufferedImage relabelColorSpace(BufferedImage bi2, ICC_Profile profile) throws ImagingOpException {
        ICC_ColorSpace cs2 = new ICC_ColorSpace(profile);
        return this.relabelColorSpace(bi2, cs2);
    }

    public BufferedImage relabelColorSpace(BufferedImage bi2, ColorSpace cs2) throws ImagingOpException {
        ColorModel cm2 = this.deriveColorModel(bi2, cs2);
        return this.relabelColorSpace(bi2, cm2);
    }

    public BufferedImage relabelColorSpace(BufferedImage bi2, ColorModel cm2) throws ImagingOpException {
        return new BufferedImage(cm2, bi2.getRaster(), false, null);
    }

    public ColorModel deriveColorModel(BufferedImage bi2, ColorSpace cs2) throws ImagingOpException {
        return this.deriveColorModel(bi2, cs2, false);
    }

    public ColorModel deriveColorModel(BufferedImage bi2, ColorSpace cs2, boolean forceNoAlpha) throws ImagingOpException {
        return this.deriveColorModel(bi2.getColorModel(), cs2, forceNoAlpha);
    }

    public ColorModel deriveColorModel(ColorModel colorModel, ColorSpace cs2, boolean forceNoAlpha) throws ImagingOpException {
        if (colorModel instanceof ComponentColorModel) {
            ComponentColorModel ccm = (ComponentColorModel)colorModel;
            if (forceNoAlpha) {
                return new ComponentColorModel(cs2, false, false, 1, ccm.getTransferType());
            }
            return new ComponentColorModel(cs2, ccm.hasAlpha(), ccm.isAlphaPremultiplied(), ccm.getTransparency(), ccm.getTransferType());
        }
        if (colorModel instanceof DirectColorModel) {
            DirectColorModel dcm = (DirectColorModel)colorModel;
            int oldMask = dcm.getRedMask() | dcm.getGreenMask() | dcm.getBlueMask() | dcm.getAlphaMask();
            int oldBits = this.countBitsInMask(oldMask);
            return new DirectColorModel(cs2, oldBits, dcm.getRedMask(), dcm.getGreenMask(), dcm.getBlueMask(), dcm.getAlphaMask(), dcm.isAlphaPremultiplied(), dcm.getTransferType());
        }
        throw new ImagingOpException("Could not clone unknown ColorModel Type.");
    }

    private int countBitsInMask(int i2) {
        int count = 0;
        while (i2 != 0) {
            count += i2 & 1;
            i2 >>>= 1;
        }
        return count;
    }

    public BufferedImage convertToColorSpace(BufferedImage bi2, ColorSpace to) {
        ColorSpace from = bi2.getColorModel().getColorSpace();
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        ColorConvertOp op = new ColorConvertOp(from, to, hints);
        BufferedImage result2 = op.filter(bi2, null);
        result2 = this.relabelColorSpace(result2, to);
        return result2;
    }

    public BufferedImage convertTosRGB(BufferedImage bi2) {
        ColorModel srgbCM = ColorModel.getRGBdefault();
        return this.convertToColorSpace(bi2, srgbCM.getColorSpace());
    }

    protected BufferedImage convertFromColorSpace(BufferedImage bi2, ColorSpace from) {
        ColorModel srgbCM = ColorModel.getRGBdefault();
        return this.convertBetweenColorSpaces(bi2, from, srgbCM.getColorSpace());
    }

    public BufferedImage convertBetweenICCProfiles(BufferedImage bi2, ICC_Profile from, ICC_Profile to) {
        ICC_ColorSpace csFrom = new ICC_ColorSpace(from);
        ICC_ColorSpace csTo = new ICC_ColorSpace(to);
        return this.convertBetweenColorSpaces(bi2, csFrom, csTo);
    }

    public BufferedImage convertToICCProfile(BufferedImage bi2, ICC_Profile to) {
        ICC_ColorSpace csTo = new ICC_ColorSpace(to);
        return this.convertToColorSpace(bi2, csTo);
    }

    public BufferedImage convertBetweenColorSpacesX2(BufferedImage bi2, ColorSpace from, ColorSpace to) {
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        bi2 = this.relabelColorSpace(bi2, from);
        ColorConvertOp op = new ColorConvertOp(from, to, hints);
        bi2 = op.filter(bi2, null);
        bi2 = this.relabelColorSpace(bi2, from);
        bi2 = op.filter(bi2, null);
        bi2 = this.relabelColorSpace(bi2, to);
        return bi2;
    }

    public BufferedImage convertBetweenColorSpaces(BufferedImage bi2, ColorSpace from, ColorSpace to) {
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        ColorConvertOp op = new ColorConvertOp(from, to, hints);
        bi2 = this.relabelColorSpace(bi2, from);
        BufferedImage result2 = op.filter(bi2, null);
        result2 = this.relabelColorSpace(result2, to);
        return result2;
    }
}

