/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.imaging.ImageReadException;

public class FormatCompliance {
    private final boolean failOnError;
    private final String description;
    private final List<String> comments = new ArrayList<String>();

    public FormatCompliance(String description) {
        this.description = description;
        this.failOnError = false;
    }

    public FormatCompliance(String description, boolean failOnError) {
        this.description = description;
        this.failOnError = failOnError;
    }

    public static FormatCompliance getDefault() {
        return new FormatCompliance("ignore", false);
    }

    public void addComment(String comment) throws ImageReadException {
        this.comments.add(comment);
        if (this.failOnError) {
            throw new ImageReadException(comment);
        }
    }

    public void addComment(String comment, int value) throws ImageReadException {
        this.addComment(comment + ": " + this.getValueDescription(value));
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.dump(pw);
        return sw.getBuffer().toString();
    }

    public void dump() {
        this.dump(new PrintWriter(new OutputStreamWriter((OutputStream)System.out, Charset.defaultCharset())));
    }

    public void dump(PrintWriter pw) {
        pw.println("Format Compliance: " + this.description);
        if (this.comments.isEmpty()) {
            pw.println("\tNo comments.");
        } else {
            for (int i2 = 0; i2 < this.comments.size(); ++i2) {
                pw.println("\t" + (i2 + 1) + ": " + this.comments.get(i2));
            }
        }
        pw.println("");
        pw.flush();
    }

    private String getValueDescription(int value) {
        return value + " (" + Integer.toHexString(value) + ")";
    }

    public boolean compareBytes(String name, byte[] expected, byte[] actual) throws ImageReadException {
        if (expected.length != actual.length) {
            this.addComment(name + ": Unexpected length: (expected: " + expected.length + ", actual: " + actual.length + ")");
            return false;
        }
        for (int i2 = 0; i2 < expected.length; ++i2) {
            if (expected[i2] == actual[i2]) continue;
            this.addComment(name + ": Unexpected value: (expected: " + this.getValueDescription(expected[i2]) + ", actual: " + this.getValueDescription(actual[i2]) + ")");
            return false;
        }
        return true;
    }

    public boolean checkBounds(String name, int min, int max, int actual) throws ImageReadException {
        if (actual < min || actual > max) {
            this.addComment(name + ": bounds check: " + min + " <= " + actual + " <= " + max + ": false");
            return false;
        }
        return true;
    }

    public boolean compare(String name, int valid, int actual) throws ImageReadException {
        return this.compare(name, new int[]{valid}, actual);
    }

    public boolean compare(String name, int[] valid, int actual) throws ImageReadException {
        for (int element : valid) {
            if (actual != element) continue;
            return true;
        }
        StringBuilder result2 = new StringBuilder(43);
        result2.append(name);
        result2.append(": Unexpected value: (valid: ");
        if (valid.length > 1) {
            result2.append('{');
        }
        for (int i2 = 0; i2 < valid.length; ++i2) {
            if (i2 > 0) {
                result2.append(", ");
            }
            result2.append(this.getValueDescription(valid[i2]));
        }
        if (valid.length > 1) {
            result2.append('}');
        }
        result2.append(", actual: " + this.getValueDescription(actual) + ")");
        this.addComment(result2.toString());
        return false;
    }
}

