/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import org.apache.commons.imaging.icc.IccProfileInfo;
import org.apache.commons.imaging.icc.IccProfileParser;

public class ImageDump {
    private String colorSpaceTypeToName(ColorSpace cs2) {
        switch (cs2.getType()) {
            case 9: {
                return "TYPE_CMYK";
            }
            case 5: {
                return "TYPE_RGB";
            }
            case 1000: {
                return "CS_sRGB";
            }
            case 1003: {
                return "CS_GRAY";
            }
            case 1001: {
                return "CS_CIEXYZ";
            }
            case 1004: {
                return "CS_LINEAR_RGB";
            }
            case 1002: {
                return "CS_PYCC";
            }
        }
        return "unknown";
    }

    public void dumpColorSpace(String prefix, ColorSpace cs2) {
        System.out.println(prefix + ": type: " + cs2.getType() + " (" + this.colorSpaceTypeToName(cs2) + ")");
        if (!(cs2 instanceof ICC_ColorSpace)) {
            System.out.println(prefix + ": Unknown ColorSpace: " + cs2.getClass().getName());
            return;
        }
        ICC_ColorSpace iccColorSpace = (ICC_ColorSpace)cs2;
        ICC_Profile iccProfile = iccColorSpace.getProfile();
        byte[] bytes = iccProfile.getData();
        IccProfileParser parser2 = new IccProfileParser();
        IccProfileInfo info = parser2.getICCProfileInfo(bytes);
        info.dump(prefix);
    }

    public void dump(BufferedImage src) {
        this.dump("", src);
    }

    public void dump(String prefix, BufferedImage src) {
        System.out.println(prefix + ": dump");
        this.dumpColorSpace(prefix, src.getColorModel().getColorSpace());
        this.dumpBIProps(prefix, src);
    }

    public void dumpBIProps(String prefix, BufferedImage src) {
        String[] keys = src.getPropertyNames();
        if (keys == null) {
            System.out.println(prefix + ": no props");
            return;
        }
        for (String key : keys) {
            System.out.println(prefix + ": " + key + ": " + src.getProperty(key));
        }
    }
}

