/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.color;

public final class ColorHsl {
    public static final ColorHsl BLACK = new ColorHsl(0.0, 0.0, 0.0);
    public static final ColorHsl WHITE = new ColorHsl(0.0, 0.0, 100.0);
    public static final ColorHsl RED = new ColorHsl(0.0, 100.0, 100.0);
    public static final ColorHsl GREEN = new ColorHsl(120.0, 100.0, 100.0);
    public static final ColorHsl BLUE = new ColorHsl(240.0, 100.0, 100.0);
    public final double H;
    public final double S;
    public final double L;

    public ColorHsl(double H7, double S2, double L2) {
        this.H = H7;
        this.S = S2;
        this.L = L2;
    }

    public String toString() {
        return "{H: " + this.H + ", S: " + this.S + ", L: " + this.L + "}";
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        ColorHsl colorHsl = (ColorHsl)o2;
        if (Double.compare(colorHsl.H, this.H) != 0) {
            return false;
        }
        if (Double.compare(colorHsl.L, this.L) != 0) {
            return false;
        }
        return Double.compare(colorHsl.S, this.S) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.H);
        int result2 = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.S);
        result2 = 31 * result2 + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.L);
        result2 = 31 * result2 + (int)(temp ^ temp >>> 32);
        return result2;
    }
}

