/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.color;

public final class ColorHsv {
    public static final ColorHsv BLACK = new ColorHsv(0.0, 0.0, 0.0);
    public static final ColorHsv WHITE = new ColorHsv(0.0, 0.0, 100.0);
    public static final ColorHsv RED = new ColorHsv(0.0, 100.0, 100.0);
    public static final ColorHsv GREEN = new ColorHsv(120.0, 100.0, 100.0);
    public static final ColorHsv BLUE = new ColorHsv(240.0, 100.0, 100.0);
    public final double H;
    public final double S;
    public final double V;

    public ColorHsv(double H7, double S2, double V2) {
        this.H = H7;
        this.S = S2;
        this.V = V2;
    }

    public String toString() {
        return "{H: " + this.H + ", S: " + this.S + ", V: " + this.V + "}";
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        ColorHsv colorHsv = (ColorHsv)o2;
        if (Double.compare(colorHsv.H, this.H) != 0) {
            return false;
        }
        if (Double.compare(colorHsv.S, this.S) != 0) {
            return false;
        }
        return Double.compare(colorHsv.V, this.V) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.H);
        int result2 = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.S);
        result2 = 31 * result2 + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.V);
        result2 = 31 * result2 + (int)(temp ^ temp >>> 32);
        return result2;
    }
}

