/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.common;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.common.FastByteArrayOutputStream;

public class PackBits {
    public byte[] decompress(byte[] bytes, int expected) throws ImageReadException {
        int total = 0;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int i2 = 0;
        while (total < expected) {
            byte n2;
            if (i2 >= bytes.length) {
                throw new ImageReadException("Tiff: Unpack bits source exhausted: " + i2 + ", done + " + total + ", expected + " + expected);
            }
            if ((n2 = bytes[i2++]) >= 0 && n2 <= 127) {
                int count = n2 + 1;
                total += count;
                for (int j2 = 0; j2 < count; ++j2) {
                    baos.write(bytes[i2++]);
                }
                continue;
            }
            if (n2 >= -127 && n2 <= -1) {
                byte b2 = bytes[i2++];
                int count = -n2 + 1;
                total += count;
                for (int j3 = 0; j3 < count; ++j3) {
                    baos.write(b2);
                }
                continue;
            }
            if (n2 != -128) continue;
            throw new ImageReadException("Packbits: " + n2);
        }
        return baos.toByteArray();
    }

    private int findNextDuplicate(byte[] bytes, int start) {
        if (start >= bytes.length) {
            return -1;
        }
        byte prev = bytes[start];
        for (int i2 = start + 1; i2 < bytes.length; ++i2) {
            byte b2 = bytes[i2];
            if (b2 == prev) {
                return i2 - 1;
            }
            prev = b2;
        }
        return -1;
    }

    private int findRunLength(byte[] bytes, int start) {
        int i2;
        byte b2 = bytes[start];
        for (i2 = start + 1; i2 < bytes.length && bytes[i2] == b2; ++i2) {
        }
        return i2 - start;
    }

    public byte[] compress(byte[] bytes) throws IOException {
        try (FastByteArrayOutputStream baos = new FastByteArrayOutputStream(bytes.length * 2);){
            byte[] result2;
            int ptr = 0;
            while (ptr < bytes.length) {
                int nextptr;
                int nextdup;
                int runlen;
                int actualLen;
                int len;
                int dup = this.findNextDuplicate(bytes, ptr);
                if (dup == ptr) {
                    len = this.findRunLength(bytes, dup);
                    actualLen = Math.min(len, 128);
                    baos.write(-(actualLen - 1));
                    baos.write(bytes[ptr]);
                    ptr += actualLen;
                    continue;
                }
                len = dup - ptr;
                if (dup > 0 && (runlen = this.findRunLength(bytes, dup)) < 3 && (nextdup = this.findNextDuplicate(bytes, nextptr = ptr + len + runlen)) != nextptr) {
                    dup = nextdup;
                    len = dup - ptr;
                }
                if (dup < 0) {
                    len = bytes.length - ptr;
                }
                actualLen = Math.min(len, 128);
                baos.write(actualLen - 1);
                for (int i2 = 0; i2 < actualLen; ++i2) {
                    baos.write(bytes[ptr]);
                    ++ptr;
                }
            }
            byte[] byArray = result2 = baos.toByteArray();
            return byArray;
        }
    }
}

