/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.formats.png.BitParser;
import org.apache.commons.imaging.formats.png.GammaCorrection;
import org.apache.commons.imaging.formats.png.PngColorType;
import org.apache.commons.imaging.formats.png.ScanExpediter;
import org.apache.commons.imaging.formats.png.chunks.PngChunkPlte;
import org.apache.commons.imaging.formats.png.transparencyfilters.TransparencyFilter;

class ScanExpediterInterlaced
extends ScanExpediter {
    private static final int[] STARTING_ROW = new int[]{0, 0, 4, 0, 2, 0, 1};
    private static final int[] STARTING_COL = new int[]{0, 4, 0, 2, 0, 1, 0};
    private static final int[] ROW_INCREMENT = new int[]{8, 8, 8, 4, 4, 2, 2};
    private static final int[] COL_INCREMENT = new int[]{8, 8, 4, 4, 2, 2, 1};

    ScanExpediterInterlaced(int width, int height, InputStream is, BufferedImage bi2, PngColorType pngColorType, int bitDepth, int bitsPerPixel, PngChunkPlte fPNGChunkPLTE, GammaCorrection gammaCorrection, TransparencyFilter transparencyFilter) {
        super(width, height, is, bi2, pngColorType, bitDepth, bitsPerPixel, fPNGChunkPLTE, gammaCorrection, transparencyFilter);
    }

    private void visit(int x2, int y2, BufferedImage bi2, BitParser fBitParser, int pixelIndexInScanline) throws ImageReadException, IOException {
        int rgb = this.getRGB(fBitParser, pixelIndexInScanline);
        bi2.setRGB(x2, y2, rgb);
    }

    @Override
    public void drive() throws ImageReadException, IOException {
        for (int pass = 1; pass <= 7; ++pass) {
            byte[] prev = null;
            for (int y2 = STARTING_ROW[pass - 1]; y2 < this.height; y2 += ROW_INCREMENT[pass - 1]) {
                byte[] unfiltered;
                int x2 = STARTING_COL[pass - 1];
                int pixelIndexInScanline = 0;
                if (x2 >= this.width) continue;
                int columnsInRow = 1 + (this.width - STARTING_COL[pass - 1] - 1) / COL_INCREMENT[pass - 1];
                int bitsPerScanLine = this.bitsPerPixel * columnsInRow;
                int pixelBytesPerScanLine = this.getBitsToBytesRoundingUp(bitsPerScanLine);
                prev = unfiltered = this.getNextScanline(this.is, pixelBytesPerScanLine, prev, this.bytesPerPixel);
                BitParser fBitParser = new BitParser(unfiltered, this.bitsPerPixel, this.bitDepth);
                while (x2 < this.width) {
                    this.visit(x2, y2, this.bi, fBitParser, pixelIndexInScanline);
                    x2 += COL_INCREMENT[pass - 1];
                    ++pixelIndexInScanline;
                }
            }
        }
    }
}

