/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.formats.png.BitParser;
import org.apache.commons.imaging.formats.png.GammaCorrection;
import org.apache.commons.imaging.formats.png.PngColorType;
import org.apache.commons.imaging.formats.png.ScanExpediter;
import org.apache.commons.imaging.formats.png.chunks.PngChunkPlte;
import org.apache.commons.imaging.formats.png.transparencyfilters.TransparencyFilter;

class ScanExpediterSimple
extends ScanExpediter {
    ScanExpediterSimple(int width, int height, InputStream is, BufferedImage bi2, PngColorType pngColorType, int bitDepth, int bitsPerPixel, PngChunkPlte pngChunkPLTE, GammaCorrection gammaCorrection, TransparencyFilter transparencyFilter) {
        super(width, height, is, bi2, pngColorType, bitDepth, bitsPerPixel, pngChunkPLTE, gammaCorrection, transparencyFilter);
    }

    @Override
    public void drive() throws ImageReadException, IOException {
        int bitsPerScanLine = this.bitsPerPixel * this.width;
        int pixelBytesPerScanLine = this.getBitsToBytesRoundingUp(bitsPerScanLine);
        byte[] prev = null;
        for (int y2 = 0; y2 < this.height; ++y2) {
            byte[] unfiltered;
            prev = unfiltered = this.getNextScanline(this.is, pixelBytesPerScanLine, prev, this.bytesPerPixel);
            BitParser bitParser = new BitParser(unfiltered, this.bitsPerPixel, this.bitDepth);
            for (int x2 = 0; x2 < this.width; ++x2) {
                int rgb = this.getRGB(bitParser, x2);
                this.bi.setRGB(x2, y2, rgb);
            }
        }
    }
}

