/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png.scanlinefilters;

import java.io.IOException;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.formats.png.scanlinefilters.ScanlineFilter;

public class ScanlineFilterAverage
implements ScanlineFilter {
    private final int bytesPerPixel;

    public ScanlineFilterAverage(int bytesPerPixel) {
        this.bytesPerPixel = bytesPerPixel;
    }

    @Override
    public void unfilter(byte[] src, byte[] dst, byte[] up) throws ImageReadException, IOException {
        for (int i2 = 0; i2 < src.length; ++i2) {
            byte raw = 0;
            int prevIndex = i2 - this.bytesPerPixel;
            if (prevIndex >= 0) {
                raw = dst[prevIndex];
            }
            byte prior = 0;
            if (up != null) {
                prior = up[i2];
            }
            int average = ((0xFF & raw) + (0xFF & prior)) / 2;
            dst[i2] = (byte)((src[i2] + average) % 256);
        }
    }
}

