/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png.scanlinefilters;

import java.io.IOException;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.formats.png.scanlinefilters.ScanlineFilter;

public class ScanlineFilterPaeth
implements ScanlineFilter {
    private final int bytesPerPixel;

    public ScanlineFilterPaeth(int bytesPerPixel) {
        this.bytesPerPixel = bytesPerPixel;
    }

    private int paethPredictor(int a2, int b2, int c2) {
        int p2 = a2 + b2 - c2;
        int pa = Math.abs(p2 - a2);
        int pb = Math.abs(p2 - b2);
        int pc = Math.abs(p2 - c2);
        if (pa <= pb && pa <= pc) {
            return a2;
        }
        if (pb <= pc) {
            return b2;
        }
        return c2;
    }

    @Override
    public void unfilter(byte[] src, byte[] dst, byte[] up) throws ImageReadException, IOException {
        for (int i2 = 0; i2 < src.length; ++i2) {
            byte left = 0;
            int prevIndex = i2 - this.bytesPerPixel;
            if (prevIndex >= 0) {
                left = dst[prevIndex];
            }
            byte above = 0;
            if (up != null) {
                above = up[i2];
            }
            byte upperleft = 0;
            if (prevIndex >= 0 && up != null) {
                upperleft = up[prevIndex];
            }
            int paethPredictor = this.paethPredictor(0xFF & left, 0xFF & above, 0xFF & upperleft);
            dst[i2] = (byte)((src[i2] + paethPredictor) % 256);
        }
    }
}

