/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.psd.dataparsers;

import org.apache.commons.imaging.formats.psd.PsdImageContents;
import org.apache.commons.imaging.formats.psd.dataparsers.DataParser;

public class DataParserIndexed
extends DataParser {
    private final int[] colorTable = new int[256];

    public DataParserIndexed(byte[] colorModeData) {
        for (int i2 = 0; i2 < 256; ++i2) {
            int rgb;
            int red = 0xFF & colorModeData[0 + i2];
            int green = 0xFF & colorModeData[256 + i2];
            int blue = 0xFF & colorModeData[512 + i2];
            int alpha = 255;
            this.colorTable[i2] = rgb = 0xFF000000 | (0xFF & red) << 16 | (0xFF & green) << 8 | (0xFF & blue) << 0;
        }
    }

    @Override
    protected int getRGB(int[][][] data, int x2, int y2, PsdImageContents imageContents) {
        int sample = 0xFF & data[0][y2][x2];
        return this.colorTable[sample];
    }

    @Override
    public int getBasicChannelsCount() {
        return 1;
    }
}

