/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.formats.tiff.TiffElement;
import org.apache.commons.imaging.formats.tiff.TiffTags;
import org.apache.commons.imaging.formats.tiff.constants.TiffTagConstants;
import org.apache.commons.imaging.formats.tiff.fieldtypes.FieldType;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;

public class TiffField {
    private final TagInfo tagInfo;
    private final int tag;
    private final int directoryType;
    private final FieldType fieldType;
    private final long count;
    private final long offset;
    private final byte[] value;
    private final ByteOrder byteOrder;
    private final int sortHint;

    public TiffField(int tag, int directoryType, FieldType fieldType, long count, long offset, byte[] value, ByteOrder byteOrder, int sortHint) {
        this.tag = tag;
        this.directoryType = directoryType;
        this.fieldType = fieldType;
        this.count = count;
        this.offset = offset;
        this.value = value;
        this.byteOrder = byteOrder;
        this.sortHint = sortHint;
        this.tagInfo = TiffTags.getTag(directoryType, tag);
    }

    public int getDirectoryType() {
        return this.directoryType;
    }

    public TagInfo getTagInfo() {
        return this.tagInfo;
    }

    public int getTag() {
        return this.tag;
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    public long getCount() {
        return this.count;
    }

    public int getOffset() {
        return (int)this.offset;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public int getSortHint() {
        return this.sortHint;
    }

    public boolean isLocalValue() {
        return this.count * (long)this.fieldType.getSize() <= 4L;
    }

    public int getBytesLength() {
        return (int)this.count * this.fieldType.getSize();
    }

    public byte[] getByteArrayValue() {
        return BinaryFunctions.head(this.value, this.getBytesLength());
    }

    public TiffElement getOversizeValueElement() {
        if (this.isLocalValue()) {
            return null;
        }
        return new OversizeValueElement(this.getOffset(), this.value.length);
    }

    public String getValueDescription() {
        try {
            return this.getValueDescription(this.getValue());
        }
        catch (ImageReadException e2) {
            return "Invalid value: " + e2.getMessage();
        }
    }

    private String getValueDescription(Object o2) {
        if (o2 == null) {
            return null;
        }
        if (o2 instanceof Number) {
            return o2.toString();
        }
        if (o2 instanceof String) {
            return "'" + o2.toString().trim() + "'";
        }
        if (o2 instanceof Date) {
            SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.ENGLISH);
            return df2.format((Date)o2);
        }
        if (o2 instanceof Object[]) {
            Object[] objects = (Object[])o2;
            StringBuilder result2 = new StringBuilder();
            for (int i2 = 0; i2 < objects.length; ++i2) {
                Object object = objects[i2];
                if (i2 > 50) {
                    result2.append("... (" + objects.length + ")");
                    break;
                }
                if (i2 > 0) {
                    result2.append(", ");
                }
                result2.append(object.toString());
            }
            return result2.toString();
        }
        if (o2 instanceof short[]) {
            short[] values = (short[])o2;
            StringBuilder result3 = new StringBuilder();
            for (int i3 = 0; i3 < values.length; ++i3) {
                short sval = values[i3];
                if (i3 > 50) {
                    result3.append("... (" + values.length + ")");
                    break;
                }
                if (i3 > 0) {
                    result3.append(", ");
                }
                result3.append(Short.toString(sval));
            }
            return result3.toString();
        }
        if (o2 instanceof int[]) {
            int[] values = (int[])o2;
            StringBuilder result4 = new StringBuilder();
            for (int i4 = 0; i4 < values.length; ++i4) {
                int iVal = values[i4];
                if (i4 > 50) {
                    result4.append("... (" + values.length + ")");
                    break;
                }
                if (i4 > 0) {
                    result4.append(", ");
                }
                result4.append(Integer.toString(iVal));
            }
            return result4.toString();
        }
        if (o2 instanceof long[]) {
            long[] values = (long[])o2;
            StringBuilder result5 = new StringBuilder();
            for (int i5 = 0; i5 < values.length; ++i5) {
                long lVal = values[i5];
                if (i5 > 50) {
                    result5.append("... (" + values.length + ")");
                    break;
                }
                if (i5 > 0) {
                    result5.append(", ");
                }
                result5.append(Long.toString(lVal));
            }
            return result5.toString();
        }
        if (o2 instanceof double[]) {
            double[] values = (double[])o2;
            StringBuilder result6 = new StringBuilder();
            for (int i6 = 0; i6 < values.length; ++i6) {
                double dVal = values[i6];
                if (i6 > 50) {
                    result6.append("... (" + values.length + ")");
                    break;
                }
                if (i6 > 0) {
                    result6.append(", ");
                }
                result6.append(Double.toString(dVal));
            }
            return result6.toString();
        }
        if (o2 instanceof byte[]) {
            byte[] values = (byte[])o2;
            StringBuilder result7 = new StringBuilder();
            for (int i7 = 0; i7 < values.length; ++i7) {
                byte bVal = values[i7];
                if (i7 > 50) {
                    result7.append("... (" + values.length + ")");
                    break;
                }
                if (i7 > 0) {
                    result7.append(", ");
                }
                result7.append(Byte.toString(bVal));
            }
            return result7.toString();
        }
        if (o2 instanceof char[]) {
            char[] values = (char[])o2;
            StringBuilder result8 = new StringBuilder();
            for (int i8 = 0; i8 < values.length; ++i8) {
                char cVal = values[i8];
                if (i8 > 50) {
                    result8.append("... (" + values.length + ")");
                    break;
                }
                if (i8 > 0) {
                    result8.append(", ");
                }
                result8.append(Character.toString(cVal));
            }
            return result8.toString();
        }
        if (o2 instanceof float[]) {
            float[] values = (float[])o2;
            StringBuilder result9 = new StringBuilder();
            for (int i9 = 0; i9 < values.length; ++i9) {
                float fVal = values[i9];
                if (i9 > 50) {
                    result9.append("... (" + values.length + ")");
                    break;
                }
                if (i9 > 0) {
                    result9.append(", ");
                }
                result9.append(Float.toString(fVal));
            }
            return result9.toString();
        }
        return "Unknown: " + o2.getClass().getName();
    }

    public void dump() {
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, Charset.defaultCharset()));
        this.dump(pw);
        pw.flush();
    }

    public void dump(PrintWriter pw) {
        this.dump(pw, null);
    }

    public void dump(PrintWriter pw, String prefix) {
        if (prefix != null) {
            pw.print(prefix + ": ");
        }
        pw.println(this.toString());
        pw.flush();
    }

    public String getDescriptionWithoutValue() {
        return this.getTag() + " (0x" + Integer.toHexString(this.getTag()) + ": " + this.getTagInfo().name + "): ";
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder();
        result2.append(this.getTag() + " (0x" + Integer.toHexString(this.getTag()) + ": " + this.getTagInfo().name + "): ");
        result2.append(this.getValueDescription() + " (" + this.getCount() + " " + this.getFieldType().getName() + ")");
        return result2.toString();
    }

    public String getTagName() {
        if (this.getTagInfo() == TiffTagConstants.TIFF_TAG_UNKNOWN) {
            return this.getTagInfo().name + " (0x" + Integer.toHexString(this.getTag()) + ")";
        }
        return this.getTagInfo().name;
    }

    public String getFieldTypeName() {
        return this.getFieldType().getName();
    }

    public Object getValue() throws ImageReadException {
        return this.getTagInfo().getValue(this);
    }

    public String getStringValue() throws ImageReadException {
        Object o2 = this.getValue();
        if (o2 == null) {
            return null;
        }
        if (!(o2 instanceof String)) {
            throw new ImageReadException("Expected String value(" + this.getTagInfo().getDescription() + "): " + o2);
        }
        return (String)o2;
    }

    public int[] getIntArrayValue() throws ImageReadException {
        Object o2 = this.getValue();
        if (o2 instanceof Number) {
            return new int[]{((Number)o2).intValue()};
        }
        if (o2 instanceof Number[]) {
            Number[] numbers = (Number[])o2;
            int[] result2 = new int[numbers.length];
            for (int i2 = 0; i2 < numbers.length; ++i2) {
                result2[i2] = numbers[i2].intValue();
            }
            return result2;
        }
        if (o2 instanceof short[]) {
            short[] numbers = (short[])o2;
            int[] result3 = new int[numbers.length];
            for (int i3 = 0; i3 < numbers.length; ++i3) {
                result3[i3] = 0xFFFF & numbers[i3];
            }
            return result3;
        }
        if (o2 instanceof int[]) {
            int[] numbers = (int[])o2;
            int[] result4 = new int[numbers.length];
            System.arraycopy(numbers, 0, result4, 0, numbers.length);
            return result4;
        }
        throw new ImageReadException("Unknown value: " + o2 + " for: " + this.getTagInfo().getDescription());
    }

    public double[] getDoubleArrayValue() throws ImageReadException {
        Object o2 = this.getValue();
        if (o2 instanceof Number) {
            return new double[]{((Number)o2).doubleValue()};
        }
        if (o2 instanceof Number[]) {
            Number[] numbers = (Number[])o2;
            double[] result2 = new double[numbers.length];
            for (int i2 = 0; i2 < numbers.length; ++i2) {
                result2[i2] = numbers[i2].doubleValue();
            }
            return result2;
        }
        if (o2 instanceof short[]) {
            short[] numbers = (short[])o2;
            double[] result3 = new double[numbers.length];
            for (int i3 = 0; i3 < numbers.length; ++i3) {
                result3[i3] = numbers[i3];
            }
            return result3;
        }
        if (o2 instanceof int[]) {
            int[] numbers = (int[])o2;
            double[] result4 = new double[numbers.length];
            for (int i4 = 0; i4 < numbers.length; ++i4) {
                result4[i4] = numbers[i4];
            }
            return result4;
        }
        if (o2 instanceof float[]) {
            float[] numbers = (float[])o2;
            double[] result5 = new double[numbers.length];
            for (int i5 = 0; i5 < numbers.length; ++i5) {
                result5[i5] = numbers[i5];
            }
            return result5;
        }
        if (o2 instanceof double[]) {
            double[] numbers = (double[])o2;
            double[] result6 = new double[numbers.length];
            System.arraycopy(numbers, 0, result6, 0, numbers.length);
            return result6;
        }
        throw new ImageReadException("Unknown value: " + o2 + " for: " + this.getTagInfo().getDescription());
    }

    public int getIntValueOrArraySum() throws ImageReadException {
        Object o2 = this.getValue();
        if (o2 instanceof Number) {
            return ((Number)o2).intValue();
        }
        if (o2 instanceof Number[]) {
            Number[] numbers = (Number[])o2;
            int sum2 = 0;
            for (Number number : numbers) {
                sum2 += number.intValue();
            }
            return sum2;
        }
        if (o2 instanceof short[]) {
            short[] numbers = (short[])o2;
            int sum3 = 0;
            for (short number : numbers) {
                sum3 += number;
            }
            return sum3;
        }
        if (o2 instanceof int[]) {
            int[] numbers = (int[])o2;
            int sum4 = 0;
            for (int number : numbers) {
                sum4 += number;
            }
            return sum4;
        }
        throw new ImageReadException("Unknown value: " + o2 + " for: " + this.getTagInfo().getDescription());
    }

    public int getIntValue() throws ImageReadException {
        Object o2 = this.getValue();
        if (o2 == null) {
            throw new ImageReadException("Missing value: " + this.getTagInfo().getDescription());
        }
        return ((Number)o2).intValue();
    }

    public double getDoubleValue() throws ImageReadException {
        Object o2 = this.getValue();
        if (o2 == null) {
            throw new ImageReadException("Missing value: " + this.getTagInfo().getDescription());
        }
        return ((Number)o2).doubleValue();
    }

    public final class OversizeValueElement
    extends TiffElement {
        public OversizeValueElement(int offset, int length) {
            super(offset, length);
        }

        @Override
        public String getElementDescription(boolean verbose) {
            if (verbose) {
                return null;
            }
            return "OversizeValueElement, tag: " + TiffField.this.getTagInfo().name + ", fieldType: " + TiffField.this.getFieldType().getName();
        }
    }
}

