/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.datareaders;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.common.ImageBuilder;
import org.apache.commons.imaging.formats.tiff.TiffDirectory;
import org.apache.commons.imaging.formats.tiff.TiffImageData;
import org.apache.commons.imaging.formats.tiff.datareaders.BitInputStream;
import org.apache.commons.imaging.formats.tiff.datareaders.ImageDataReader;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.PhotometricInterpreter;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.PhotometricInterpreterRgb;

public final class DataReaderStrips
extends ImageDataReader {
    private final int bitsPerPixel;
    private final int compression;
    private final int rowsPerStrip;
    private final ByteOrder byteOrder;
    private int x;
    private int y;
    private final TiffImageData.Strips imageData;

    public DataReaderStrips(TiffDirectory directory, PhotometricInterpreter photometricInterpreter, int bitsPerPixel, int[] bitsPerSample, int predictor, int samplesPerPixel, int width, int height, int compression, ByteOrder byteOrder, int rowsPerStrip, TiffImageData.Strips imageData) {
        super(directory, photometricInterpreter, bitsPerSample, predictor, samplesPerPixel, width, height);
        this.bitsPerPixel = bitsPerPixel;
        this.compression = compression;
        this.rowsPerStrip = rowsPerStrip;
        this.imageData = imageData;
        this.byteOrder = byteOrder;
    }

    private void interpretStrip(ImageBuilder imageBuilder, byte[] bytes, int pixelsPerStrip, int yLimit) throws ImageReadException, IOException {
        if (this.y >= yLimit) {
            return;
        }
        boolean allSamplesAreOneByte = this.isHomogenous(8);
        if (this.predictor != 2 && this.bitsPerPixel == 8 && allSamplesAreOneByte) {
            int k2 = 0;
            int nRows = pixelsPerStrip / this.width;
            if (this.y + nRows > yLimit) {
                nRows = yLimit - this.y;
            }
            int i0 = this.y;
            int i1 = this.y + nRows;
            this.x = 0;
            this.y += nRows;
            int[] samples = new int[1];
            for (int i2 = i0; i2 < i1; ++i2) {
                for (int j2 = 0; j2 < this.width; ++j2) {
                    samples[0] = bytes[k2++] & 0xFF;
                    this.photometricInterpreter.interpretPixel(imageBuilder, samples, j2, i2);
                }
            }
            return;
        }
        if (this.predictor != 2 && this.bitsPerPixel == 24 && allSamplesAreOneByte) {
            int k3 = 0;
            int nRows = pixelsPerStrip / this.width;
            if (this.y + nRows > yLimit) {
                nRows = yLimit - this.y;
            }
            int i0 = this.y;
            int i1 = this.y + nRows;
            this.x = 0;
            this.y += nRows;
            if (this.photometricInterpreter instanceof PhotometricInterpreterRgb) {
                for (int i3 = i0; i3 < i1; ++i3) {
                    int j3 = 0;
                    while (j3 < this.width) {
                        int rgb = 0xFF000000 | (bytes[k3] << 8 | bytes[k3 + 1] & 0xFF) << 8 | bytes[k3 + 2] & 0xFF;
                        imageBuilder.setRGB(j3, i3, rgb);
                        ++j3;
                        k3 += 3;
                    }
                }
            } else {
                int[] samples = new int[3];
                for (int i4 = i0; i4 < i1; ++i4) {
                    for (int j4 = 0; j4 < this.width; ++j4) {
                        samples[0] = bytes[k3++] & 0xFF;
                        samples[1] = bytes[k3++] & 0xFF;
                        samples[2] = bytes[k3++] & 0xFF;
                        this.photometricInterpreter.interpretPixel(imageBuilder, samples, j4, i4);
                    }
                }
            }
            return;
        }
        try (BitInputStream bis = new BitInputStream(new ByteArrayInputStream(bytes), this.byteOrder);){
            int[] samples = new int[this.bitsPerSampleLength];
            this.resetPredictor();
            for (int i5 = 0; i5 < pixelsPerStrip; ++i5) {
                this.getSamplesAsBytes(bis, samples);
                if (this.x < this.width) {
                    samples = this.applyPredictor(samples);
                    this.photometricInterpreter.interpretPixel(imageBuilder, samples, this.x, this.y);
                }
                ++this.x;
                if (this.x < this.width) continue;
                this.x = 0;
                this.resetPredictor();
                ++this.y;
                bis.flushCache();
                if (this.y < yLimit) continue;
                break;
            }
        }
    }

    @Override
    public void readImageData(ImageBuilder imageBuilder) throws ImageReadException, IOException {
        for (int strip = 0; strip < this.imageData.getImageDataLength(); ++strip) {
            long rowsPerStripLong = 0xFFFFFFFFL & (long)this.rowsPerStrip;
            long rowsRemaining = (long)this.height - (long)strip * rowsPerStripLong;
            long rowsInThisStrip = Math.min(rowsRemaining, rowsPerStripLong);
            long bytesPerRow = (this.bitsPerPixel * this.width + 7) / 8;
            long bytesPerStrip = rowsInThisStrip * bytesPerRow;
            long pixelsPerStrip = rowsInThisStrip * (long)this.width;
            byte[] compressed = this.imageData.getImageData(strip).getData();
            byte[] decompressed = this.decompress(compressed, this.compression, (int)bytesPerStrip, this.width, (int)rowsInThisStrip);
            this.interpretStrip(imageBuilder, decompressed, (int)pixelsPerStrip, this.height);
        }
    }

    @Override
    public BufferedImage readImageData(Rectangle subImage) throws ImageReadException, IOException {
        int strip0 = subImage.y / this.rowsPerStrip;
        int strip1 = (subImage.y + subImage.height - 1) / this.rowsPerStrip;
        int workingHeight = (strip1 - strip0 + 1) * this.rowsPerStrip;
        int y0 = strip0 * this.rowsPerStrip;
        int yLimit = subImage.y - y0 + subImage.height;
        ImageBuilder workingBuilder = new ImageBuilder(this.width, workingHeight, false);
        for (int strip = strip0; strip <= strip1; ++strip) {
            long rowsPerStripLong = 0xFFFFFFFFL & (long)this.rowsPerStrip;
            long rowsRemaining = (long)this.height - (long)strip * rowsPerStripLong;
            long rowsInThisStrip = Math.min(rowsRemaining, rowsPerStripLong);
            long bytesPerRow = (this.bitsPerPixel * this.width + 7) / 8;
            long bytesPerStrip = rowsInThisStrip * bytesPerRow;
            long pixelsPerStrip = rowsInThisStrip * (long)this.width;
            byte[] compressed = this.imageData.getImageData(strip).getData();
            byte[] decompressed = this.decompress(compressed, this.compression, (int)bytesPerStrip, this.width, (int)rowsInThisStrip);
            this.interpretStrip(workingBuilder, decompressed, (int)pixelsPerStrip, yLimit);
        }
        if (subImage.x == 0 && subImage.y == y0 && subImage.width == this.width && subImage.height == workingHeight) {
            return workingBuilder.getBufferedImage();
        }
        return workingBuilder.getSubimage(subImage.x, subImage.y - y0, subImage.width, subImage.height);
    }
}

