/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.datareaders;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.common.ImageBuilder;
import org.apache.commons.imaging.formats.tiff.TiffDirectory;
import org.apache.commons.imaging.formats.tiff.TiffElement;
import org.apache.commons.imaging.formats.tiff.TiffImageData;
import org.apache.commons.imaging.formats.tiff.datareaders.BitInputStream;
import org.apache.commons.imaging.formats.tiff.datareaders.ImageDataReader;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.PhotometricInterpreter;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.PhotometricInterpreterRgb;

public final class DataReaderTiled
extends ImageDataReader {
    private final int tileWidth;
    private final int tileLength;
    private final int bitsPerPixel;
    private final int compression;
    private final ByteOrder byteOrder;
    private final TiffImageData.Tiles imageData;

    public DataReaderTiled(TiffDirectory directory, PhotometricInterpreter photometricInterpreter, int tileWidth, int tileLength, int bitsPerPixel, int[] bitsPerSample, int predictor, int samplesPerPixel, int width, int height, int compression, ByteOrder byteOrder, TiffImageData.Tiles imageData) {
        super(directory, photometricInterpreter, bitsPerSample, predictor, samplesPerPixel, width, height);
        this.tileWidth = tileWidth;
        this.tileLength = tileLength;
        this.bitsPerPixel = bitsPerPixel;
        this.compression = compression;
        this.imageData = imageData;
        this.byteOrder = byteOrder;
    }

    private void interpretTile(ImageBuilder imageBuilder, byte[] bytes, int startX, int startY, int xLimit, int yLimit) throws ImageReadException, IOException {
        boolean allSamplesAreOneByte = this.isHomogenous(8);
        if (this.predictor != 2 && this.bitsPerPixel == 24 && allSamplesAreOneByte) {
            int k2 = 0;
            int i0 = startY;
            int i1 = startY + this.tileLength;
            if (i1 > yLimit) {
                i1 = yLimit;
            }
            int j0 = startX;
            int j1 = startX + this.tileWidth;
            if (j1 > xLimit) {
                j1 = xLimit;
            }
            if (this.photometricInterpreter instanceof PhotometricInterpreterRgb) {
                for (int i2 = i0; i2 < i1; ++i2) {
                    k2 = (i2 - i0) * this.tileWidth * 3;
                    int j2 = j0;
                    while (j2 < j1) {
                        int rgb = 0xFF000000 | (bytes[k2] << 8 | bytes[k2 + 1] & 0xFF) << 8 | bytes[k2 + 2] & 0xFF;
                        imageBuilder.setRGB(j2, i2, rgb);
                        ++j2;
                        k2 += 3;
                    }
                }
            } else {
                int[] samples = new int[3];
                for (int i3 = i0; i3 < i1; ++i3) {
                    k2 = (i3 - i0) * this.tileWidth * 3;
                    for (int j3 = j0; j3 < j1; ++j3) {
                        samples[0] = bytes[k2++] & 0xFF;
                        samples[1] = bytes[k2++] & 0xFF;
                        samples[2] = bytes[k2++] & 0xFF;
                        this.photometricInterpreter.interpretPixel(imageBuilder, samples, j3, i3);
                    }
                }
            }
            return;
        }
        try (BitInputStream bis = new BitInputStream(new ByteArrayInputStream(bytes), this.byteOrder);){
            int pixelsPerTile = this.tileWidth * this.tileLength;
            int tileX = 0;
            int tileY = 0;
            int[] samples = new int[this.bitsPerSampleLength];
            this.resetPredictor();
            for (int i4 = 0; i4 < pixelsPerTile; ++i4) {
                int x2 = tileX + startX;
                int y2 = tileY + startY;
                this.getSamplesAsBytes(bis, samples);
                if (x2 < xLimit && y2 < yLimit) {
                    samples = this.applyPredictor(samples);
                    this.photometricInterpreter.interpretPixel(imageBuilder, samples, x2, y2);
                }
                if (++tileX < this.tileWidth) continue;
                tileX = 0;
                this.resetPredictor();
                bis.flushCache();
                if (++tileY < this.tileLength) continue;
                break;
            }
        }
    }

    @Override
    public void readImageData(ImageBuilder imageBuilder) throws ImageReadException, IOException {
        int bitsPerRow = this.tileWidth * this.bitsPerPixel;
        int bytesPerRow = (bitsPerRow + 7) / 8;
        int bytesPerTile = bytesPerRow * this.tileLength;
        int x2 = 0;
        int y2 = 0;
        for (TiffElement.DataElement tile2 : this.imageData.tiles) {
            byte[] compressed = tile2.getData();
            byte[] decompressed = this.decompress(compressed, this.compression, bytesPerTile, this.tileWidth, this.tileLength);
            this.interpretTile(imageBuilder, decompressed, x2, y2, this.width, this.height);
            if ((x2 += this.tileWidth) < this.width) continue;
            x2 = 0;
            if ((y2 += this.tileLength) >= this.height) break;
        }
    }

    @Override
    public BufferedImage readImageData(Rectangle subImage) throws ImageReadException, IOException {
        int bitsPerRow = this.tileWidth * this.bitsPerPixel;
        int bytesPerRow = (bitsPerRow + 7) / 8;
        int bytesPerTile = bytesPerRow * this.tileLength;
        int x2 = 0;
        int y2 = 0;
        int col0 = subImage.x / this.tileWidth;
        int col1 = (subImage.x + subImage.width - 1) / this.tileWidth;
        int row0 = subImage.y / this.tileLength;
        int row1 = (subImage.y + subImage.height - 1) / this.tileLength;
        int nCol = col1 - col0 + 1;
        int nRow = row1 - row0 + 1;
        int workingWidth = nCol * this.tileWidth;
        int workingHeight = nRow * this.tileLength;
        int nColumnsOfTiles = (this.width + this.tileWidth - 1) / this.tileWidth;
        int x0 = col0 * this.tileWidth;
        int y0 = row0 * this.tileLength;
        ImageBuilder workingBuilder = new ImageBuilder(workingWidth, workingHeight, false);
        for (int iRow = row0; iRow <= row1; ++iRow) {
            for (int iCol = col0; iCol <= col1; ++iCol) {
                int tile = iRow * nColumnsOfTiles + iCol;
                byte[] compressed = this.imageData.tiles[tile].getData();
                byte[] decompressed = this.decompress(compressed, this.compression, bytesPerTile, this.tileWidth, this.tileLength);
                x2 = iCol * this.tileWidth - x0;
                y2 = iRow * this.tileLength - y0;
                this.interpretTile(workingBuilder, decompressed, x2, y2, workingWidth, workingHeight);
            }
        }
        if (subImage.x == x0 && subImage.y == y0 && subImage.width == workingWidth && subImage.height == workingHeight) {
            return workingBuilder.getBufferedImage();
        }
        return workingBuilder.getSubimage(subImage.x - x0, subImage.y - y0, subImage.width, subImage.height);
    }
}

