/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.datareaders;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.common.ImageBuilder;
import org.apache.commons.imaging.common.PackBits;
import org.apache.commons.imaging.common.itu_t4.T4AndT6Compression;
import org.apache.commons.imaging.common.mylzw.MyLzwDecompressor;
import org.apache.commons.imaging.formats.tiff.TiffDirectory;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.constants.TiffTagConstants;
import org.apache.commons.imaging.formats.tiff.datareaders.BitInputStream;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.PhotometricInterpreter;

public abstract class ImageDataReader {
    protected final TiffDirectory directory;
    protected final PhotometricInterpreter photometricInterpreter;
    private final int[] bitsPerSample;
    protected final int bitsPerSampleLength;
    private final int[] last;
    protected final int predictor;
    protected final int samplesPerPixel;
    protected final int width;
    protected final int height;

    public ImageDataReader(TiffDirectory directory, PhotometricInterpreter photometricInterpreter, int[] bitsPerSample, int predictor, int samplesPerPixel, int width, int height) {
        this.directory = directory;
        this.photometricInterpreter = photometricInterpreter;
        this.bitsPerSample = bitsPerSample;
        this.bitsPerSampleLength = bitsPerSample.length;
        this.samplesPerPixel = samplesPerPixel;
        this.predictor = predictor;
        this.width = width;
        this.height = height;
        this.last = new int[samplesPerPixel];
    }

    public abstract void readImageData(ImageBuilder var1) throws ImageReadException, IOException;

    public abstract BufferedImage readImageData(Rectangle var1) throws ImageReadException, IOException;

    protected boolean isHomogenous(int size) {
        for (int element : this.bitsPerSample) {
            if (element == size) continue;
            return false;
        }
        return true;
    }

    void getSamplesAsBytes(BitInputStream bis, int[] result2) throws IOException {
        for (int i2 = 0; i2 < this.bitsPerSample.length; ++i2) {
            int bits = this.bitsPerSample[i2];
            int sample = bis.readBits(bits);
            if (bits < 8) {
                int sign2 = sample & 1;
                sample <<= 8 - bits;
                if (sign2 > 0) {
                    sample |= (1 << 8 - bits) - 1;
                }
            } else if (bits > 8) {
                sample >>= bits - 8;
            }
            result2[i2] = sample;
        }
    }

    protected void resetPredictor() {
        Arrays.fill(this.last, 0);
    }

    protected int[] applyPredictor(int[] samples) {
        if (this.predictor == 2) {
            for (int i2 = 0; i2 < samples.length; ++i2) {
                samples[i2] = 0xFF & samples[i2] + this.last[i2];
                this.last[i2] = samples[i2];
            }
        }
        return samples;
    }

    protected byte[] decompress(byte[] compressedInput, int compression, int expectedSize, int tileWidth, int tileHeight) throws ImageReadException, IOException {
        byte[] compressedOrdered;
        TiffField fillOrderField = this.directory.findField(TiffTagConstants.TIFF_TAG_FILL_ORDER);
        int fillOrder = 1;
        if (fillOrderField != null) {
            fillOrder = fillOrderField.getIntValue();
        }
        if (fillOrder == 1) {
            compressedOrdered = compressedInput;
        } else if (fillOrder == 2) {
            compressedOrdered = new byte[compressedInput.length];
            for (int i2 = 0; i2 < compressedInput.length; ++i2) {
                compressedOrdered[i2] = (byte)(Integer.reverse(0xFF & compressedInput[i2]) >>> 24);
            }
        } else {
            throw new ImageReadException("TIFF FillOrder=" + fillOrder + " is invalid");
        }
        switch (compression) {
            case 1: {
                return compressedOrdered;
            }
            case 2: {
                return T4AndT6Compression.decompressModifiedHuffman(compressedOrdered, tileWidth, tileHeight);
            }
            case 3: {
                boolean hasFillBitsBeforeEOL;
                boolean usesUncompressedMode;
                int t4Options = 0;
                TiffField field = this.directory.findField(TiffTagConstants.TIFF_TAG_T4_OPTIONS);
                if (field != null) {
                    t4Options = field.getIntValue();
                }
                boolean is2D = (t4Options & 1) != 0;
                boolean bl2 = usesUncompressedMode = (t4Options & 2) != 0;
                if (usesUncompressedMode) {
                    throw new ImageReadException("T.4 compression with the uncompressed mode extension is not yet supported");
                }
                boolean bl3 = hasFillBitsBeforeEOL = (t4Options & 4) != 0;
                if (is2D) {
                    return T4AndT6Compression.decompressT4_2D(compressedOrdered, tileWidth, tileHeight, hasFillBitsBeforeEOL);
                }
                return T4AndT6Compression.decompressT4_1D(compressedOrdered, tileWidth, tileHeight, hasFillBitsBeforeEOL);
            }
            case 4: {
                boolean usesUncompressedMode;
                int t6Options = 0;
                TiffField field = this.directory.findField(TiffTagConstants.TIFF_TAG_T6_OPTIONS);
                if (field != null) {
                    t6Options = field.getIntValue();
                }
                boolean bl4 = usesUncompressedMode = (t6Options & 2) != 0;
                if (usesUncompressedMode) {
                    throw new ImageReadException("T.6 compression with the uncompressed mode extension is not yet supported");
                }
                return T4AndT6Compression.decompressT6(compressedOrdered, tileWidth, tileHeight);
            }
            case 5: {
                ByteArrayInputStream is = new ByteArrayInputStream(compressedOrdered);
                int lzwMinimumCodeSize = 8;
                MyLzwDecompressor myLzwDecompressor = new MyLzwDecompressor(8, ByteOrder.BIG_ENDIAN);
                myLzwDecompressor.setTiffLZWMode();
                return myLzwDecompressor.decompress(is, expectedSize);
            }
            case 32773: {
                return new PackBits().decompress(compressedOrdered, expectedSize);
            }
        }
        throw new ImageReadException("Tiff: unknown/unsupported compression: " + compression);
    }
}

