/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.fieldtypes;

import java.nio.ByteOrder;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.common.ByteConversions;
import org.apache.commons.imaging.common.RationalNumber;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.fieldtypes.FieldType;

public class FieldTypeRational
extends FieldType {
    public FieldTypeRational(int type, String name) {
        super(type, name, 8);
    }

    @Override
    public Object getValue(TiffField entry) {
        byte[] bytes = entry.getByteArrayValue();
        if (entry.getCount() == 1L) {
            return ByteConversions.toRational(bytes, entry.getByteOrder());
        }
        return ByteConversions.toRationals(bytes, entry.getByteOrder());
    }

    @Override
    public byte[] writeData(Object o2, ByteOrder byteOrder) throws ImageWriteException {
        if (o2 instanceof RationalNumber) {
            return ByteConversions.toBytes((RationalNumber)o2, byteOrder);
        }
        if (o2 instanceof RationalNumber[]) {
            return ByteConversions.toBytes((RationalNumber[])o2, byteOrder);
        }
        if (o2 instanceof Number) {
            Number number = (Number)o2;
            RationalNumber rationalNumber = RationalNumber.valueOf(number.doubleValue());
            return ByteConversions.toBytes(rationalNumber, byteOrder);
        }
        if (o2 instanceof Number[]) {
            Number[] numbers = (Number[])o2;
            RationalNumber[] rationalNumbers = new RationalNumber[numbers.length];
            for (int i2 = 0; i2 < numbers.length; ++i2) {
                Number number = numbers[i2];
                rationalNumbers[i2] = RationalNumber.valueOf(number.doubleValue());
            }
            return ByteConversions.toBytes(rationalNumbers, byteOrder);
        }
        if (o2 instanceof double[]) {
            double[] numbers = (double[])o2;
            RationalNumber[] rationalNumbers = new RationalNumber[numbers.length];
            for (int i3 = 0; i3 < numbers.length; ++i3) {
                double number = numbers[i3];
                rationalNumbers[i3] = RationalNumber.valueOf(number);
            }
            return ByteConversions.toBytes(rationalNumbers, byteOrder);
        }
        throw new ImageWriteException("Invalid data", o2);
    }
}

