/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.taginfos;

import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.formats.tiff.constants.TiffDirectoryType;
import org.apache.commons.imaging.formats.tiff.fieldtypes.FieldType;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;

public class TagInfoAscii
extends TagInfo {
    public TagInfoAscii(String name, int tag, int length, TiffDirectoryType directoryType) {
        super(name, tag, FieldType.ASCII, length, directoryType);
    }

    public String[] getValue(ByteOrder byteOrder, byte[] bytes) {
        int nullCount = 0;
        for (int i2 = 0; i2 < bytes.length - 1; ++i2) {
            if (bytes[i2] != 0) continue;
            ++nullCount;
        }
        String[] strings = new String[nullCount + 1];
        int stringsAdded = 0;
        strings[0] = "";
        int nextStringPos = 0;
        for (int i3 = 0; i3 < bytes.length; ++i3) {
            if (bytes[i3] != 0) continue;
            String string2 = new String(bytes, nextStringPos, i3 - nextStringPos, StandardCharsets.UTF_8);
            strings[stringsAdded++] = string2;
            nextStringPos = i3 + 1;
        }
        if (nextStringPos < bytes.length) {
            String string3 = new String(bytes, nextStringPos, bytes.length - nextStringPos, StandardCharsets.UTF_8);
            strings[stringsAdded++] = string3;
        }
        return strings;
    }

    public byte[] encodeValue(ByteOrder byteOrder, String ... values) throws ImageWriteException {
        return FieldType.ASCII.writeData(values, byteOrder);
    }
}

