/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.util;

import java.awt.color.ICC_Profile;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class Debug {
    private static final boolean DEBUG = false;
    private static final String NEWLINE = "\r\n";
    private static long counter;

    public static void debug(String message) {
    }

    public static void debug() {
    }

    private static String getDebug(String message, int[] v2) {
        StringBuilder result2 = new StringBuilder();
        if (v2 == null) {
            result2.append(message + " (" + null + ")" + NEWLINE);
        } else {
            result2.append(message + " (" + v2.length + ")" + NEWLINE);
            for (int element : v2) {
                result2.append("\t" + element + NEWLINE);
            }
            result2.append(NEWLINE);
        }
        return result2.toString();
    }

    private static String getDebug(String message, byte[] v2) {
        int max = 250;
        return Debug.getDebug(message, v2, 250);
    }

    private static String getDebug(String message, byte[] v2, int max) {
        StringBuilder result2 = new StringBuilder();
        if (v2 == null) {
            result2.append(message + " (" + null + ")" + NEWLINE);
        } else {
            result2.append(message + " (" + v2.length + ")" + NEWLINE);
            for (int i2 = 0; i2 < max && i2 < v2.length; ++i2) {
                int b2 = 0xFF & v2[i2];
                char c2 = b2 == 0 || b2 == 10 || b2 == 11 || b2 == 13 ? (char)' ' : (char)((char)b2);
                result2.append("\t" + i2 + ": " + b2 + " (" + c2 + ", 0x" + Integer.toHexString(b2) + ")" + NEWLINE);
            }
            if (v2.length > max) {
                result2.append("\t...\r\n");
            }
            result2.append(NEWLINE);
        }
        return result2.toString();
    }

    private static String getDebug(String message, char[] v2) {
        StringBuilder result2 = new StringBuilder();
        if (v2 == null) {
            result2.append(message + " (" + null + ")" + NEWLINE);
        } else {
            result2.append(message + " (" + v2.length + ")" + NEWLINE);
            for (char element : v2) {
                result2.append("\t" + element + " (" + (0xFF & element) + ")" + NEWLINE);
            }
            result2.append(NEWLINE);
        }
        return result2.toString();
    }

    private static void debug(String message, Map<?, ?> map2) {
        Debug.debug(Debug.getDebug(message, map2));
    }

    private static String getDebug(String message, Map<?, ?> map2) {
        StringBuilder result2 = new StringBuilder();
        if (map2 == null) {
            return message + " map: " + null;
        }
        ArrayList keys = new ArrayList(map2.keySet());
        result2.append(message + " map: " + keys.size() + NEWLINE);
        for (int i2 = 0; i2 < keys.size(); ++i2) {
            Object key = keys.get(i2);
            Object value = map2.get(key);
            result2.append("\t" + i2 + ": '" + key + "' -> '" + value + "'" + NEWLINE);
        }
        result2.append(NEWLINE);
        return result2.toString();
    }

    private static String byteQuadToString(int bytequad) {
        byte b1 = (byte)(bytequad >> 24 & 0xFF);
        byte b2 = (byte)(bytequad >> 16 & 0xFF);
        byte b3 = (byte)(bytequad >> 8 & 0xFF);
        byte b4 = (byte)(bytequad >> 0 & 0xFF);
        char c1 = (char)b1;
        char c2 = (char)b2;
        char c3 = (char)b3;
        char c4 = (char)b4;
        StringBuilder buffer = new StringBuilder(31);
        buffer.append(new String(new char[]{c1, c2, c3, c4}));
        buffer.append(" bytequad: ");
        buffer.append(bytequad);
        buffer.append(" b1: ");
        buffer.append(b1);
        buffer.append(" b2: ");
        buffer.append(b2);
        buffer.append(" b3: ");
        buffer.append(b3);
        buffer.append(" b4: ");
        buffer.append(b4);
        return buffer.toString();
    }

    public static void debug(String message, Object value) {
        if (value == null) {
            Debug.debug(message, "null");
        } else if (value instanceof char[]) {
            Debug.debug(message, (char[])value);
        } else if (value instanceof byte[]) {
            Debug.debug(message, (byte[])value);
        } else if (value instanceof int[]) {
            Debug.debug(message, (int[])value);
        } else if (value instanceof String) {
            Debug.debug(message, (String)value);
        } else if (value instanceof List) {
            Debug.debug(message, (List)value);
        } else if (value instanceof Map) {
            Debug.debug(message, (Map)value);
        } else if (value instanceof ICC_Profile) {
            Debug.debug(message, (ICC_Profile)value);
        } else if (value instanceof File) {
            Debug.debug(message, (File)value);
        } else if (value instanceof Date) {
            Debug.debug(message, (Date)value);
        } else if (value instanceof Calendar) {
            Debug.debug(message, (Calendar)value);
        } else {
            Debug.debug(message, value.toString());
        }
    }

    private static void debug(String message, byte[] v2) {
        Debug.debug(Debug.getDebug(message, v2));
    }

    private static void debug(String message, char[] v2) {
        Debug.debug(Debug.getDebug(message, v2));
    }

    private static void debug(String message, Calendar value) {
        SimpleDateFormat df2 = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss", Locale.ENGLISH);
        Debug.debug(message, value == null ? "null" : df2.format(value.getTime()));
    }

    private static void debug(String message, Date value) {
        SimpleDateFormat df2 = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss", Locale.ENGLISH);
        Debug.debug(message, value == null ? "null" : df2.format(value));
    }

    private static void debug(String message, File file) {
        Debug.debug(message + ": " + (file == null ? "null" : file.getPath()));
    }

    private static void debug(String message, ICC_Profile value) {
        Debug.debug("ICC_Profile " + message + ": " + (value == null ? "null" : value.toString()));
        if (value != null) {
            Debug.debug("\t getProfileClass: " + Debug.byteQuadToString(value.getProfileClass()));
            Debug.debug("\t getPCSType: " + Debug.byteQuadToString(value.getPCSType()));
            Debug.debug("\t getColorSpaceType() : " + Debug.byteQuadToString(value.getColorSpaceType()));
        }
    }

    private static void debug(String message, int[] v2) {
        Debug.debug(Debug.getDebug(message, v2));
    }

    private static void debug(String message, List<?> v2) {
        String suffix = " [" + counter++ + "]";
        Debug.debug(message + " (" + v2.size() + ")" + suffix);
        for (Object aV2 : v2) {
            Debug.debug("\t" + aV2.toString() + suffix);
        }
        Debug.debug();
    }

    private static void debug(String message, String value) {
        Debug.debug(message + " " + value);
    }

    public static void debug(Throwable e2) {
        Debug.debug(Debug.getDebug(e2));
    }

    public static void debug(Throwable e2, int value) {
        Debug.debug(Debug.getDebug(e2, value));
    }

    private static String getDebug(Throwable e2) {
        return Debug.getDebug(e2, -1);
    }

    private static String getDebug(Throwable e2, int max) {
        StringBuilder result2 = new StringBuilder(35);
        SimpleDateFormat timestamp2 = new SimpleDateFormat("yyyy-MM-dd kk:mm:ss:SSS", Locale.ENGLISH);
        String datetime = timestamp2.format(new Date()).toLowerCase();
        result2.append(NEWLINE);
        result2.append("Throwable: " + (e2 == null ? "" : "(" + e2.getClass().getName() + ")") + ":" + datetime + NEWLINE);
        result2.append("Throwable: " + (e2 == null ? "null" : e2.getLocalizedMessage()) + NEWLINE);
        result2.append(NEWLINE);
        result2.append(Debug.getStackTrace(e2, max));
        result2.append("Caught here:\r\n");
        result2.append(Debug.getStackTrace(new Exception(), max, 1));
        result2.append(NEWLINE);
        return result2.toString();
    }

    private static String getStackTrace(Throwable e2, int limit) {
        return Debug.getStackTrace(e2, limit, 0);
    }

    private static String getStackTrace(Throwable e2, int limit, int skip) {
        StringBuilder result2 = new StringBuilder();
        if (e2 != null) {
            StackTraceElement[] stes = e2.getStackTrace();
            if (stes != null) {
                for (int i2 = skip; i2 < stes.length && (limit < 0 || i2 < limit); ++i2) {
                    StackTraceElement ste = stes[i2];
                    result2.append("\tat " + ste.getClassName() + "." + ste.getMethodName() + "(" + ste.getFileName() + ":" + ste.getLineNumber() + ")" + NEWLINE);
                }
                if (limit >= 0 && stes.length > limit) {
                    result2.append("\t...\r\n");
                }
            }
            result2.append(NEWLINE);
        }
        return result2.toString();
    }

    private Debug() {
    }
}

