/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.directive;

import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import org.apache.velocity.Template;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.TemplateInitException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.directive.StopCommand;
import org.apache.velocity.runtime.parser.ParseException;
import org.apache.velocity.runtime.parser.node.Node;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.util.introspection.Info;

public class Evaluate
extends Directive {
    @Override
    public String getName() {
        return "evaluate";
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public void init(RuntimeServices rs, InternalContextAdapter context, Node node) throws TemplateInitException {
        super.init(rs, context, node);
        int argCount = node.jjtGetNumChildren();
        if (argCount == 0) {
            throw new TemplateInitException("#" + this.getName() + "() requires exactly one argument", null, this.rsvc.getLogContext().getStackTrace(), context.getCurrentTemplateName(), node.getColumn(), node.getLine());
        }
        if (argCount > 1) {
            throw new TemplateInitException("#" + this.getName() + "() requires exactly one argument", null, this.rsvc.getLogContext().getStackTrace(), context.getCurrentTemplateName(), node.jjtGetChild(1).getColumn(), node.jjtGetChild(1).getLine());
        }
        Node childNode = node.jjtGetChild(0);
        if (childNode.getType() != 9 && childNode.getType() != 20) {
            throw new TemplateInitException("#" + this.getName() + "()  argument must be a string literal or reference", null, this.rsvc.getLogContext().getStackTrace(), context.getCurrentTemplateName(), childNode.getColumn(), childNode.getLine());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean render(InternalContextAdapter context, Writer writer, Node node) throws IOException, ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        Object value = node.jjtGetChild(0).value(context);
        String sourceText = value != null ? value.toString() : "";
        String templateName = context.getCurrentTemplateName();
        Template template2 = (Template)context.getCurrentResource();
        if (template2 == null) {
            template2 = new Template();
            template2.setName(templateName);
        }
        SimpleNode nodeTree = null;
        try {
            nodeTree = this.rsvc.parse(new StringReader(sourceText), template2);
        }
        catch (TemplateInitException | ParseException pex) {
            Info info = new Info(templateName, node.getLine(), node.getColumn());
            throw new ParseErrorException(pex.getMessage(), info, this.rsvc.getLogContext().getStackTrace());
        }
        if (nodeTree != null) {
            context.pushCurrentTemplateName(templateName);
            try {
                try {
                    nodeTree.init(context, this.rsvc);
                }
                catch (TemplateInitException pex) {
                    Info info = new Info(templateName, node.getLine(), node.getColumn());
                    throw new ParseErrorException(pex.getMessage(), info, this.rsvc.getLogContext().getStackTrace());
                }
                try {
                    this.preRender(context);
                    nodeTree.render(context, writer);
                }
                catch (StopCommand stop2) {
                    if (!stop2.isFor(this)) {
                        throw stop2;
                    }
                }
                catch (ParseErrorException pex) {
                    Info info = new Info(templateName, node.getLine(), node.getColumn());
                    throw new ParseErrorException(pex.getMessage(), info, this.rsvc.getLogContext().getStackTrace());
                }
            }
            finally {
                context.popCurrentTemplateName();
                this.postRender(context);
            }
            return true;
        }
        return false;
    }
}

