/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.resource.loader;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.apache.velocity.shaded.commons.io.FilenameUtils;
import org.apache.velocity.util.ExtProperties;

public class FileResourceLoader
extends ResourceLoader {
    private List<String> paths = new ArrayList<String>();
    private Map<String, String> templatePaths = Collections.synchronizedMap(new HashMap());

    @Override
    public void init(ExtProperties configuration) {
        this.log.trace("FileResourceLoader: initialization starting.");
        this.paths.addAll(configuration.getVector("path"));
        ListIterator<String> it = this.paths.listIterator();
        while (it.hasNext()) {
            String path = StringUtils.trim((String)it.next());
            it.set(path);
            this.log.debug("FileResourceLoader: adding path '{}'", (Object)path);
        }
        this.log.trace("FileResourceLoader: initialization complete.");
    }

    @Override
    public Reader getResourceReader(String templateName, String encoding) throws ResourceNotFoundException {
        if (StringUtils.isEmpty((CharSequence)templateName)) {
            throw new ResourceNotFoundException("Need to specify a file name or file path!");
        }
        String template2 = FilenameUtils.normalize(templateName, true);
        if (template2 == null || template2.length() == 0) {
            String msg = "File resource error: argument " + template2 + " contains .. and may be trying to access content outside of template root.  Rejected.";
            this.log.error("FileResourceLoader: {}", (Object)msg);
            throw new ResourceNotFoundException(msg);
        }
        int size = this.paths.size();
        for (String path : this.paths) {
            InputStream rawStream = null;
            Reader reader = null;
            try {
                rawStream = this.findTemplate(path, template2);
                if (rawStream != null) {
                    reader = this.buildReader(rawStream, encoding);
                }
            }
            catch (IOException ioe) {
                this.closeQuiet(rawStream);
                String msg = "Exception while loading Template " + template2;
                this.log.error(msg, (Throwable)ioe);
                throw new VelocityException(msg, ioe, this.rsvc.getLogContext().getStackTrace());
            }
            if (reader == null) continue;
            this.templatePaths.put(templateName, path);
            return reader;
        }
        throw new ResourceNotFoundException("FileResourceLoader: cannot find " + template2);
    }

    @Override
    public boolean resourceExists(String name) {
        if (name == null) {
            return false;
        }
        if ((name = FilenameUtils.normalize(name)) == null || name.length() == 0) {
            return false;
        }
        int size = this.paths.size();
        for (String path : this.paths) {
            try {
                File file = this.getFile(path, name);
                if (!file.canRead()) continue;
                return true;
            }
            catch (Exception ioe) {
                this.log.debug("Exception while checking for template {}", (Object)name);
            }
        }
        return false;
    }

    private InputStream findTemplate(String path, String template2) throws IOException {
        try {
            File file = this.getFile(path, template2);
            if (file.canRead()) {
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(file.getAbsolutePath());
                    return fis;
                }
                catch (IOException e2) {
                    this.closeQuiet(fis);
                    throw e2;
                }
            }
            return null;
        }
        catch (FileNotFoundException fnfe) {
            return null;
        }
    }

    private void closeQuiet(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isSourceModified(Resource resource2) {
        boolean modified = true;
        String fileName = resource2.getName();
        String path = this.templatePaths.get(fileName);
        File currentFile = null;
        for (int i2 = 0; currentFile == null && i2 < this.paths.size(); ++i2) {
            String testPath = this.paths.get(i2);
            File testFile = this.getFile(testPath, fileName);
            if (!testFile.canRead()) continue;
            currentFile = testFile;
        }
        File file = this.getFile(path, fileName);
        if (currentFile != null && file.exists() && currentFile.equals(file) && file.canRead()) {
            modified = file.lastModified() != resource2.getLastModified();
        }
        return modified;
    }

    @Override
    public long getLastModified(Resource resource2) {
        String path = this.templatePaths.get(resource2.getName());
        File file = this.getFile(path, resource2.getName());
        if (file.canRead()) {
            return file.lastModified();
        }
        return 0L;
    }

    private File getFile(String path, String template2) {
        File file = null;
        if ("".equals(path)) {
            file = new File(template2);
        } else {
            if (template2.startsWith("/")) {
                template2 = template2.substring(1);
            }
            file = new File(path, template2);
        }
        return file;
    }
}

