/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util.introspection;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.commons.lang3.Validate;
import org.apache.velocity.util.introspection.ClassFieldMap;
import org.apache.velocity.util.introspection.ClassMap;
import org.apache.velocity.util.introspection.IntrospectorCache;
import org.apache.velocity.util.introspection.MethodMap;
import org.apache.velocity.util.introspection.TypeConversionHandler;
import org.slf4j.Logger;

public abstract class IntrospectorBase {
    protected final Logger log;
    private final IntrospectorCache introspectorCache;

    protected IntrospectorBase(Logger log2, TypeConversionHandler conversionHandler) {
        this.log = log2;
        this.introspectorCache = new IntrospectorCache(log2, conversionHandler);
    }

    public Method getMethod(Class<?> c2, String name, Object[] params) throws MethodMap.AmbiguousException {
        IntrospectorCache ic = this.getIntrospectorCache();
        ClassMap classMap = ic.get((Class)Validate.notNull(c2, (String)"class object is null!", (Object[])new Object[0]));
        if (classMap == null) {
            classMap = ic.put(c2);
        }
        return classMap.findMethod(name, (Object[])Validate.notNull((Object)params, (String)"params object is null!", (Object[])new Object[0]));
    }

    public Field getField(Class<?> c2, String name) throws IllegalArgumentException {
        IntrospectorCache ic = this.getIntrospectorCache();
        ClassFieldMap classFieldMap = ic.getFieldMap((Class)Validate.notNull(c2, (String)"class object is null!", (Object[])new Object[0]));
        if (classFieldMap == null) {
            ic.put(c2);
            classFieldMap = ic.getFieldMap(c2);
        }
        return classFieldMap.findField(name);
    }

    protected IntrospectorCache getIntrospectorCache() {
        return this.introspectorCache;
    }
}

