/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util.introspection;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.apache.velocity.util.introspection.ClassFieldMap;
import org.apache.velocity.util.introspection.ClassMap;
import org.apache.velocity.util.introspection.TypeConversionHandler;
import org.slf4j.Logger;

public final class IntrospectorCache {
    public static final String CACHEDUMP_MSG = "IntrospectorCache detected classloader change. Dumping cache.";
    private final Logger log;
    private final Map<Class<?>, ClassMap> classMapCache = new HashMap();
    private final Map<Class<?>, ClassFieldMap> classFieldMapCache = new HashMap();
    private final Set<String> classNameCache = new HashSet<String>();
    private final TypeConversionHandler conversionHandler;

    public IntrospectorCache(Logger log2, TypeConversionHandler conversionHandler) {
        this.log = log2;
        this.conversionHandler = conversionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<Class<?>, ClassMap> map2 = this.classMapCache;
        synchronized (map2) {
            this.classMapCache.clear();
            this.classFieldMapCache.clear();
            this.classNameCache.clear();
            this.log.debug(CACHEDUMP_MSG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassMap get(Class<?> c2) {
        ClassMap classMap = this.classMapCache.get(Validate.notNull(c2));
        if (classMap == null) {
            Map<Class<?>, ClassMap> map2 = this.classMapCache;
            synchronized (map2) {
                if (this.classNameCache.contains(c2.getName())) {
                    this.clear();
                }
            }
        }
        return classMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassFieldMap getFieldMap(Class<?> c2) {
        ClassFieldMap classFieldMap = this.classFieldMapCache.get(Validate.notNull(c2));
        if (classFieldMap == null) {
            Map<Class<?>, ClassMap> map2 = this.classMapCache;
            synchronized (map2) {
                if (this.classNameCache.contains(c2.getName())) {
                    this.clear();
                }
            }
        }
        return classFieldMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassMap put(Class<?> c2) {
        ClassMap classMap = new ClassMap(c2, this.log, this.conversionHandler);
        ClassFieldMap classFieldMap = new ClassFieldMap(c2, this.log);
        Map<Class<?>, ClassMap> map2 = this.classMapCache;
        synchronized (map2) {
            this.classMapCache.put(c2, classMap);
            this.classFieldMapCache.put(c2, classFieldMap);
            this.classNameCache.add(c2.getName());
        }
        return classMap;
    }
}

