/*
 * Decompiled with CFR 0.152.
 */
package org.cef.misc;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.cef.network.CefPostData;
import org.cef.network.CefPostDataElement;
import org.cef.network.CefRequest;
import org.cef.network.CefResponse;

public class DebugFormatter {
    public static String toString_PostData(String mimeType, CefPostData pd) {
        Vector<CefPostDataElement> elements = new Vector<CefPostDataElement>();
        pd.getElements(elements);
        Object returnValue = "";
        for (CefPostDataElement el : elements) {
            returnValue = (String)returnValue + DebugFormatter.toString_PostDataElement(mimeType, el) + "\n";
        }
        return returnValue;
    }

    public static String toString_PostDataElement(String mimeType, CefPostDataElement e2) {
        int bytesCnt = e2.getBytesCount();
        byte[] bytes = null;
        if (bytesCnt > 0) {
            bytes = new byte[bytesCnt];
        }
        boolean asText = false;
        if (mimeType != null) {
            if (mimeType.startsWith("text/")) {
                asText = true;
            } else if (mimeType.startsWith("application/xml")) {
                asText = true;
            } else if (mimeType.startsWith("application/xhtml")) {
                asText = true;
            } else if (mimeType.startsWith("application/x-www-form-urlencoded")) {
                asText = true;
            }
        }
        Object returnValue = "";
        if (e2.getType() == CefPostDataElement.Type.PDE_TYPE_BYTES) {
            int setBytes = e2.getBytes(bytes.length, bytes);
            returnValue = (String)returnValue + "    Content-Length: " + bytesCnt + "\n";
            if (asText) {
                returnValue = (String)returnValue + "\n    " + new String(bytes);
            } else {
                for (int i2 = 0; i2 < setBytes; ++i2) {
                    if (i2 % 40 == 0) {
                        returnValue = (String)returnValue + "\n    ";
                    }
                    returnValue = (String)returnValue + String.format("%02X", bytes[i2]) + " ";
                }
            }
            returnValue = (String)returnValue + "\n";
        } else if (e2.getType() == CefPostDataElement.Type.PDE_TYPE_FILE) {
            returnValue = (String)returnValue + "\n    Bytes of file: " + e2.getFile() + "\n";
        }
        return returnValue;
    }

    public static String toString_Request(CefRequest request) {
        Object returnValue = "\nHTTP-Request";
        returnValue = (String)returnValue + "\n  flags: " + request.getFlags();
        returnValue = (String)returnValue + "\n  resourceType: " + request.getResourceType();
        returnValue = (String)returnValue + "\n  transitionType: " + request.getTransitionType();
        returnValue = (String)returnValue + "\n  firstPartyForCookies: " + request.getFirstPartyForCookies();
        returnValue = (String)returnValue + "\n  referrerURL: " + request.getReferrerURL();
        returnValue = (String)returnValue + "\n  referrerPolicy: " + request.getReferrerPolicy();
        returnValue = (String)returnValue + "\n    " + request.getMethod() + " " + request.getURL() + " HTTP/1.1\n";
        HashMap<String, String> headerMap = new HashMap<String, String>();
        request.getHeaderMap(headerMap);
        Set entrySet = headerMap.entrySet();
        String mimeType = null;
        for (Map.Entry entry : entrySet) {
            String key = (String)entry.getKey();
            returnValue = (String)returnValue + "    " + key + "=" + (String)entry.getValue() + "\n";
            if (!key.equals("Content-Type")) continue;
            mimeType = (String)entry.getValue();
        }
        CefPostData pd = request.getPostData();
        if (pd != null) {
            returnValue = (String)returnValue + DebugFormatter.toString_PostData(mimeType, pd);
        }
        return returnValue;
    }

    public static String toString_Response(CefResponse response) {
        Object returnValue = "\nHTTP-Response:";
        returnValue = (String)returnValue + "\n  error: " + response.getError();
        returnValue = (String)returnValue + "\n  readOnly: " + response.isReadOnly();
        returnValue = (String)returnValue + "\n    HTTP/1.1 " + response.getStatus() + " " + response.getStatusText();
        returnValue = (String)returnValue + "\n    Content-Type: " + response.getMimeType();
        HashMap<String, String> headerMap = new HashMap<String, String>();
        response.getHeaderMap(headerMap);
        Set entrySet = headerMap.entrySet();
        for (Map.Entry entry : entrySet) {
            returnValue = (String)returnValue + "    " + (String)entry.getKey() + "=" + (String)entry.getValue() + "\n";
        }
        return returnValue;
    }
}

