/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.flavours.gfm;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.flavours.gfm.GFMTokenTypes;
import org.intellij.markdown.html.GeneratingProvider;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.html.entities.EntityConverter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0005H\u0004J \u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0004J$\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u00060\u0010R\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\f\u0010\u0012\u001a\u00020\n*\u00020\nH\u0004J\f\u0010\u0013\u001a\u00020\n*\u00020\nH\u0004\u00a8\u0006\u0014"}, d2={"Lorg/intellij/markdown/flavours/gfm/TableAwareCodeSpanGeneratingProvider;", "Lorg/intellij/markdown/html/GeneratingProvider;", "()V", "collectContentNodes", "", "Lorg/intellij/markdown/ast/ASTNode;", "node", "isInsideTable", "", "processChild", "", "text", "", "processNode", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/html/HtmlGenerator;", "replaceNewLines", "trimForCodeSpan", "markdown"})
public class TableAwareCodeSpanGeneratingProvider
implements GeneratingProvider {
    @Override
    public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        boolean isInsideTable = this.isInsideTable(node);
        List<ASTNode> nodes2 = this.collectContentNodes(node);
        CharSequence output2 = this.trimForCodeSpan(CollectionsKt.joinToString$default((Iterable)nodes2, (CharSequence)"", null, null, (int)0, null, (Function1)((Function1)new Function1<ASTNode, CharSequence>(this, text, isInsideTable){
            final /* synthetic */ TableAwareCodeSpanGeneratingProvider this$0;
            final /* synthetic */ String $text;
            final /* synthetic */ boolean $isInsideTable;
            {
                this.this$0 = $receiver;
                this.$text = $text;
                this.$isInsideTable = $isInsideTable;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull ASTNode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.this$0.replaceNewLines(this.this$0.processChild(it, this.$text, this.$isInsideTable));
            }
        }), (int)30, null));
        HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default(visitor, node, "code", new CharSequence[0], false, 8, null);
        visitor.consumeHtml(output2);
        visitor.consumeTagClose("code");
    }

    @NotNull
    protected final CharSequence replaceNewLines(@NotNull CharSequence $this$replaceNewLines) {
        Intrinsics.checkNotNullParameter((Object)$this$replaceNewLines, (String)"<this>");
        CharSequence charSequence = $this$replaceNewLines;
        Regex regex2 = new Regex("\\r\\n?|\\n");
        String string2 = " ";
        return regex2.replace(charSequence, string2);
    }

    @NotNull
    protected final CharSequence trimForCodeSpan(@NotNull CharSequence $this$trimForCodeSpan) {
        Intrinsics.checkNotNullParameter((Object)$this$trimForCodeSpan, (String)"<this>");
        return StringsKt.isBlank((CharSequence)$this$trimForCodeSpan) ? $this$trimForCodeSpan : StringsKt.removeSurrounding((CharSequence)$this$trimForCodeSpan, (CharSequence)" ", (CharSequence)" ");
    }

    protected final boolean isInsideTable(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        IElementType[] iElementTypeArray = new IElementType[]{GFMTokenTypes.CELL};
        return ASTUtilKt.getParentOfType(node, iElementTypeArray) != null;
    }

    @NotNull
    protected final List<ASTNode> collectContentNodes(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (!(node.getChildren().size() >= 2)) {
            String string2 = "Check failed.";
            throw new IllegalStateException(string2.toString());
        }
        return node.getChildren().subList(1, node.getChildren().size() - 1);
    }

    @NotNull
    protected final CharSequence processChild(@NotNull ASTNode node, @NotNull String text, boolean isInsideTable) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (!isInsideTable) {
            return HtmlGenerator.Companion.leafText(text, node, false);
        }
        String nodeText = ((Object)ASTUtilKt.getTextInNode(node, text)).toString();
        String escaped = StringsKt.replace$default((String)nodeText, (String)"\\|", (String)"|", (boolean)false, (int)4, null);
        return EntityConverter.INSTANCE.replaceEntities(escaped, false, false);
    }
}

