/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.html.entities;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.intellij.markdown.html.entities.Entities;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/intellij/markdown/html/entities/EntityConverter;", "", "()V", "REGEX", "Lkotlin/text/Regex;", "REGEX_ESCAPES", "escapeAllowedString", "", "replacements", "", "", "replaceEntities", "text", "", "processEntities", "", "processEscapes", "markdown"})
public final class EntityConverter {
    @NotNull
    public static final EntityConverter INSTANCE = new EntityConverter();
    @NotNull
    private static final String escapeAllowedString = "!\"#\\$%&'\\(\\)\\*\\+,\\-.\\/:;<=>\\?@\\[\\\\\\]\\^_`{\\|}~";
    @NotNull
    private static final Map<Character, String> replacements;
    @NotNull
    private static final Regex REGEX;
    @NotNull
    private static final Regex REGEX_ESCAPES;

    private EntityConverter() {
    }

    @NotNull
    public final String replaceEntities(@NotNull CharSequence text, boolean processEntities, boolean processEscapes) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return (processEscapes ? REGEX_ESCAPES : REGEX).replace(text, (Function1)new Function1<MatchResult, CharSequence>(processEntities){
            final /* synthetic */ boolean $processEntities;
            {
                this.$processEntities = $processEntities;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull MatchResult match2) {
                CharSequence charSequence;
                Intrinsics.checkNotNullParameter((Object)match2, (String)"match");
                MatchGroupCollection g2 = match2.getGroups();
                if (g2.size() > 5 && g2.get(5) != null) {
                    MatchGroup matchGroup = g2.get(5);
                    Intrinsics.checkNotNull((Object)matchGroup);
                    char c2 = matchGroup.getValue().charAt(0);
                    String string2 = (String)EntityConverter.access$getReplacements$p().get(Character.valueOf(c2));
                    if (string2 == null) {
                        string2 = String.valueOf(c2);
                    }
                    charSequence = string2;
                } else if (g2.get(4) != null) {
                    Map map2 = EntityConverter.access$getReplacements$p();
                    MatchGroup matchGroup = g2.get(4);
                    Intrinsics.checkNotNull((Object)matchGroup);
                    String string3 = (String)map2.get(Character.valueOf(matchGroup.getValue().charAt(0)));
                    if (string3 == null) {
                        string3 = match2.getValue();
                    }
                    charSequence = string3;
                } else {
                    String string4;
                    Character c3;
                    Integer code2;
                    Integer n2;
                    if (!this.$processEntities) {
                        n2 = null;
                    } else if (g2.get(1) != null) {
                        n2 = Entities.INSTANCE.getMap().get(match2.getValue());
                    } else if (g2.get(2) != null) {
                        MatchGroup matchGroup = g2.get(2);
                        Intrinsics.checkNotNull((Object)matchGroup);
                        n2 = Integer.parseInt(matchGroup.getValue());
                    } else if (g2.get(3) != null) {
                        MatchGroup matchGroup = g2.get(3);
                        Intrinsics.checkNotNull((Object)matchGroup);
                        n2 = Integer.parseInt(matchGroup.getValue(), CharsKt.checkRadix((int)16));
                    } else {
                        n2 = null;
                    }
                    Integer n3 = code2 = n2;
                    Character c4 = c3 = n3 != null ? Character.valueOf((char)n3.intValue()) : null;
                    if (c3 != null) {
                        string4 = (String)EntityConverter.access$getReplacements$p().get(c3);
                        if (string4 == null) {
                            string4 = c3.toString();
                        }
                    } else {
                        StringBuilder stringBuilder = new StringBuilder().append("&amp;");
                        String string5 = match2.getValue().substring(1);
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                        string4 = stringBuilder.append(string5).toString();
                    }
                    charSequence = string4;
                }
                return charSequence;
            }
        });
    }

    public static final /* synthetic */ Map access$getReplacements$p() {
        return replacements;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Character.valueOf('\"'), (Object)"&quot;"), TuplesKt.to((Object)Character.valueOf('&'), (Object)"&amp;"), TuplesKt.to((Object)Character.valueOf('<'), (Object)"&lt;"), TuplesKt.to((Object)Character.valueOf('>'), (Object)"&gt;")};
        replacements = MapsKt.mapOf((Pair[])pairArray);
        REGEX = new Regex("&(?:([a-zA-Z0-9]+)|#([0-9]{1,8})|#[xX]([a-fA-F0-9]{1,8}));|([\"&<>])");
        REGEX_ESCAPES = new Regex(REGEX.getPattern() + "|\\\\([!\"#\\$%&'\\(\\)\\*\\+,\\-.\\/:;<=>\\?@\\[\\\\\\]\\^_`{\\|}~])");
    }
}

