/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.sequentialparsers.impl;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.parser.sequentialparsers.LocalParsingResult;
import org.intellij.markdown.parser.sequentialparsers.RangesListBuilder;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.markdown.parser.sequentialparsers.TokensCache;
import org.intellij.markdown.parser.sequentialparsers.impl.LinkParserUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/intellij/markdown/parser/sequentialparsers/impl/ReferenceLinkParser;", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser;", "()V", "parse", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser$ParsingResult;", "tokens", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "rangesToGlue", "", "Lkotlin/ranges/IntRange;", "Companion", "markdown"})
public final class ReferenceLinkParser
implements SequentialParser {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public SequentialParser.ParsingResult parse(@NotNull TokensCache tokens, @NotNull List<IntRange> rangesToGlue) {
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        Intrinsics.checkNotNullParameter(rangesToGlue, (String)"rangesToGlue");
        SequentialParser.ParsingResultBuilder result2 = new SequentialParser.ParsingResultBuilder();
        RangesListBuilder delegateIndices = new RangesListBuilder();
        TokensCache.Iterator iterator2 = new TokensCache.RangesListIterator(tokens, rangesToGlue);
        while (iterator2.getType() != null) {
            LocalParsingResult referenceLink;
            if (Intrinsics.areEqual((Object)iterator2.getType(), (Object)MarkdownTokenTypes.LBRACKET) && (referenceLink = Companion.parseReferenceLink(iterator2)) != null) {
                iterator2 = referenceLink.getIteratorPosition().advance();
                result2 = result2.withOtherParsingResult(referenceLink);
                continue;
            }
            delegateIndices.put(iterator2.getIndex());
            iterator2 = iterator2.advance();
        }
        return result2.withFurtherProcessing(delegateIndices.get());
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00042\n\u0010\u0005\u001a\u00060\u0006R\u00020\u0007H\u0002J\u0014\u0010\b\u001a\u0004\u0018\u00010\u00042\n\u0010\u0005\u001a\u00060\u0006R\u00020\u0007J\u0016\u0010\t\u001a\u0004\u0018\u00010\u00042\n\u0010\u0005\u001a\u00060\u0006R\u00020\u0007H\u0002\u00a8\u0006\n"}, d2={"Lorg/intellij/markdown/parser/sequentialparsers/impl/ReferenceLinkParser$Companion;", "", "()V", "parseFullReferenceLink", "Lorg/intellij/markdown/parser/sequentialparsers/LocalParsingResult;", "iterator", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache$Iterator;", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "parseReferenceLink", "parseShortReferenceLink", "markdown"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final LocalParsingResult parseReferenceLink(@NotNull TokensCache.Iterator iterator2) {
            Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
            LocalParsingResult localParsingResult = this.parseFullReferenceLink(iterator2);
            if (localParsingResult == null) {
                localParsingResult = this.parseShortReferenceLink(iterator2);
            }
            return localParsingResult;
        }

        private final LocalParsingResult parseFullReferenceLink(TokensCache.Iterator iterator2) {
            int startIndex = iterator2.getIndex();
            LocalParsingResult localParsingResult = LinkParserUtil.Companion.parseLinkText(iterator2);
            if (localParsingResult == null) {
                return null;
            }
            LocalParsingResult linkText = localParsingResult;
            TokensCache.Iterator it = linkText.getIteratorPosition().advance();
            if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.EOL)) {
                it = it.advance();
            }
            LocalParsingResult localParsingResult2 = LinkParserUtil.Companion.parseLinkLabel(it);
            if (localParsingResult2 == null) {
                return null;
            }
            LocalParsingResult linkLabel = localParsingResult2;
            it = linkLabel.getIteratorPosition();
            return new LocalParsingResult(it, (Collection<SequentialParser.Node>)CollectionsKt.plus((Collection)CollectionsKt.plus(linkText.getParsedNodes(), (Iterable)linkLabel.getParsedNodes()), (Object)new SequentialParser.Node(new IntRange(startIndex, it.getIndex() + 1), MarkdownElementTypes.FULL_REFERENCE_LINK)), CollectionsKt.plus(linkText.getRangesToProcessFurther(), (Iterable)linkLabel.getRangesToProcessFurther()));
        }

        private final LocalParsingResult parseShortReferenceLink(TokensCache.Iterator iterator2) {
            TokensCache.Iterator it;
            int startIndex = iterator2.getIndex();
            LocalParsingResult localParsingResult = LinkParserUtil.Companion.parseLinkLabel(iterator2);
            if (localParsingResult == null) {
                return null;
            }
            LocalParsingResult linkLabel = localParsingResult;
            TokensCache.Iterator shortcutLinkEnd = it = linkLabel.getIteratorPosition();
            if (Intrinsics.areEqual((Object)(it = it.advance()).getType(), (Object)MarkdownTokenTypes.EOL)) {
                it = it.advance();
            }
            it = Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.LBRACKET) && Intrinsics.areEqual((Object)it.rawLookup(1), (Object)MarkdownTokenTypes.RBRACKET) ? it.advance() : shortcutLinkEnd;
            return new LocalParsingResult(it, (Collection<SequentialParser.Node>)CollectionsKt.plus(linkLabel.getParsedNodes(), (Object)new SequentialParser.Node(new IntRange(startIndex, it.getIndex() + 1), MarkdownElementTypes.SHORT_REFERENCE_LINK)), linkLabel.getRangesToProcessFurther());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

