/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.function;

import java.util.List;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.Navigator;

public class NamespaceUriFunction
implements Function {
    public Object call(Context context, List args) throws FunctionCallException {
        if (args.size() == 0) {
            return NamespaceUriFunction.evaluate(context.getNodeSet(), context.getNavigator());
        }
        if (args.size() == 1) {
            return NamespaceUriFunction.evaluate(args, context.getNavigator());
        }
        throw new FunctionCallException("namespace-uri() requires zero or one argument.");
    }

    public static String evaluate(List list, Navigator nav2) throws FunctionCallException {
        if (!list.isEmpty()) {
            Object first2 = list.get(0);
            if (first2 instanceof List) {
                return NamespaceUriFunction.evaluate((List)first2, nav2);
            }
            if (nav2.isElement(first2)) {
                return nav2.getElementNamespaceUri(first2);
            }
            if (nav2.isAttribute(first2)) {
                String uri = nav2.getAttributeNamespaceUri(first2);
                if (uri == null) {
                    return "";
                }
                return uri;
            }
            if (nav2.isProcessingInstruction(first2)) {
                return "";
            }
            if (nav2.isNamespace(first2)) {
                return "";
            }
            if (nav2.isDocument(first2)) {
                return "";
            }
            if (nav2.isComment(first2)) {
                return "";
            }
            if (nav2.isText(first2)) {
                return "";
            }
            throw new FunctionCallException("The argument to the namespace-uri function must be a node-set");
        }
        return "";
    }
}

