/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import org.jdesktop.swingx.HorizontalLayout;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.VerticalLayout;

public class JXCollapsiblePane
extends JXPanel {
    public static final String ANIMATION_STATE_KEY = "animationState";
    public static final String TOGGLE_ACTION = "toggle";
    public static final String COLLAPSE_ICON = "collapseIcon";
    public static final String EXPAND_ICON = "expandIcon";
    private boolean collapsed = false;
    private Direction direction = Direction.UP;
    private Timer animateTimer;
    private AnimationListener animator;
    private int currentDimension = -1;
    private WrapperContainer wrapper;
    private boolean useAnimation = true;
    private AnimationParams animationParams;

    public JXCollapsiblePane() {
        this(Direction.UP, new BorderLayout(0, 0));
    }

    public JXCollapsiblePane(Direction direction) {
        this(direction, new BorderLayout(0, 0));
    }

    public JXCollapsiblePane(LayoutManager layout) {
        this(Direction.UP, layout);
    }

    public JXCollapsiblePane(Direction direction, LayoutManager layout) {
        super.setLayout(layout);
        this.direction = direction;
        this.animator = new AnimationListener();
        this.setAnimationParams(new AnimationParams(30, 8, 0.01f, 1.0f));
        JXPanel panel = new JXPanel();
        this.setContentPane(panel);
        this.setDirection(direction);
        this.getActionMap().put(TOGGLE_ACTION, new ToggleAction());
    }

    public void setContentPane(Container contentPanel) {
        if (contentPanel == null) {
            throw new IllegalArgumentException("Content pane can't be null");
        }
        if (this.wrapper != null) {
            assert (super.getComponent(0) == this.wrapper);
            super.remove(0);
        }
        this.wrapper = new WrapperContainer(contentPanel);
        this.wrapper.collapsedState = this.isCollapsed();
        super.addImpl(this.wrapper, "Center", -1);
    }

    public Container getContentPane() {
        if (this.wrapper == null) {
            return null;
        }
        return (Container)this.wrapper.getView();
    }

    @Override
    public void setLayout(LayoutManager mgr) {
        if (this.wrapper != null) {
            this.getContentPane().setLayout(mgr);
        }
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        this.getContentPane().add(comp, constraints, index);
    }

    @Override
    public void remove(Component comp) {
        this.getContentPane().remove(comp);
    }

    @Override
    public void remove(int index) {
        this.getContentPane().remove(index);
    }

    @Override
    public void removeAll() {
        this.getContentPane().removeAll();
    }

    public void setAnimated(boolean animated) {
        if (animated != this.useAnimation) {
            this.useAnimation = animated;
            if (!animated) {
                if (this.animateTimer.isRunning()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JXCollapsiblePane.this.currentDimension = -1;
                        }
                    });
                } else {
                    this.currentDimension = -1;
                }
            }
            this.firePropertyChange("animated", !this.useAnimation, this.useAnimation);
        }
    }

    public boolean isAnimated() {
        return this.useAnimation;
    }

    public void setDirection(Direction direction) {
        if (this.animateTimer.isRunning()) {
            throw new IllegalStateException("cannot be change direction while collapsing.");
        }
        Direction oldValue = this.getDirection();
        this.direction = direction;
        if (direction.isVertical()) {
            this.getContentPane().setLayout(new VerticalLayout(2));
        } else {
            this.getContentPane().setLayout(new HorizontalLayout(2));
        }
        this.firePropertyChange("direction", (Object)oldValue, (Object)this.getDirection());
    }

    public Direction getDirection() {
        return this.direction;
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public void setCollapsed(boolean val) {
        if (this.collapsed != val) {
            this.collapsed = val;
            if (this.isAnimated()) {
                if (this.collapsed) {
                    int dimension = this.direction.isVertical() ? this.wrapper.getHeight() : this.wrapper.getWidth();
                    this.setAnimationParams(new AnimationParams(30, Math.max(8, dimension / 10), 1.0f, 0.01f));
                    this.animator.reinit(dimension, 0);
                    this.animateTimer.start();
                } else {
                    int dimension = this.direction.isVertical() ? this.wrapper.getHeight() : this.wrapper.getWidth();
                    int preferredDimension = this.direction.isVertical() ? this.getContentPane().getPreferredSize().height : this.getContentPane().getPreferredSize().width;
                    int delta = Math.max(8, preferredDimension / 10);
                    this.setAnimationParams(new AnimationParams(30, delta, 0.01f, 1.0f));
                    this.animator.reinit(dimension, preferredDimension);
                    this.wrapper.getView().setVisible(true);
                    this.animateTimer.start();
                }
            } else {
                this.wrapper.collapsedState = this.collapsed;
                this.wrapper.getView().setVisible(!this.collapsed);
                this.revalidate();
            }
            this.repaint();
            this.firePropertyChange("collapsed", !this.collapsed, this.collapsed);
        }
    }

    @Override
    public Border getBorder() {
        if (this.getContentPane() instanceof JComponent) {
            return ((JComponent)this.getContentPane()).getBorder();
        }
        return null;
    }

    @Override
    public void setBorder(Border border) {
        if (this.getContentPane() instanceof JComponent) {
            ((JComponent)this.getContentPane()).setBorder(border);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void setMinimumSize(Dimension minimumSize) {
        this.getContentPane().setMinimumSize(minimumSize);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = this.getContentPane().getPreferredSize();
        if (this.currentDimension != -1) {
            if (this.direction.isVertical()) {
                dim.height = this.currentDimension;
            } else {
                dim.width = this.currentDimension;
            }
        } else if (this.wrapper.collapsedState) {
            if (this.direction.isVertical()) {
                dim.height = 0;
            } else {
                dim.width = 0;
            }
        }
        return dim;
    }

    @Override
    public void setPreferredSize(Dimension preferredSize) {
        this.getContentPane().setPreferredSize(preferredSize);
    }

    private void setAnimationParams(AnimationParams params) {
        if (params == null) {
            throw new IllegalArgumentException("params can't be null");
        }
        if (this.animateTimer != null) {
            this.animateTimer.stop();
        }
        this.animationParams = params;
        this.animateTimer = new Timer(this.animationParams.waitTime, this.animator);
        this.animateTimer.setInitialDelay(0);
    }

    private final class WrapperContainer
    extends JViewport {
        float alpha = 1.0f;
        boolean collapsedState = false;

        public WrapperContainer(Container c2) {
            this.setView(c2);
            if (c2 instanceof JComponent && !c2.isOpaque()) {
                ((JComponent)c2).setOpaque(true);
            }
        }

        @Override
        public void scrollRectToVisible(Rectangle aRect) {
            JXCollapsiblePane.this.scrollRectToVisible(aRect);
        }
    }

    private final class AnimationListener
    implements ActionListener {
        private final Object ANIMATION_MUTEX = "Animation Synchronization Mutex";
        private int startDimension = 0;
        private int finalDimension = 0;
        private float animateAlpha = 1.0f;

        private AnimationListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e2) {
            Object object = this.ANIMATION_MUTEX;
            synchronized (object) {
                if (this.startDimension == this.finalDimension) {
                    JXCollapsiblePane.this.animateTimer.stop();
                    this.animateAlpha = ((JXCollapsiblePane)JXCollapsiblePane.this).animationParams.alphaEnd;
                    if (this.finalDimension > 0) {
                        JXCollapsiblePane.this.currentDimension = -1;
                        ((JXCollapsiblePane)JXCollapsiblePane.this).wrapper.collapsedState = false;
                        this.validate();
                        JXCollapsiblePane.this.firePropertyChange(JXCollapsiblePane.ANIMATION_STATE_KEY, null, "expanded");
                        return;
                    }
                    ((JXCollapsiblePane)JXCollapsiblePane.this).wrapper.collapsedState = true;
                    JXCollapsiblePane.this.wrapper.getView().setVisible(false);
                    JXCollapsiblePane.this.firePropertyChange(JXCollapsiblePane.ANIMATION_STATE_KEY, null, "collapsed");
                }
                boolean contracting = this.startDimension > this.finalDimension;
                int delta = contracting ? -1 * ((JXCollapsiblePane)JXCollapsiblePane.this).animationParams.delta : ((JXCollapsiblePane)JXCollapsiblePane.this).animationParams.delta;
                int newDimension = JXCollapsiblePane.this.direction.isVertical() ? JXCollapsiblePane.this.wrapper.getHeight() + delta : JXCollapsiblePane.this.wrapper.getWidth() + delta;
                if (contracting) {
                    if (newDimension < this.finalDimension) {
                        newDimension = this.finalDimension;
                    }
                } else if (newDimension > this.finalDimension) {
                    newDimension = this.finalDimension;
                }
                int dimension = JXCollapsiblePane.this.direction.isVertical() ? ((JXCollapsiblePane)JXCollapsiblePane.this).wrapper.getView().getPreferredSize().height : ((JXCollapsiblePane)JXCollapsiblePane.this).wrapper.getView().getPreferredSize().width;
                this.animateAlpha = (float)newDimension / (float)dimension;
                Rectangle bounds = JXCollapsiblePane.this.wrapper.getBounds();
                if (JXCollapsiblePane.this.direction.isVertical()) {
                    int oldHeight = bounds.height;
                    bounds.height = newDimension;
                    JXCollapsiblePane.this.wrapper.setBounds(bounds);
                    if (JXCollapsiblePane.this.direction == Direction.DOWN) {
                        JXCollapsiblePane.this.wrapper.setViewPosition(new Point(0, ((JXCollapsiblePane)JXCollapsiblePane.this).wrapper.getView().getPreferredSize().height - newDimension));
                    } else {
                        JXCollapsiblePane.this.wrapper.setViewPosition(new Point(0, newDimension));
                    }
                    bounds = JXCollapsiblePane.this.getBounds();
                    bounds.height = bounds.height - oldHeight + newDimension;
                    JXCollapsiblePane.this.currentDimension = bounds.height;
                } else {
                    int oldWidth = bounds.width;
                    bounds.width = newDimension;
                    JXCollapsiblePane.this.wrapper.setBounds(bounds);
                    if (JXCollapsiblePane.this.direction == Direction.RIGHT) {
                        JXCollapsiblePane.this.wrapper.setViewPosition(new Point(((JXCollapsiblePane)JXCollapsiblePane.this).wrapper.getView().getPreferredSize().width - newDimension, 0));
                    } else {
                        JXCollapsiblePane.this.wrapper.setViewPosition(new Point(newDimension, 0));
                    }
                    bounds = JXCollapsiblePane.this.getBounds();
                    bounds.width = bounds.width - oldWidth + newDimension;
                    JXCollapsiblePane.this.currentDimension = bounds.width;
                }
                JXCollapsiblePane.this.setBounds(bounds);
                this.startDimension = newDimension;
                if (contracting) {
                    if (this.animateAlpha < ((JXCollapsiblePane)JXCollapsiblePane.this).animationParams.alphaEnd) {
                        this.animateAlpha = ((JXCollapsiblePane)JXCollapsiblePane.this).animationParams.alphaEnd;
                    }
                    if (this.animateAlpha > ((JXCollapsiblePane)JXCollapsiblePane.this).animationParams.alphaStart) {
                        this.animateAlpha = ((JXCollapsiblePane)JXCollapsiblePane.this).animationParams.alphaStart;
                    }
                } else {
                    if (this.animateAlpha > ((JXCollapsiblePane)JXCollapsiblePane.this).animationParams.alphaEnd) {
                        this.animateAlpha = ((JXCollapsiblePane)JXCollapsiblePane.this).animationParams.alphaEnd;
                    }
                    if (this.animateAlpha < ((JXCollapsiblePane)JXCollapsiblePane.this).animationParams.alphaStart) {
                        this.animateAlpha = ((JXCollapsiblePane)JXCollapsiblePane.this).animationParams.alphaStart;
                    }
                }
                ((JXCollapsiblePane)JXCollapsiblePane.this).wrapper.alpha = this.animateAlpha;
                this.validate();
            }
        }

        void validate() {
            Container parent = SwingUtilities.getAncestorOfClass(CollapsiblePaneContainer.class, JXCollapsiblePane.this);
            parent = parent != null ? ((CollapsiblePaneContainer)((Object)parent)).getValidatingContainer() : JXCollapsiblePane.this.getParent();
            if (parent != null) {
                if (parent instanceof JComponent) {
                    ((JComponent)parent).revalidate();
                } else {
                    parent.invalidate();
                }
                parent.doLayout();
                parent.repaint();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reinit(int startDimension, int stopDimension) {
            Object object = this.ANIMATION_MUTEX;
            synchronized (object) {
                JXCollapsiblePane.this.firePropertyChange(JXCollapsiblePane.ANIMATION_STATE_KEY, null, "reinit");
                this.startDimension = startDimension;
                this.finalDimension = stopDimension;
                this.animateAlpha = ((JXCollapsiblePane)JXCollapsiblePane.this).animationParams.alphaStart;
                JXCollapsiblePane.this.currentDimension = -1;
            }
        }
    }

    private static class AnimationParams {
        final int waitTime;
        final int delta;
        final float alphaStart;
        final float alphaEnd;

        public AnimationParams(int waitTime, int delta, float alphaStart, float alphaEnd) {
            this.waitTime = waitTime;
            this.delta = delta;
            this.alphaStart = alphaStart;
            this.alphaEnd = alphaEnd;
        }
    }

    public static interface CollapsiblePaneContainer {
        public Container getValidatingContainer();
    }

    private class ToggleAction
    extends AbstractAction
    implements PropertyChangeListener {
        public ToggleAction() {
            super(JXCollapsiblePane.TOGGLE_ACTION);
            JXCollapsiblePane.this.addPropertyChangeListener("collapsed", this);
        }

        @Override
        public void putValue(String key, Object newValue) {
            super.putValue(key, newValue);
            if (JXCollapsiblePane.EXPAND_ICON.equals(key) || JXCollapsiblePane.COLLAPSE_ICON.equals(key)) {
                this.updateIcon();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            JXCollapsiblePane.this.setCollapsed(!JXCollapsiblePane.this.isCollapsed());
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.updateIcon();
        }

        void updateIcon() {
            if (JXCollapsiblePane.this.isCollapsed()) {
                this.putValue("SmallIcon", this.getValue(JXCollapsiblePane.EXPAND_ICON));
            } else {
                this.putValue("SmallIcon", this.getValue(JXCollapsiblePane.COLLAPSE_ICON));
            }
        }
    }

    public static enum Direction {
        LEFT(false),
        RIGHT(false),
        UP(true),
        DOWN(true);

        private final boolean vertical;

        private Direction(boolean vertical) {
            this.vertical = vertical;
        }

        public boolean isVertical() {
            return this.vertical;
        }
    }
}

