/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.swingx.color.ColorUtil;
import org.jdesktop.swingx.color.EyeDropperColorChooserPanel;
import org.jdesktop.swingx.plaf.UIManagerExt;
import org.jdesktop.swingx.util.OS;

public class JXColorSelectionButton
extends JButton {
    private BufferedImage colorwell;
    private JDialog dialog = null;
    private JColorChooser chooser = null;

    public JXColorSelectionButton() {
        this(Color.red);
    }

    public JXColorSelectionButton(Color col2) {
        this.setBackground(col2);
        this.addActionListener(new ActionHandler());
        this.setContentAreaFilled(false);
        this.setOpaque(false);
        try {
            this.colorwell = ImageIO.read(this.getClass().getResourceAsStream("color/colorwell.png"));
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
        }
        this.addPropertyChangeListener("background", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JXColorSelectionButton.this.getChooser().setColor(JXColorSelectionButton.this.getBackground());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g2) {
        Color FILL_COLOR;
        Color color = FILL_COLOR = this.isEnabled() ? ColorUtil.removeAlpha(this.getBackground()) : UIManagerExt.getSafeColor("Button.disabledForeground", Color.LIGHT_GRAY);
        if (OS.isMacOSX() && this.colorwell != null) {
            Insets ins2 = new Insets(5, 5, 5, 5);
            ColorUtil.tileStretchPaint(g2, this, this.colorwell, ins2);
            g2.setColor(FILL_COLOR);
            g2.fillRect(ins2.left, ins2.top, this.getWidth() - ins2.left - ins2.right, this.getHeight() - ins2.top - ins2.bottom);
            g2.setColor(ColorUtil.setBrightness(FILL_COLOR, 0.85f));
            g2.drawRect(ins2.left, ins2.top, this.getWidth() - ins2.left - ins2.right - 1, this.getHeight() - ins2.top - ins2.bottom - 1);
            g2.drawRect(ins2.left + 1, ins2.top + 1, this.getWidth() - ins2.left - ins2.right - 3, this.getHeight() - ins2.top - ins2.bottom - 3);
        } else {
            Graphics2D g22 = (Graphics2D)g2.create();
            try {
                g22.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g22.setColor(Color.LIGHT_GRAY);
                int DIAM = Math.min(this.getWidth(), this.getHeight());
                int inset = 3;
                g22.fill(new Ellipse2D.Float(3.0f, 3.0f, DIAM - 6, DIAM - 6));
                g22.setColor(FILL_COLOR);
                boolean border = true;
                g22.fill(new Ellipse2D.Float(4.0f, 4.0f, DIAM - 6 - 2, DIAM - 6 - 2));
            }
            finally {
                g22.dispose();
            }
        }
    }

    private void showDialog() {
        final Color oldColor = this.getBackground();
        if (this.dialog == null) {
            this.dialog = JColorChooser.createDialog(this, "Choose a color", true, this.getChooser(), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Color color = JXColorSelectionButton.this.getChooser().getColor();
                    if (color != null) {
                        JXColorSelectionButton.this.setBackground(color);
                    }
                }
            }, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JXColorSelectionButton.this.setBackground(oldColor);
                }
            });
            this.dialog.getContentPane().add(this.getChooser());
            this.getChooser().getSelectionModel().addChangeListener(new ColorChangeListener(this));
        }
        this.dialog.setVisible(true);
    }

    public JColorChooser getChooser() {
        if (this.chooser == null) {
            this.chooser = new JColorChooser();
            this.chooser.addChooserPanel(new EyeDropperColorChooserPanel());
        }
        return this.chooser;
    }

    public void setChooser(JColorChooser chooser) {
        JColorChooser oldChooser = this.getChooser();
        this.chooser = chooser;
        this.firePropertyChange("chooser", oldChooser, chooser);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet() || this.colorwell == null) {
            return super.getPreferredSize();
        }
        return new Dimension(this.colorwell.getWidth(), this.colorwell.getHeight());
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JXColorSelectionButton.this.showDialog();
        }
    }

    private class ColorChangeListener
    implements ChangeListener {
        public JXColorSelectionButton button;

        public ColorChangeListener(JXColorSelectionButton button2) {
            this.button = button2;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.button.setBackground(this.button.getChooser().getColor());
        }
    }
}

