/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.action;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;

class ToggleActionPropertyChangeListener
implements PropertyChangeListener {
    private WeakReference<AbstractButton> buttonRef;

    public ToggleActionPropertyChangeListener(Action action, AbstractButton button2) {
        if (this.shouldAddListener(action, button2)) {
            this.buttonRef = new WeakReference<AbstractButton>(button2);
            action.addPropertyChangeListener(this);
        }
    }

    protected synchronized boolean shouldAddListener(Action action, AbstractButton button2) {
        this.releasePCLs(action);
        return !this.isToggling(action, button2);
    }

    protected boolean isToggling(Action action, AbstractButton button2) {
        if (!(action instanceof AbstractAction)) {
            return false;
        }
        PropertyChangeListener[] listeners = ((AbstractAction)action).getPropertyChangeListeners();
        for (int i2 = listeners.length - 1; i2 >= 0; --i2) {
            if (!(listeners[i2] instanceof ToggleActionPropertyChangeListener) || !((ToggleActionPropertyChangeListener)listeners[i2]).isToggling(button2)) continue;
            return true;
        }
        return false;
    }

    protected void releasePCLs(Action action) {
        if (!(action instanceof AbstractAction)) {
            return;
        }
        PropertyChangeListener[] listeners = ((AbstractAction)action).getPropertyChangeListeners();
        for (int i2 = listeners.length - 1; i2 >= 0; --i2) {
            if (!(listeners[i2] instanceof ToggleActionPropertyChangeListener)) continue;
            ((ToggleActionPropertyChangeListener)listeners[i2]).checkReferent(action);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        AbstractButton button2 = this.checkReferent((Action)evt.getSource());
        if (button2 == null) {
            return;
        }
        String propertyName = evt.getPropertyName();
        if (propertyName.equals("selected")) {
            Boolean selected = (Boolean)evt.getNewValue();
            button2.setSelected(selected);
        }
    }

    protected AbstractButton checkReferent(Action action) {
        AbstractButton button2 = null;
        if (this.buttonRef != null) {
            button2 = (AbstractButton)this.buttonRef.get();
        }
        if (button2 == null) {
            if (action != null) {
                action.removePropertyChangeListener(this);
            }
            this.buttonRef = null;
        }
        return button2;
    }

    public boolean isToggling(AbstractButton button2) {
        return button2.equals(this.checkReferent(null));
    }
}

